/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Annotation;
import mondrian.olap.CellFormatter;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SubstitutingMemberReader;
import mondrian.rolap.sql.SqlQuery;
import mondrian.util.UnionIterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapHierarchy
extends HierarchyBase {
    private static final Logger LOGGER = Logger.getLogger(RolapHierarchy.class);
    private MemberReader memberReader;
    protected MondrianDef.Hierarchy xmlHierarchy;
    private String memberReaderClass;
    protected MondrianDef.RelationOrJoin relation;
    private Member defaultMember;
    private String defaultMemberName;
    private RolapNullMember nullMember;
    private String sharedHierarchyName;
    private String uniqueKeyLevelName;
    private Exp aggregateChildrenExpression;
    protected final RolapLevel nullLevel;
    private RolapMemberBase allMember;
    private static final String ALL_LEVEL_CARDINALITY = "1";
    private final Map<String, Annotation> annotationMap;
    final RolapHierarchy closureFor;

    RolapHierarchy(RolapDimension dimension, String subName, String caption, String description, boolean hasAll, RolapHierarchy closureFor, Map<String, Annotation> annotationMap) {
        super(dimension, subName, caption, description, hasAll);
        this.annotationMap = annotationMap;
        this.allLevelName = "(All)";
        this.allMemberName = subName != null && (MondrianProperties.instance().SsasCompatibleNaming.get() || this.name.equals(subName + "." + subName)) ? "All " + subName + "s" : "All " + this.name + "s";
        this.closureFor = closureFor;
        if (hasAll) {
            this.levels = new RolapLevel[1];
            this.levels[0] = new RolapLevel(this, this.allLevelName, null, null, 0, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, null, RolapLevel.HideMemberCondition.Never, LevelType.Regular, "", Collections.<String, Annotation>emptyMap());
        } else {
            this.levels = new RolapLevel[0];
        }
        this.nullLevel = new RolapLevel(this, this.allLevelName, null, null, 0, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, null, RolapLevel.HideMemberCondition.Never, LevelType.Null, "", Collections.<String, Annotation>emptyMap());
    }

    RolapHierarchy(RolapDimension dimension, MondrianDef.Hierarchy xmlHierarchy, MondrianDef.CubeDimension xmlCubeDimension) {
        this(dimension, xmlHierarchy.name, xmlHierarchy.caption, xmlHierarchy.description, xmlHierarchy.hasAll, null, RolapHierarchy.createAnnotationMap(xmlHierarchy.annotations));
        int i;
        assert (!(this instanceof RolapCubeHierarchy));
        this.xmlHierarchy = xmlHierarchy;
        this.relation = xmlHierarchy.relation;
        if (xmlHierarchy.relation instanceof MondrianDef.InlineTable) {
            this.relation = RolapUtil.convertInlineTableToRelation((MondrianDef.InlineTable)xmlHierarchy.relation, this.getRolapSchema().getDialect());
        }
        this.memberReaderClass = xmlHierarchy.memberReaderClass;
        this.uniqueKeyLevelName = xmlHierarchy.uniqueKeyLevelName;
        if (xmlHierarchy.allMemberName != null) {
            this.allMemberName = xmlHierarchy.allMemberName;
        }
        if (xmlHierarchy.allLevelName != null) {
            this.allLevelName = xmlHierarchy.allLevelName;
        }
        RolapLevel allLevel = new RolapLevel(this, this.allLevelName, null, null, 0, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, null, RolapLevel.HideMemberCondition.Never, LevelType.Regular, ALL_LEVEL_CARDINALITY, Collections.<String, Annotation>emptyMap());
        allLevel.init(xmlCubeDimension);
        this.allMember = new RolapMemberBase(null, allLevel, null, this.allMemberName, Member.MemberType.ALL);
        if (xmlHierarchy.allMemberCaption != null && xmlHierarchy.allMemberCaption.length() > 0) {
            this.allMember.setCaption(xmlHierarchy.allMemberCaption);
        }
        this.allMember.setOrdinal(0);
        if (xmlHierarchy.levels.length == 0) {
            throw MondrianResource.instance().HierarchyHasNoLevels.ex(this.getUniqueName());
        }
        HashSet<String> levelNameSet = new HashSet<String>();
        for (MondrianDef.Level level : xmlHierarchy.levels) {
            if (levelNameSet.add(level.name)) continue;
            throw MondrianResource.instance().HierarchyLevelNamesNotUnique.ex(this.getUniqueName(), level.name);
        }
        if (this.hasAll) {
            this.levels = new RolapLevel[xmlHierarchy.levels.length + 1];
            this.levels[0] = allLevel;
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                MondrianDef.Level xmlLevel = xmlHierarchy.levels[i];
                if (xmlLevel.getKeyExp() == null && xmlHierarchy.memberReaderClass == null) {
                    throw MondrianResource.instance().LevelMustHaveNameExpression.ex(xmlLevel.name);
                }
                this.levels[i + 1] = new RolapLevel(this, i + 1, xmlLevel);
            }
        } else {
            this.levels = new RolapLevel[xmlHierarchy.levels.length];
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                this.levels[i] = new RolapLevel(this, i, xmlHierarchy.levels[i]);
            }
        }
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            String sharedDimensionName;
            this.sharedHierarchyName = sharedDimensionName = ((MondrianDef.DimensionUsage)xmlCubeDimension).source;
            if (this.subName != null) {
                this.sharedHierarchyName = this.sharedHierarchyName + "." + this.subName;
            }
        } else {
            this.sharedHierarchyName = null;
        }
        if (xmlHierarchy.relation != null && xmlHierarchy.memberReaderClass != null) {
            throw MondrianResource.instance().HierarchyMustNotHaveMoreThanOneSource.ex(this.getUniqueName());
        }
        if (!Util.isEmpty(xmlHierarchy.caption)) {
            this.setCaption(xmlHierarchy.caption);
        }
        this.defaultMemberName = xmlHierarchy.defaultMember;
    }

    public static Map<String, Annotation> createAnnotationMap(MondrianDef.Annotations annotations) {
        if (annotations == null || annotations.array == null || annotations.array.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Annotation> map = new LinkedHashMap<String, Annotation>();
        for (MondrianDef.Annotation annotation : annotations.array) {
            final String name = annotation.name;
            final String value = annotation.cdata;
            map.put(annotation.name, new Annotation(){

                public String getName() {
                    return name;
                }

                public Object getValue() {
                    return value;
                }
            });
        }
        return map;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapHierarchy)) {
            return false;
        }
        RolapHierarchy that = (RolapHierarchy)o;
        if (this.sharedHierarchyName == null || that.sharedHierarchyName == null) {
            return false;
        }
        return this.sharedHierarchyName.equals(that.sharedHierarchyName) && this.getUniqueName().equals(that.getUniqueName());
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ (this.sharedHierarchyName == null ? 0 : this.sharedHierarchyName.hashCode());
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        if (this.memberReader == null) {
            this.memberReader = this.getRolapSchema().createMemberReader(this.sharedHierarchyName, this, this.memberReaderClass);
        }
        for (Level level : this.levels) {
            ((RolapLevel)level).init(xmlDimension);
        }
        if (this.defaultMemberName != null) {
            List<Id.Segment> uniqueNameParts = this.defaultMemberName.contains("[") ? Util.parseIdentifier(this.defaultMemberName) : Collections.singletonList(new Id.Segment(this.defaultMemberName, Id.Quoting.UNQUOTED));
            this.defaultMember = (Member)Util.lookupCompound(this.getRolapSchema().getSchemaReader(), this, uniqueNameParts, false, 6, MatchType.EXACT);
            if (this.defaultMember == null) {
                this.defaultMember = (Member)Util.lookupCompound(this.getRolapSchema().getSchemaReader(), new DummyElement(), uniqueNameParts, false, 6, MatchType.EXACT);
            }
            if (this.defaultMember == null) {
                throw Util.newInternal("Can not find Default Member with name \"" + this.defaultMemberName + "\" in Hierarchy \"" + this.getName() + "\"");
            }
        }
    }

    void setMemberReader(MemberReader memberReader) {
        this.memberReader = memberReader;
    }

    MemberReader getMemberReader() {
        return this.memberReader;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    RolapLevel newMeasuresLevel() {
        RolapLevel level = new RolapLevel(this, "MeasuresLevel", null, null, this.levels.length, null, null, null, null, null, null, null, RolapProperty.emptyArray, 0, null, RolapLevel.HideMemberCondition.Never, LevelType.Regular, "", Collections.<String, Annotation>emptyMap());
        this.levels = Util.append(this.levels, level);
        return level;
    }

    MondrianDef.Relation getUniqueTable() {
        if (this.relation instanceof MondrianDef.Relation) {
            return (MondrianDef.Relation)this.relation;
        }
        if (this.relation instanceof MondrianDef.Join) {
            return null;
        }
        throw Util.newInternal("hierarchy's relation is a " + ((Object)((Object)this.relation)).getClass());
    }

    boolean tableExists(String tableName) {
        return this.relation != null && RolapHierarchy.getTable(tableName, this.relation) != null;
    }

    MondrianDef.Relation getTable(String tableName) {
        return this.relation == null ? null : RolapHierarchy.getTable(tableName, this.relation);
    }

    private static MondrianDef.Relation getTable(String tableName, MondrianDef.RelationOrJoin relationOrJoin) {
        if (relationOrJoin instanceof MondrianDef.Relation) {
            MondrianDef.Relation relation = (MondrianDef.Relation)relationOrJoin;
            if (relation.getAlias().equals(tableName)) {
                return relation;
            }
            return null;
        }
        MondrianDef.Join join = (MondrianDef.Join)relationOrJoin;
        MondrianDef.Relation rel = RolapHierarchy.getTable(tableName, join.left);
        if (rel != null) {
            return rel;
        }
        return RolapHierarchy.getTable(tableName, join.right);
    }

    public RolapSchema getRolapSchema() {
        return (RolapSchema)this.dimension.getSchema();
    }

    public MondrianDef.RelationOrJoin getRelation() {
        return this.relation;
    }

    public MondrianDef.Hierarchy getXmlHierarchy() {
        return this.xmlHierarchy;
    }

    @Override
    public Member getDefaultMember() {
        if (this.defaultMember == null) {
            List<RolapMember> rootMembers = this.memberReader.getRootMembers();
            SchemaReader schemaReader = this.getRolapSchema().getSchemaReader();
            List calcMemberList = Util.cast(schemaReader.getCalculatedMembers(this.getLevels()[0]));
            for (RolapMember rootMember : UnionIterator.over(new Collection[]{rootMembers, calcMemberList})) {
                if (rootMember.isHidden()) continue;
                this.defaultMember = rootMember;
                break;
            }
            if (this.defaultMember == null) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(this.getUniqueName());
            }
        }
        return this.defaultMember;
    }

    @Override
    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new RolapNullMember(this.nullLevel);
        }
        return this.nullMember;
    }

    @Override
    public RolapMember getAllMember() {
        return this.allMember;
    }

    @Override
    public Member createMember(Member parent, Level level, String name, Formula formula) {
        if (formula == null) {
            return new RolapMemberBase((RolapMember)parent, (RolapLevel)level, name);
        }
        if (level.getDimension().isMeasures()) {
            return new RolapCalculatedMeasure((RolapMember)parent, (RolapLevel)level, name, formula);
        }
        return new RolapCalculatedMember((RolapMember)parent, (RolapLevel)level, name, formula);
    }

    String getAlias() {
        return this.getName();
    }

    public String getSharedHierarchyName() {
        return this.sharedHierarchyName;
    }

    void addToFromInverse(SqlQuery query, MondrianDef.Expression expression) {
        if (this.relation == null) {
            throw Util.newError("cannot add hierarchy " + this.getUniqueName() + " to query: it does not have a <Table>, <View> or <Join>");
        }
        boolean failIfExists = false;
        MondrianDef.RelationOrJoin subRelation = this.relation;
        if (this.relation instanceof MondrianDef.Join && expression != null) {
            subRelation = RolapHierarchy.relationSubsetInverse(this.relation, expression.getTableAlias());
        }
        query.addFrom(subRelation, null, false);
    }

    void addToFrom(SqlQuery query, MondrianDef.Expression expression) {
        if (this.relation == null) {
            throw Util.newError("cannot add hierarchy " + this.getUniqueName() + " to query: it does not have a <Table>, <View> or <Join>");
        }
        boolean failIfExists = false;
        MondrianDef.RelationOrJoin subRelation = this.relation;
        if (this.relation instanceof MondrianDef.Join && expression != null) {
            subRelation = RolapHierarchy.relationSubset(this.relation, expression.getTableAlias());
        }
        query.addFrom(subRelation, null, false);
    }

    void addToFrom(SqlQuery query, RolapStar.Table table) {
        RolapStar.Condition joinCondition;
        boolean tableAdded;
        if (this.getRelation() == null) {
            throw Util.newError("cannot add hierarchy " + this.getUniqueName() + " to query: it does not have a <Table>, <View> or <Join>");
        }
        boolean failIfExists = false;
        MondrianDef.RelationOrJoin subRelation = null;
        if (table != null) {
            subRelation = RolapHierarchy.lookupRelationSubset(this.getRelation(), table);
        }
        if (subRelation == null) {
            subRelation = this.getRelation();
        }
        if ((tableAdded = query.addFrom(subRelation, null, false)) && table != null && (joinCondition = table.getJoinCondition()) != null) {
            query.addWhere(joinCondition);
        }
    }

    private static MondrianDef.RelationOrJoin relationSubsetInverse(MondrianDef.RelationOrJoin relation, String alias) {
        if (relation instanceof MondrianDef.Relation) {
            MondrianDef.Relation table = (MondrianDef.Relation)relation;
            return table.getAlias().equals(alias) ? relation : null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.RelationOrJoin leftRelation = RolapHierarchy.relationSubsetInverse(join.left, alias);
            return leftRelation == null ? RolapHierarchy.relationSubsetInverse(join.right, alias) : join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static MondrianDef.RelationOrJoin relationSubset(MondrianDef.RelationOrJoin relation, String alias) {
        if (relation instanceof MondrianDef.Relation) {
            MondrianDef.Relation table = (MondrianDef.Relation)relation;
            return table.getAlias().equals(alias) ? relation : null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.RelationOrJoin rightRelation = RolapHierarchy.relationSubset(join.right, alias);
            return rightRelation == null ? RolapHierarchy.relationSubset(join.left, alias) : join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static MondrianDef.RelationOrJoin lookupRelationSubset(MondrianDef.RelationOrJoin relation, RolapStar.Table targetTable) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            if (table.name.equals(targetTable.getTableName())) {
                return relation;
            }
            return null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.RelationOrJoin rightRelation = RolapHierarchy.lookupRelationSubset(join.right, targetTable);
            if (rightRelation == null) {
                return RolapHierarchy.lookupRelationSubset(join.left, targetTable);
            }
            return join;
        }
        return null;
    }

    MemberReader createMemberReader(Role role) {
        Access access = role.getAccess(this);
        switch (access) {
            case NONE: {
                role.getAccess(this);
                throw Util.newInternal("Illegal access to members of hierarchy " + this);
            }
            case ALL: {
                return this.isRagged() ? new RestrictedMemberReader(this.getMemberReader(), role) : this.getMemberReader();
            }
            case CUSTOM: {
                Role.HierarchyAccess hierarchyAccess = role.getAccessDetails(this);
                Role.RollupPolicy rollupPolicy = hierarchyAccess.getRollupPolicy();
                final NumericType returnType = new NumericType();
                switch (rollupPolicy) {
                    case FULL: {
                        return new RestrictedMemberReader(this.getMemberReader(), role);
                    }
                    case PARTIAL: {
                        MemberType memberType1 = new MemberType(this.getDimension(), this, null, null);
                        SetType setType = new SetType(memberType1);
                        AbstractMemberListCalc listCalc = new AbstractMemberListCalc(new DummyExp(setType), new Calc[0]){

                            @Override
                            public List<Member> evaluateMemberList(Evaluator evaluator) {
                                return FunUtil.getNonEmptyMemberChildren(evaluator, ((RolapEvaluator)evaluator).getExpanding());
                            }

                            @Override
                            public boolean dependsOn(Hierarchy hierarchy) {
                                return true;
                            }
                        };
                        final LimitedRollupAggregateCalc partialCalc = new LimitedRollupAggregateCalc(returnType, listCalc);
                        ResolvedFunCall partialExp = new ResolvedFunCall(new FunDefBase("$x", "x", "In"){

                            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                                return partialCalc;
                            }

                            public void unparse(Exp[] args, PrintWriter pw) {
                                pw.print("$RollupAccessibleChildren()");
                            }
                        }, new Exp[0], returnType);
                        return new LimitedRollupSubstitutingMemberReader(this.getMemberReader(), role, hierarchyAccess, partialExp);
                    }
                    case HIDDEN: {
                        ResolvedFunCall hiddenExp = new ResolvedFunCall(new FunDefBase("$x", "x", "In"){

                            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                                return new ConstantCalc(returnType, null);
                            }

                            public void unparse(Exp[] args, PrintWriter pw) {
                                pw.print("$RollupAccessibleChildren()");
                            }
                        }, new Exp[0], returnType);
                        return new LimitedRollupSubstitutingMemberReader(this.getMemberReader(), role, hierarchyAccess, hiddenExp);
                    }
                }
                throw Util.unexpected(rollupPolicy);
            }
        }
        throw Util.badValue(access);
    }

    @Override
    public boolean isRagged() {
        for (Level level : this.levels) {
            if (((RolapLevel)level).getHideMemberCondition() == RolapLevel.HideMemberCondition.Never) continue;
            return true;
        }
        return false;
    }

    synchronized Exp getAggregateChildrenExpression() {
        if (this.aggregateChildrenExpression == null) {
            UnresolvedFunCall fc = new UnresolvedFunCall("$AggregateChildren", Syntax.Internal, new Exp[]{new HierarchyExpr(this)});
            Validator validator = Util.createSimpleValidator(BuiltinFunTable.instance());
            this.aggregateChildrenExpression = fc.accept(validator);
        }
        return this.aggregateChildrenExpression;
    }

    RolapDimension createClosedPeerDimension(RolapLevel src, MondrianDef.Closure clos, MondrianDef.CubeDimension xmlDimension) {
        RolapDimension peerDimension = new RolapDimension(this.dimension.getSchema(), this.dimension.getName() + "$Closure", null, "Closure dimension for parent-child hierarchy " + this.getName(), DimensionType.StandardDimension, this.dimension.isHighCardinality(), Collections.<String, Annotation>emptyMap());
        RolapHierarchy peerHier = peerDimension.newHierarchy(null, true, this);
        peerHier.allMemberName = this.getAllMemberName();
        peerHier.allMember = (RolapMemberBase)this.getAllMember();
        peerHier.allLevelName = this.getAllLevelName();
        peerHier.sharedHierarchyName = this.getSharedHierarchyName();
        MondrianDef.Join join = new MondrianDef.Join();
        peerHier.relation = join;
        join.left = clos.table;
        join.leftKey = clos.parentColumn;
        join.right = this.relation;
        join.rightKey = clos.childColumn;
        int index = peerHier.levels.length;
        int flags = src.getFlags() & 0xFFFFFFFB;
        MondrianDef.Column keyExp = new MondrianDef.Column(clos.table.name, clos.parentColumn);
        RolapLevel level = new RolapLevel(peerHier, "Closure", this.caption, this.description, index++, keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags | 4, src.getDatatype(), src.getHideMemberCondition(), src.getLevelType(), "", Collections.<String, Annotation>emptyMap());
        peerHier.levels = Util.append(peerHier.levels, level);
        flags = src.getFlags() | 4;
        keyExp = new MondrianDef.Column(clos.table.name, clos.childColumn);
        RolapLevel sublevel = new RolapLevel(peerHier, "Item", null, null, index++, keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags, src.getDatatype(), src.getHideMemberCondition(), src.getLevelType(), "", Collections.<String, Annotation>emptyMap());
        peerHier.levels = Util.append(peerHier.levels, sublevel);
        return peerDimension;
    }

    public void setDefaultMember(Member defaultMember) {
        if (defaultMember != null) {
            this.defaultMember = defaultMember;
        }
    }

    public String getUniqueKeyLevelName() {
        return this.uniqueKeyLevelName;
    }

    public int getOrdinalInCube() {
        assert (this.dimension.isMeasures());
        return 0;
    }

    private class DummyElement
    implements OlapElement {
        private DummyElement() {
        }

        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "$";
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            if (Util.equalName(s.name, RolapHierarchy.this.dimension.getName())) {
                return RolapHierarchy.this.dimension;
            }
            if (Util.equalName(s.name, RolapHierarchy.this.dimension.getName() + "." + RolapHierarchy.this.subName)) {
                return RolapHierarchy.this;
            }
            return null;
        }

        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LimitedRollupAggregateCalc
    extends AggregateFunDef.AggregateCalc {
        public LimitedRollupAggregateCalc(Type returnType, ListCalc listCalc) {
            super(new DummyExp(returnType), listCalc, new ValueCalc(new DummyExp(returnType)));
        }
    }

    private static class LimitedRollupSubstitutingMemberReader
    extends SubstitutingMemberReader {
        private final Role.HierarchyAccess hierarchyAccess;
        private final Exp exp;

        public LimitedRollupSubstitutingMemberReader(MemberReader memberReader, Role role, Role.HierarchyAccess hierarchyAccess, Exp exp) {
            super(new RestrictedMemberReader(memberReader, role));
            this.hierarchyAccess = hierarchyAccess;
            this.exp = exp;
        }

        public RolapMember substitute(RolapMember member) {
            if (member != null && (this.hierarchyAccess.getAccess(member) == Access.CUSTOM || this.hierarchyAccess.hasInaccessibleDescendants(member))) {
                return new LimitedRollupMember((RolapCubeMember)member, this.exp);
            }
            return member;
        }

        public RolapMember desubstitute(RolapMember member) {
            if (member instanceof LimitedRollupMember) {
                return ((LimitedRollupMember)member).member;
            }
            return member;
        }
    }

    public static class LimitedRollupMember
    extends RolapCubeMember {
        public final RolapMember member;
        private final Exp exp;

        LimitedRollupMember(RolapCubeMember member, Exp exp) {
            super(member.getParentMember(), member.getRolapMember(), member.getLevel());
            assert (!(member instanceof LimitedRollupMember));
            this.member = member;
            this.exp = exp;
        }

        public boolean equals(Object o) {
            return o instanceof LimitedRollupMember && ((LimitedRollupMember)o).member.equals(this.member);
        }

        public Exp getExpression() {
            return this.exp;
        }

        protected boolean computeCalculated(Member.MemberType memberType) {
            return true;
        }

        public boolean isCalculated() {
            return false;
        }

        public boolean isEvaluated() {
            return true;
        }
    }

    protected static class RolapCalculatedMeasure
    extends RolapCalculatedMember
    implements RolapMeasure {
        private CellFormatter cellFormatter;

        public RolapCalculatedMeasure(RolapMember parent, RolapLevel level, String name, Formula formula) {
            super(parent, level, name, formula);
        }

        public synchronized void setProperty(String name, Object value) {
            if (name.equals(Property.CELL_FORMATTER.getName())) {
                String cellFormatterClass = (String)value;
                try {
                    this.cellFormatter = RolapCube.getCellFormatter(cellFormatterClass);
                }
                catch (Exception e) {
                    throw MondrianResource.instance().CellFormatterLoadFailed.ex(cellFormatterClass, this.getUniqueName(), e);
                }
            }
            super.setProperty(name, value);
        }

        public CellFormatter getFormatter() {
            return this.cellFormatter;
        }
    }

    static class RolapNullMember
    extends RolapMemberBase {
        RolapNullMember(RolapLevel level) {
            super(null, level, null, RolapUtil.mdxNullLiteral(), Member.MemberType.NULL);
            assert (level != null);
        }
    }
}

