/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.QuerySpec;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuerySpec
implements QuerySpec {
    private final RolapStar star;
    protected final boolean countOnly;

    protected AbstractQuerySpec(RolapStar star, boolean countOnly) {
        this.star = star;
        this.countOnly = countOnly;
    }

    protected SqlQuery newSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    @Override
    public RolapStar getStar() {
        return this.star;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String exprInner = measure.getExpression() == null ? "*" : measure.generateExprString(sqlQuery);
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        sqlQuery.addSelect(exprOuter, this.getMeasureAlias(i));
    }

    protected abstract boolean isAggregate();

    protected void nonDistinctGenerateSql(SqlQuery sqlQuery) {
        int i;
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        if (this.countOnly) {
            sqlQuery.addSelect("count(*)");
        }
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(sqlQuery, false, true);
            String expr = column.generateExprString(sqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), sqlQuery);
            if (!where.equals("true")) {
                sqlQuery.addWhere(where);
            }
            if (this.countOnly) continue;
            Dialect dialect = sqlQuery.getDialect();
            Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
            String alias = databaseProduct == Dialect.DatabaseProduct.DB2_AS400 ? sqlQuery.addSelect(expr, null) : sqlQuery.addSelect(expr, this.getColumnAlias(i));
            if (this.isAggregate()) {
                sqlQuery.addGroupBy(expr, alias);
            }
            if (!this.isOrdered()) continue;
            sqlQuery.addOrderBy(expr, true, false, false);
        }
        this.extraPredicates(sqlQuery);
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            this.addMeasure(i, sqlQuery);
        }
    }

    protected boolean isOrdered() {
        return false;
    }

    @Override
    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        int k = this.getDistinctMeasureCount();
        Dialect dialect = sqlQuery.getDialect();
        if (!dialect.allowsCountDistinct() && k > 0 || !dialect.allowsMultipleCountDistinct() && k > 1) {
            this.distinctGenerateSql(sqlQuery, this.countOnly);
        } else {
            this.nonDistinctGenerateSql(sqlQuery);
        }
        if (!this.countOnly) {
            this.addGroupingFunction(sqlQuery);
            this.addGroupingSets(sqlQuery);
        }
        return sqlQuery.toString();
    }

    protected void addGroupingFunction(SqlQuery sqlQuery) {
        throw new UnsupportedOperationException();
    }

    protected void addGroupingSets(SqlQuery sqlQuery) {
        throw new UnsupportedOperationException();
    }

    protected int getDistinctMeasureCount() {
        int k = 0;
        int count = this.getMeasureCount();
        for (int i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            if (!measure.getAggregator().isDistinct()) continue;
            ++k;
        }
        return k;
    }

    protected void distinctGenerateSql(SqlQuery outerSqlQuery, boolean countOnly) {
        int i;
        Dialect dialect = outerSqlQuery.getDialect();
        Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
        SqlQuery innerSqlQuery = this.newSqlQuery();
        if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
            innerSqlQuery.setDistinct(false);
        } else {
            innerSqlQuery.setDistinct(true);
        }
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(innerSqlQuery, false, true);
            String expr = column.generateExprString(innerSqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), innerSqlQuery);
            if (!where.equals("true")) {
                innerSqlQuery.addWhere(where);
            }
            if (countOnly) continue;
            String alias = "d" + i;
            innerSqlQuery.addSelect(expr, alias);
            if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
                innerSqlQuery.addGroupBy(expr, alias);
            }
            String quotedAlias = dialect.quoteIdentifier(alias);
            outerSqlQuery.addSelectGroupBy(quotedAlias);
        }
        this.extraPredicates(innerSqlQuery);
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
            measure.getTable().addToFrom(innerSqlQuery, false, true);
            String alias = this.getMeasureAlias(i);
            String expr = measure.generateExprString(outerSqlQuery);
            innerSqlQuery.addSelect(expr, alias);
            if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
                innerSqlQuery.addGroupBy(expr, alias);
            }
            outerSqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(dialect.quoteIdentifier(alias)));
        }
        outerSqlQuery.addFrom(innerSqlQuery, "dummyname", true);
    }

    protected void extraPredicates(SqlQuery sqlQuery) {
        List<StarPredicate> predicateList = this.getPredicateList();
        for (StarPredicate predicate : predicateList) {
            for (RolapStar.Column column : predicate.getConstrainedColumnList()) {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
            }
            StringBuilder buf = new StringBuilder();
            predicate.toSql(sqlQuery, buf);
            String where = buf.toString();
            if (where.equals("true")) continue;
            sqlQuery.addWhere(where);
        }
    }

    protected List<StarPredicate> getPredicateList() {
        return Collections.emptyList();
    }
}

