/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Aggregator;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggStar {
    private static final Logger LOGGER = Logger.getLogger(AggStar.class);
    private static final MondrianResource mres = MondrianResource.instance();
    private final RolapStar star;
    private final FactTable aggTable;
    private final BitKey bitKey;
    private final BitKey levelBitKey;
    private final BitKey measureBitKey;
    private final BitKey foreignKeyBitKey;
    private final BitKey distinctMeasureBitKey;
    private final Table.Column[] columns;
    private static final Logger JOIN_CONDITION_LOGGER = Logger.getLogger(Table.JoinCondition.class);

    static Logger getLogger() {
        return LOGGER;
    }

    public static AggStar makeAggStar(RolapStar star, JdbcSchema.Table dbTable, MessageRecorder msgRecorder) {
        JdbcSchema.Table.Column.Usage usage;
        AggStar aggStar = new AggStar(star, dbTable);
        FactTable aggStarFactTable = aggStar.getFactTable();
        Iterator<JdbcSchema.Table.Column.Usage> it = dbTable.getColumnUsages(JdbcSchema.UsageType.FACT_COUNT);
        while (it.hasNext()) {
            usage = it.next();
            aggStarFactTable.loadFactCount(usage);
        }
        it = dbTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
        while (it.hasNext()) {
            usage = it.next();
            aggStarFactTable.loadMeasure(usage);
        }
        it = dbTable.getColumnUsages(JdbcSchema.UsageType.FOREIGN_KEY);
        while (it.hasNext()) {
            usage = it.next();
            aggStarFactTable.loadForeignKey(usage);
        }
        it = dbTable.getColumnUsages(JdbcSchema.UsageType.LEVEL);
        while (it.hasNext()) {
            usage = it.next();
            aggStarFactTable.loadLevel(usage);
        }
        for (FactTable.Measure measure : aggStarFactTable.measures) {
            if (!measure.aggregator.isDistinct() || !(measure.argument instanceof MondrianDef.Column)) continue;
            AggStar.setLevelBits(measure.rollableLevelBitKey, aggStarFactTable, (MondrianDef.Column)measure.argument, star.getFactTable());
        }
        return aggStar;
    }

    private static void setLevelBits(BitKey bitKey, Table aggTable, MondrianDef.Column column, RolapStar.Table table) {
        HashSet<RolapStar.Column> columns = new HashSet<RolapStar.Column>();
        RolapStar.collectColumns(columns, table, column);
        ArrayList<Table.Level> levelList = new ArrayList<Table.Level>();
        AggStar.collectLevels(levelList, aggTable, null);
        for (Table.Level level : levelList) {
            if (!columns.contains(level.starColumn)) continue;
            bitKey.set(level.getBitPosition());
        }
    }

    private static void collectLevels(List<Table.Level> levelList, Table table, MondrianDef.Column joinColumn) {
        if (joinColumn == null) {
            levelList.addAll(table.levels);
        }
        for (DimTable dimTable : table.children) {
            if (joinColumn != null && !((Table)dimTable).getJoinCondition().left.equals(joinColumn)) continue;
            AggStar.collectLevels(levelList, dimTable, null);
        }
    }

    AggStar(RolapStar star, JdbcSchema.Table aggTable) {
        this.star = star;
        this.bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        this.levelBitKey = this.bitKey.emptyCopy();
        this.measureBitKey = this.bitKey.emptyCopy();
        this.foreignKeyBitKey = this.bitKey.emptyCopy();
        this.distinctMeasureBitKey = this.bitKey.emptyCopy();
        this.aggTable = new FactTable(aggTable);
        this.columns = new Table.Column[star.getColumnCount()];
    }

    public FactTable getFactTable() {
        return this.aggTable;
    }

    public Table findTable(String name) {
        FactTable table = this.getFactTable();
        return table.findDescendant(name);
    }

    public int getSize() {
        return MondrianProperties.instance().ChooseAggregateByVolume.get() ? this.getFactTable().getVolume() : this.getFactTable().getNumberOfRows();
    }

    void setForeignKey(int index) {
        this.foreignKeyBitKey.set(index);
    }

    public BitKey getForeignKeyBitKey() {
        return this.foreignKeyBitKey;
    }

    public boolean superSetMatch(BitKey bitKey) {
        return this.getBitKey().isSuperSetOf(bitKey);
    }

    public boolean select(BitKey levelBitKey, BitKey coreLevelBitKey, BitKey measureBitKey) {
        if (!this.getMeasureBitKey().isSuperSetOf(measureBitKey)) {
            return false;
        }
        if (this.getLevelBitKey().equals(levelBitKey)) {
            return true;
        }
        return this.getLevelBitKey().isSuperSetOf(levelBitKey) && this.getLevelBitKey().andNot(coreLevelBitKey).equals(levelBitKey.andNot(coreLevelBitKey));
    }

    public RolapStar getStar() {
        return this.star;
    }

    public boolean hasMeasures() {
        return this.getFactTable().hasMeasures();
    }

    public boolean hasLevels() {
        return this.getFactTable().hasLevels();
    }

    public boolean hasForeignKeys() {
        return this.getFactTable().hasChildren();
    }

    public BitKey getBitKey() {
        return this.bitKey;
    }

    public BitKey getLevelBitKey() {
        return this.levelBitKey;
    }

    public BitKey getMeasureBitKey() {
        return this.measureBitKey;
    }

    public BitKey getDistinctMeasureBitKey() {
        return this.distinctMeasureBitKey;
    }

    private SqlQuery getSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public FactTable.Measure lookupMeasure(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof FactTable.Measure ? (FactTable.Measure)column : null;
    }

    public Table.Level lookupLevel(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof Table.Level ? (Table.Level)column : null;
    }

    public Table.Column lookupColumn(int bitPos) {
        return this.columns[bitPos];
    }

    private void addColumn(Table.Column column) {
        this.columns[column.getBitPosition()] = column;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("AggStar:");
        String subprefix = prefix + "  ";
        pw.print(subprefix);
        pw.print(" bk=");
        pw.println(this.bitKey);
        pw.print(subprefix);
        pw.print("fbk=");
        pw.println(this.levelBitKey);
        pw.print(subprefix);
        pw.print("mbk=");
        pw.println(this.measureBitKey);
        pw.print(subprefix);
        pw.print("has foreign key=");
        pw.println(this.aggTable.hasChildren());
        this.aggTable.print(pw, subprefix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DimTable
    extends Table {
        private final Table parent;
        private final Table.JoinCondition joinCondition;

        DimTable(Table parent, String name, MondrianDef.Relation relation, Table.JoinCondition joinCondition) {
            super(name, relation);
            this.parent = parent;
            this.joinCondition = joinCondition;
        }

        @Override
        public Table getParent() {
            return this.parent;
        }

        @Override
        public boolean hasParent() {
            return true;
        }

        @Override
        public boolean hasJoinCondition() {
            return true;
        }

        @Override
        public Table.JoinCondition getJoinCondition() {
            return this.joinCondition;
        }

        public void addColumnsToList(List<Table.Column> list) {
            list.addAll(this.levels);
            for (DimTable dimTable : this.getChildTables()) {
                dimTable.addColumnsToList(list);
            }
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.println("Levels:");
            for (Table.Level level : this.getLevels()) {
                level.print(pw, subsubprefix);
                pw.println();
            }
            this.joinCondition.print(pw, subprefix);
            for (DimTable child : this.getChildTables()) {
                child.print(pw, subprefix);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FactTable
    extends Table {
        private Table.Column factCountColumn;
        private final List<Measure> measures;
        private final int totalColumnSize;
        private int numberOfRows;

        FactTable(JdbcSchema.Table aggTable) {
            this(aggTable.getName(), aggTable.table, aggTable.getTotalColumnSize(), aggTable.getNumberOfRows());
        }

        FactTable(String name, MondrianDef.Relation relation, int totalColumnSize, int numberOfRows) {
            super(name, relation);
            this.totalColumnSize = totalColumnSize;
            this.measures = new ArrayList<Measure>();
            this.numberOfRows = numberOfRows;
        }

        @Override
        public Table getParent() {
            return null;
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        public boolean hasJoinCondition() {
            return false;
        }

        @Override
        public Table.JoinCondition getJoinCondition() {
            return null;
        }

        public int getVolume() {
            return this.getTotalColumnSize() * this.getNumberOfRows();
        }

        public int getTotalColumnSize() {
            return this.totalColumnSize;
        }

        public int getNumberOfRows() {
            if (this.numberOfRows == -1) {
                this.makeNumberOfRows();
            }
            return this.numberOfRows;
        }

        void setNumberOfRows(int numberOfRows) {
            this.numberOfRows = numberOfRows;
        }

        public List<Measure> getMeasures() {
            return this.measures;
        }

        public boolean hasMeasures() {
            return !this.measures.isEmpty();
        }

        public List<Table.Column> getColumns() {
            ArrayList<Table.Column> list = new ArrayList<Table.Column>();
            list.addAll(this.measures);
            list.addAll(this.levels);
            for (DimTable dimTable : this.getChildTables()) {
                dimTable.addColumnsToList(list);
            }
            return list;
        }

        private void loadForeignKey(JdbcSchema.Table.Column.Usage usage) {
            if (usage.rTable != null) {
                DimTable child = this.convertTable(usage.rTable, usage.rightJoinConditionColumnName);
                this.addTable(child);
            } else {
                JdbcSchema.Table.Column column = usage.getColumn();
                String name = column.getName();
                String symbolicName = usage.getSymbolicName();
                if (symbolicName == null) {
                    symbolicName = name;
                }
                MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
                Dialect.Datatype datatype = column.getDatatype();
                RolapStar.Column rColumn = usage.rColumn;
                if (rColumn == null) {
                    AggStar.getLogger().warn((Object)("loadForeignKey: for column " + name + ", rColumn == null"));
                } else {
                    int bitPosition = rColumn.getBitPosition();
                    Table.ForeignKey c = new Table.ForeignKey(symbolicName, expression, datatype, bitPosition);
                    this.getAggStar().setForeignKey(c.getBitPosition());
                }
            }
        }

        private void loadMeasure(JdbcSchema.Table.Column.Usage usage) {
            JdbcSchema.Table.Column column = usage.getColumn();
            String name = column.getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            Dialect.Datatype datatype = column.getDatatype();
            RolapAggregator aggregator = usage.getAggregator();
            MondrianDef.Expression expression = column.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY) && !aggregator.isDistinct() ? this.factCountColumn.getExpression() : new MondrianDef.Column(this.getName(), name);
            MondrianDef.Expression argument = aggregator.isDistinct() ? usage.rMeasure.getExpression() : null;
            int bitPosition = usage.rMeasure.getBitPosition();
            Measure aggMeasure = new Measure(symbolicName, expression, datatype, bitPosition, aggregator, argument);
            this.measures.add(aggMeasure);
            if (aggMeasure.aggregator.isDistinct()) {
                AggStar.this.distinctMeasureBitKey.set(bitPosition);
            }
        }

        private void loadFactCount(JdbcSchema.Table.Column.Usage usage) {
            Table.Column aggColumn;
            String name = usage.getColumn().getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
            Dialect.Datatype datatype = usage.getColumn().getDatatype();
            int bitPosition = -1;
            this.factCountColumn = aggColumn = new Table.Column(symbolicName, expression, datatype, bitPosition);
        }

        private void loadLevel(JdbcSchema.Table.Column.Usage usage) {
            String name = usage.getSymbolicName();
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), usage.levelColumnName);
            int bitPosition = usage.rColumn.getBitPosition();
            Table.Level level = new Table.Level(name, expression, bitPosition, usage.rColumn);
            this.addLevel(level);
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.print("numberofrows=");
            pw.println(this.getNumberOfRows());
            pw.print(subprefix);
            pw.println("FactCount:");
            this.factCountColumn.print(pw, subsubprefix);
            pw.println();
            pw.print(subprefix);
            pw.println("Measures:");
            for (Measure column : this.getMeasures()) {
                column.print(pw, subsubprefix);
                pw.println();
            }
            pw.print(subprefix);
            pw.println("Levels:");
            for (Table.Level level : this.getLevels()) {
                level.print(pw, subsubprefix);
                pw.println();
            }
            for (DimTable child : this.getChildTables()) {
                child.print(pw, subprefix);
            }
        }

        private void makeNumberOfRows() {
            SqlQuery query = this.getSqlQuery();
            query.addSelect("count(*)");
            query.addFrom(this.getRelation(), this.getName(), false);
            DataSource dataSource = this.getAggStar().getStar().getDataSource();
            SqlStatement stmt = RolapUtil.executeQuery(dataSource, query.toString(), "AggStar.FactTable.makeNumberOfRows", "Counting rows in aggregate table");
            try {
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    ++stmt.rowCount;
                    this.numberOfRows = resultSet.getInt(1);
                } else {
                    AggStar.getLogger().warn((Object)mres.SqlQueryFailed.str("AggStar.FactTable.makeNumberOfRows", query.toString()));
                    this.numberOfRows = Integer.MAX_VALUE / this.getTotalColumnSize();
                }
            }
            catch (SQLException e) {
                throw stmt.handle(e);
            }
            finally {
                stmt.close();
            }
        }

        public class Measure
        extends Table.Column {
            private final RolapAggregator aggregator;
            private final MondrianDef.Expression argument;
            private final BitKey rollableLevelBitKey;

            private Measure(String name, MondrianDef.Expression expression, Dialect.Datatype datatype, int bitPosition, RolapAggregator aggregator, MondrianDef.Expression argument) {
                super(name, expression, datatype, bitPosition);
                this.aggregator = aggregator;
                this.argument = argument;
                assert (argument != null == aggregator.isDistinct());
                this.rollableLevelBitKey = BitKey.Factory.makeBitKey(AggStar.this.star.getColumnCount());
                AggStar.this.measureBitKey.set(bitPosition);
            }

            public boolean isDistinct() {
                return this.aggregator.isDistinct();
            }

            public RolapAggregator getAggregator() {
                return this.aggregator;
            }

            public BitKey getRollableLevelBitKey() {
                return this.rollableLevelBitKey;
            }

            public String generateRollupString(SqlQuery query) {
                String expr = this.generateExprString(query);
                Aggregator rollup = null;
                BitKey fkbk = AggStar.this.getForeignKeyBitKey();
                rollup = fkbk.get(this.getBitPosition()) ? (this.getAggregator().isDistinct() ? this.getAggregator().getNonDistinctAggregator() : this.getAggregator().getRollup()) : this.getAggregator().getRollup();
                String s = ((RolapAggregator)rollup).getExpression(expr);
                return s;
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQuery = this.getSqlQuery();
                pw.print(prefix);
                pw.print(this.getName());
                pw.print(" (");
                pw.print(this.getBitPosition());
                pw.print("): ");
                pw.print(this.generateRollupString(sqlQuery));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Table {
        private final String name;
        private final MondrianDef.Relation relation;
        protected final List<Level> levels = new ArrayList<Level>();
        protected List<DimTable> children;

        Table(String name, MondrianDef.Relation relation) {
            this.name = name;
            this.relation = relation;
            this.children = Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean hasParent();

        public abstract Table getParent();

        public abstract boolean hasJoinCondition();

        public abstract JoinCondition getJoinCondition();

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        protected AggStar getAggStar() {
            return AggStar.this;
        }

        protected SqlQuery getSqlQuery() {
            return this.getAggStar().getSqlQuery();
        }

        protected void addLevel(Level level) {
            this.levels.add(level);
        }

        public List<Level> getLevels() {
            return this.levels;
        }

        public boolean hasLevels() {
            return !this.levels.isEmpty();
        }

        protected void addTable(DimTable child) {
            if (this.children == Collections.EMPTY_LIST) {
                this.children = new ArrayList<DimTable>();
            }
            this.children.add(child);
        }

        public List<DimTable> getChildTables() {
            return this.children;
        }

        public Table findDescendant(String name) {
            if (this.getName().equals(name)) {
                return this;
            }
            for (DimTable child : this.getChildTables()) {
                Table found = child.findDescendant(name);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        protected DimTable convertTable(RolapStar.Table rTable, String rightJoinConditionColumnName) {
            String tableName = rTable.getAlias();
            MondrianDef.Relation relation = rTable.getRelation();
            RolapStar.Condition rjoinCondition = rTable.getJoinCondition();
            MondrianDef.Expression rleft = rjoinCondition.getLeft();
            MondrianDef.Expression rright = rjoinCondition.getRight();
            MondrianDef.Column left = null;
            if (rightJoinConditionColumnName != null) {
                left = new MondrianDef.Column(this.getName(), rightJoinConditionColumnName);
            } else if (rleft instanceof MondrianDef.Column) {
                MondrianDef.Column lcolumn = (MondrianDef.Column)rleft;
                left = new MondrianDef.Column(this.getName(), lcolumn.name);
            } else {
                throw Util.newInternal("not implemented: rleft=" + rleft);
            }
            RolapStar.Column col = this.getAggStar().getStar().getFactTable().lookupColumn(left.name);
            if (col != null) {
                this.getAggStar().setForeignKey(col.getBitPosition());
            }
            JoinCondition joinCondition = new JoinCondition(left, rright);
            DimTable dimTable = new DimTable(this, tableName, relation, joinCondition);
            dimTable.convertColumns(rTable);
            dimTable.convertChildren(rTable);
            return dimTable;
        }

        protected void convertColumns(RolapStar.Table rTable) {
            for (RolapStar.Column column : rTable.getColumns()) {
                String name = column.getName();
                MondrianDef.Expression expression = column.getExpression();
                int bitPosition = column.getBitPosition();
                Level level = new Level(name, expression, bitPosition, column);
                this.addLevel(level);
            }
        }

        protected void convertChildren(RolapStar.Table rTable) {
            for (RolapStar.Table rTableChild : rTable.getChildren()) {
                DimTable dimChild = this.convertTable(rTableChild, null);
                this.addTable(dimChild);
            }
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.name, failIfExists);
            if (joinToParent) {
                if (this.hasParent()) {
                    this.getParent().addToFrom(query, failIfExists, joinToParent);
                }
                if (this.hasJoinCondition()) {
                    query.addWhere(this.getJoinCondition().toString(query));
                }
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public abstract void print(PrintWriter var1, String var2);

        final class Level
        extends Column {
            private final RolapStar.Column starColumn;

            private Level(String name, MondrianDef.Expression expression, int bitPosition, RolapStar.Column starColumn) {
                super(name, expression, starColumn.getDatatype(), bitPosition);
                this.starColumn = starColumn;
                AggStar.this.levelBitKey.set(bitPosition);
            }
        }

        final class ForeignKey
        extends Column {
            private ForeignKey(String name, MondrianDef.Expression expression, Dialect.Datatype datatype, int bitPosition) {
                super(name, expression, datatype, bitPosition);
                AggStar.this.levelBitKey.set(bitPosition);
            }
        }

        public class Column {
            private final String name;
            private final MondrianDef.Expression expression;
            private final Dialect.Datatype datatype;
            private final Column nameColumn;
            private final int bitPosition;

            protected Column(String name, MondrianDef.Expression expression, Dialect.Datatype datatype, int bitPosition) {
                this.name = name;
                this.expression = expression;
                this.datatype = datatype;
                this.bitPosition = bitPosition;
                this.nameColumn = null;
                if (bitPosition >= 0) {
                    AggStar.this.bitKey.set(bitPosition);
                    AggStar.this.addColumn(this);
                }
            }

            public String getName() {
                return this.name;
            }

            public Table getTable() {
                return Table.this;
            }

            public int getBitPosition() {
                return this.bitPosition;
            }

            public Dialect.Datatype getDatatype() {
                return this.datatype;
            }

            public SqlQuery getSqlQuery() {
                return this.getTable().getAggStar().getSqlQuery();
            }

            public MondrianDef.Expression getExpression() {
                return this.expression;
            }

            public String generateExprString(SqlQuery query) {
                return this.getExpression().getExpression(query);
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQuery = this.getSqlQuery();
                pw.print(prefix);
                pw.print(this.getName());
                pw.print(" (");
                pw.print(this.getBitPosition());
                pw.print("): ");
                pw.print(this.generateExprString(sqlQuery));
            }
        }

        public class JoinCondition {
            private final MondrianDef.Expression left;
            private final MondrianDef.Expression right;

            private JoinCondition(MondrianDef.Expression left, MondrianDef.Expression right) {
                if (!(left instanceof MondrianDef.Column)) {
                    JOIN_CONDITION_LOGGER.debug((Object)("JoinCondition.left NOT Column: " + left.getClass().getName()));
                }
                this.left = left;
                this.right = right;
            }

            public Table getTable() {
                return Table.this;
            }

            public MondrianDef.Expression getLeft() {
                return this.left;
            }

            public String getLeft(SqlQuery query) {
                return this.left.getExpression(query);
            }

            public MondrianDef.Expression getRight() {
                return this.right;
            }

            String toString(SqlQuery query) {
                StringBuilder buf = new StringBuilder(64);
                buf.append(this.left.getExpression(query));
                buf.append(" = ");
                buf.append(this.right.getExpression(query));
                return buf.toString();
            }

            public String toString() {
                StringWriter sw = new StringWriter(128);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQueuy = this.getTable().getSqlQuery();
                pw.print(prefix);
                pw.println("JoinCondition:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("left=");
                if (this.left instanceof MondrianDef.Column) {
                    MondrianDef.Column c = (MondrianDef.Column)this.left;
                    RolapStar.Column col = this.getTable().getAggStar().getStar().getFactTable().lookupColumn(c.name);
                    if (col != null) {
                        pw.print(" (");
                        pw.print(col.getBitPosition());
                        pw.print(") ");
                    }
                }
                pw.println(this.left.getExpression(sqlQueuy));
                pw.print(subprefix);
                pw.print("right=");
                pw.println(this.right.getExpression(sqlQueuy));
            }
        }
    }
}

