/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.DecoratedTreeModel;
import com.tonbeller.wcf.tree.NodeFilter;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import java.util.ArrayList;

public class FilteringTreeModelDecorator
implements TreeModel,
DecoratedTreeModel {
    TreeModel decoree;
    NodeFilter filter;
    NodeFilter hasAlwaysChildren = NodeFilter.TRUE_FILTER;

    public FilteringTreeModelDecorator(TreeModel decoree, NodeFilter filter) {
        this.decoree = decoree;
        this.filter = filter;
    }

    public FilteringTreeModelDecorator(TreeModel decoree, NodeFilter filter, NodeFilter hasAlwaysChildren) {
        this.decoree = decoree;
        this.filter = filter;
        this.hasAlwaysChildren = hasAlwaysChildren;
    }

    public Object[] getRoots() {
        return this.acceptableMembers(this.decoree.getRoots());
    }

    public boolean hasChildren(Object node) {
        if (!this.decoree.hasChildren(node)) {
            return false;
        }
        if (this.hasAlwaysChildren.accept(node)) {
            return true;
        }
        return this.hasAcceptableMember(this.decoree.getChildren(node));
    }

    public Object[] getChildren(Object node) {
        return this.acceptableMembers(this.decoree.getChildren(node));
    }

    public Object getParent(Object node) {
        return this.decoree.getParent(node);
    }

    boolean hasAcceptableMember(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!this.filter.accept(array[i])) continue;
            return true;
        }
        return false;
    }

    Object[] acceptableMembers(Object[] array) {
        ArrayList<Object> accepted = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            if (!this.filter.accept(array[i])) continue;
            accepted.add(array[i]);
        }
        return accepted.toArray();
    }

    public TreeModel getDecoree() {
        return this.decoree;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public void setDecoree(TreeModel model) {
        this.decoree = model;
    }

    public void setFilter(NodeFilter filter) {
        this.filter = filter;
    }

    public void addTreeModelChangeListener(TreeModelChangeListener l) {
        this.decoree.addTreeModelChangeListener(l);
    }

    public void removeTreeModelChangeListener(TreeModelChangeListener l) {
        this.decoree.removeTreeModelChangeListener(l);
    }

    public void fireModelChanged(boolean identityChanged) {
        this.decoree.fireModelChanged(identityChanged);
    }

    public NodeFilter getHasAlwaysChildren() {
        return this.hasAlwaysChildren;
    }

    public void setHasAlwaysChildren(NodeFilter hasAlwaysChildren) {
        this.hasAlwaysChildren = hasAlwaysChildren;
    }
}

