/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.NodeFilter;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelDecorator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class OptimizingTreeModelDecorator
extends TreeModelDecorator {
    NodeFilter filter;
    Object[] roots;
    Set significant;
    boolean dirty = true;
    boolean optimizeRoot = true;
    boolean optimizeLeafs = false;

    public OptimizingTreeModelDecorator(NodeFilter filter, TreeModel decoree) {
        super(decoree);
        this.filter = filter;
        this.significant = new HashSet();
        this.installChangeListener(decoree);
    }

    public OptimizingTreeModelDecorator(NodeFilter filter, TreeModel decoree, Comparator nodeComparator) {
        super(decoree);
        this.filter = filter;
        this.significant = new TreeSet(nodeComparator);
        this.installChangeListener(decoree);
    }

    private void installChangeListener(TreeModel decoree) {
        decoree.addTreeModelChangeListener(new TreeModelChangeListener(){

            public void treeModelChanged(TreeModelChangeEvent event) {
                OptimizingTreeModelDecorator.this.dirty = true;
            }
        });
    }

    public Object[] getRoots() {
        if (this.dirty) {
            this.initialize();
        }
        return this.roots;
    }

    void initialize() {
        this.dirty = false;
        this.significant.clear();
        this.recurseFindSignificant(super.getRoots());
        this.roots = this.optimize(super.getRoots());
        if (this.optimizeRoot) {
            while (this.roots.length == 1 && !this.filter.accept(this.roots[0])) {
                this.roots = this.optimize(this.getChildren(this.roots[0]));
            }
        }
    }

    boolean isSignificant(Object node) {
        return this.significant.contains(node);
    }

    void recurseFindSignificant(Object[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (super.hasChildren(node)) {
                if (this.filter.accept(node)) {
                    this.addSignificant(node);
                }
                this.recurseFindSignificant(super.getChildren(node));
                continue;
            }
            if (this.filter.accept(node)) {
                this.addSignificant(node);
                continue;
            }
            if (this.optimizeLeafs) continue;
            this.significant.add(node);
        }
    }

    private void addSignificant(Object node) {
        Object n = node;
        while (n != null) {
            this.significant.add(n);
            n = super.getParent(n);
        }
    }

    private Object[] optimize(Object[] nodes) {
        ArrayList<Object> optimized = new ArrayList<Object>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!this.significant.contains(nodes[i])) continue;
            optimized.add(nodes[i]);
        }
        return optimized.toArray();
    }

    public boolean hasChildren(Object node) {
        if (super.hasChildren(node)) {
            return this.getChildren(node).length > 0;
        }
        return false;
    }

    public Object[] getChildren(Object node) {
        if (this.dirty) {
            this.initialize();
        }
        return this.optimize(super.getChildren(node));
    }

    public Object getParent(Object node) {
        return super.getParent(node);
    }

    public void setOptimizeLeafs(boolean b) {
        this.optimizeLeafs = b;
        this.dirty = true;
        this.fireModelChanged(false);
    }

    public boolean isOptimizeLeafs() {
        return this.optimizeLeafs;
    }

    public void setOptimizeRoot(boolean b) {
        this.optimizeRoot = b;
        this.dirty = true;
        this.fireModelChanged(false);
    }

    public boolean isOptimizeRoot() {
        return this.optimizeRoot;
    }
}

