/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.wizard;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.wizard.PageListener;
import com.tonbeller.wcf.wizard.WizardPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class WizardPageSupport {
    WizardPage source;
    ArrayList listeners = new ArrayList();

    public WizardPageSupport(WizardPage source) {
        this.source = source;
    }

    public void fireNext(RequestContext context) throws Exception {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((PageListener)it.next()).onNext(context);
        }
    }

    public void fireBack(RequestContext context) throws Exception {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((PageListener)it.next()).onBack(context);
        }
    }

    public void fireFinish(RequestContext context) throws Exception {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((PageListener)it.next()).onFinish(context);
        }
    }

    public void fireCancel(RequestContext context) throws Exception {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((PageListener)it.next()).onCancel(context);
        }
    }

    private Iterator iterator() {
        if (this.listeners.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        List copy = (List)this.listeners.clone();
        return copy.iterator();
    }

    public void addPageListener(PageListener l) {
        this.listeners.add(l);
    }

    public void removePageListener(PageListener l) {
        this.listeners.remove(l);
    }

    public void fireWizardButton(RequestContext context, String methodName) throws Exception {
        if ("onNext".equals(methodName)) {
            this.fireNext(context);
        } else if ("onBack".equals(methodName)) {
            this.fireBack(context);
        } else if ("onCancel".equals(methodName)) {
            this.fireCancel(context);
        } else if ("onFinish".equals(methodName)) {
            this.fireFinish(context);
        }
    }
}

