/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapExceptionHelper;
import org.olap4j.driver.xmla.DeferredNamedListImpl;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jUtil;
import org.olap4j.impl.ArrayMap;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jDatabaseMetaData
implements OlapDatabaseMetaData {
    final XmlaOlap4jConnection olap4jConnection;
    private final NamedList<XmlaOlap4jCatalog> catalogs;

    XmlaOlap4jDatabaseMetaData(XmlaOlap4jConnection olap4jConnection) {
        this.olap4jConnection = olap4jConnection;
        this.catalogs = new DeferredNamedListImpl<XmlaOlap4jCatalog>(XmlaOlap4jConnection.MetadataRequest.DBSCHEMA_CATALOGS, new XmlaOlap4jConnection.Context(olap4jConnection, this, null, null, null, null, null, null), new XmlaOlap4jConnection.CatalogHandler());
    }

    NamedList<Catalog> getCatalogObjects() {
        return Olap4jUtil.cast(this.catalogs);
    }

    private ResultSet getMetadata(XmlaOlap4jConnection.MetadataRequest metadataRequest, Object ... patternValues) throws OlapException {
        assert (patternValues.length % 2 == 0);
        XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(this.olap4jConnection, null, null, null, null, null, null, null);
        ArrayList<String> patternValueList = new ArrayList<String>();
        ArrayMap<String, Matcher> predicateList = new ArrayMap<String, Matcher>();
        for (int i = 0; i < patternValues.length; i += 2) {
            String name = (String)patternValues[i];
            Object value = patternValues[i + 1];
            if (value == null) continue;
            if (value instanceof Wildcard) {
                Wildcard wildcard = (Wildcard)value;
                if (wildcard.pattern.indexOf(37) < 0 && wildcard.pattern.indexOf(95) < 0) {
                    patternValueList.add(name);
                    patternValueList.add(wildcard.pattern);
                    continue;
                }
                String regexp = Olap4jUtil.wildcardToRegexp(Collections.singletonList(wildcard.pattern));
                Matcher matcher = Pattern.compile(regexp).matcher("");
                predicateList.put(name, matcher);
                continue;
            }
            patternValueList.add(name);
            patternValueList.add((String)value);
        }
        String request = this.olap4jConnection.generateRequest(context, metadataRequest, patternValueList.toArray(new String[patternValueList.size()]));
        Element root = this.olap4jConnection.xxx(request);
        ArrayList<List<Object>> rowList = new ArrayList<List<Object>>();
        block1: for (Element row : XmlaOlap4jUtil.childElements(root)) {
            ArrayList<String> valueList = new ArrayList<String>();
            for (Map.Entry entry : predicateList.entrySet()) {
                String column = (String)entry.getKey();
                String value = XmlaOlap4jUtil.stringElement(row, column);
                Matcher matcher = (Matcher)entry.getValue();
                if (matcher.reset(value).matches()) continue;
                continue block1;
            }
            for (XmlaOlap4jConnection.MetadataColumn column : metadataRequest.columns) {
                String value = XmlaOlap4jUtil.stringElement(row, column.xmlaName);
                valueList.add(value);
            }
            rowList.add(valueList);
        }
        ArrayList<String> headerList = new ArrayList<String>();
        for (XmlaOlap4jConnection.MetadataColumn column : metadataRequest.columns) {
            headerList.add(column.name);
        }
        return this.olap4jConnection.factory.newFixedResultSet(this.olap4jConnection, headerList, rowList);
    }

    private Wildcard wildcard(String pattern) {
        return pattern == null ? null : new Wildcard(pattern);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getURL() throws SQLException {
        return this.olap4jConnection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public String getDriverName() throws SQLException {
        return "olap4j driver for XML/A";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "0.9.5";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 905;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.DBSCHEMA_SCHEMATA, new Object[0]);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.DBSCHEMA_CATALOGS, new Object[0]);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OlapConnection getConnection() {
        return this.olap4jConnection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw OlapExceptionHelper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public ResultSet getActions(String catalog, String schemaPattern, String cubeNamePattern, String actionNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_ACTIONS, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "ACTION_NAME", this.wildcard(actionNamePattern));
    }

    @Override
    public ResultSet getDatasources() throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.DISCOVER_DATASOURCES, new Object[0]);
    }

    @Override
    public ResultSet getLiterals() throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.DISCOVER_LITERALS, new Object[0]);
    }

    @Override
    public ResultSet getDatabaseProperties(String dataSourceName, String propertyNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.DISCOVER_PROPERTIES, new Object[0]);
    }

    @Override
    public ResultSet getProperties(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String memberUniqueName, String propertyNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_PROPERTIES, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_UNIQUE_NAME", levelUniqueName, "MEMBER_UNIQUE_NAME", memberUniqueName, "PROPERTY_NAME", this.wildcard(propertyNamePattern));
    }

    @Override
    public String getMdxKeywords() throws OlapException {
        XmlaOlap4jConnection.MetadataRequest metadataRequest = XmlaOlap4jConnection.MetadataRequest.DISCOVER_KEYWORDS;
        XmlaOlap4jConnection.Context context = new XmlaOlap4jConnection.Context(this.olap4jConnection, null, null, null, null, null, null, null);
        String request = this.olap4jConnection.generateRequest(context, metadataRequest, new Object[0]);
        Element root = this.olap4jConnection.xxx(request);
        StringBuilder buf = new StringBuilder();
        for (Element row : XmlaOlap4jUtil.childElements(root)) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            String keyword = XmlaOlap4jUtil.stringElement(row, "Keyword");
            buf.append(keyword);
        }
        return buf.toString();
    }

    @Override
    public ResultSet getCubes(String catalog, String schemaPattern, String cubeNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_CUBES, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern));
    }

    @Override
    public ResultSet getDimensions(String catalog, String schemaPattern, String cubeNamePattern, String dimensionNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_DIMENSIONS, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMSENSION_NAME", this.wildcard(dimensionNamePattern));
    }

    @Override
    public ResultSet getOlapFunctions(String functionNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_FUNCTIONS, "FUNCTION_NAME", this.wildcard(functionNamePattern));
    }

    @Override
    public ResultSet getHierarchies(String catalog, String schemaPattern, String cubeNamePattern, String dimensionNamePattern, String hierarchyNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_HIERARCHIES, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_NAME", this.wildcard(dimensionNamePattern), "HIERARCHY_NAME", this.wildcard(hierarchyNamePattern));
    }

    @Override
    public ResultSet getMeasures(String catalog, String schemaPattern, String cubeNamePattern, String measureNamePattern, String measureUniqueName) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEASURES, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "MEASURE_NAME", this.wildcard(measureNamePattern), "MEASURE_UNIQUE_NAME", measureUniqueName);
    }

    @Override
    public ResultSet getMembers(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String memberUniqueName, Set<Member.TreeOp> treeOps) throws OlapException {
        String treeOpString;
        if (treeOps != null) {
            int op = 0;
            for (Member.TreeOp treeOp : treeOps) {
                op |= treeOp.xmlaOrdinal();
            }
            treeOpString = String.valueOf(op);
        } else {
            treeOpString = null;
        }
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_MEMBERS, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_UNIQUE_NAME", levelUniqueName, "MEMBER_UNIQUE_NAME", memberUniqueName, "TREE_OP", treeOpString);
    }

    @Override
    public ResultSet getLevels(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_LEVELS, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_NAME", this.wildcard(levelNamePattern));
    }

    @Override
    public ResultSet getSets(String catalog, String schemaPattern, String cubeNamePattern, String setNamePattern) throws OlapException {
        return this.getMetadata(XmlaOlap4jConnection.MetadataRequest.MDSCHEMA_SETS, "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "SET_NAME", this.wildcard(setNamePattern));
    }

    static class Wildcard {
        final String pattern;

        Wildcard(String pattern) {
            assert (pattern != null);
            this.pattern = pattern;
        }
    }
}

