/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.RsltData;
import com.ingres.gcf.jdbc.RsltXlat;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlString;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;

public class JdbcDBMD
implements DatabaseMetaData,
DrvConst,
DbmsConst,
GcfErr {
    private static final String empty = new String("");
    private static final String space = new String(" ");
    private static final String NO = new String("NO");
    private static final String YES = new String("YES");
    private static final short VARCHAR = 21;
    private static final short INTEGER = 30;
    private DrvConn conn = null;
    private DrvTrace trace = null;
    private String title = "DatabaseMetaData";
    private boolean upper = false;
    private int std_catl_lvl = 0;
    private int param_type = 12;
    private static MDdesc[] cat_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat")};
    private static MDdesc[] schema_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_catalog")};
    private static MDdesc[] proc_desc = new MDdesc[]{new MDdesc(12, 21, 32, "procedure_cat"), new MDdesc(12, 21, 32, "procedure_schem"), new MDdesc(12, 21, 32, "procedure_name"), new MDdesc(12, 21, 32, "future_col1"), new MDdesc(12, 21, 32, "future_col2"), new MDdesc(12, 21, 32, "future_col3"), new MDdesc(12, 21, 128, "remarks"), new MDdesc(5, 30, 2, "procedure_type")};
    private static MDdesc[] procCol_desc = new MDdesc[]{new MDdesc(12, 21, 32, "procedure_cat"), new MDdesc(12, 21, 32, "procedure_schem"), new MDdesc(12, 21, 32, "procedure_name"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(5, 30, 2, "column_type"), new MDdesc(5, 30, 2, "data_type"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(4, 30, 4, "precision"), new MDdesc(4, 30, 4, "length"), new MDdesc(5, 30, 2, "scale"), new MDdesc(5, 30, 2, "radix"), new MDdesc(5, 30, 2, "nullable"), new MDdesc(12, 21, 32, "remarks")};
    private static final MDdesc[] tables_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 16, "table_type"), new MDdesc(12, 21, 256, "remarks"), new MDdesc(12, 21, 32, "type_cat"), new MDdesc(12, 21, 32, "type_schem"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(12, 21, 32, "self_referencing_col_name"), new MDdesc(12, 21, 32, "ref_generation")};
    private static MDdesc tabtyp_desc = new MDdesc(12, 21, 20, "table_type");
    private static final SqlData[][] tableTypeValues = new SqlData[][]{{new SqlString("TABLE")}, {new SqlString("VIEW")}, {new SqlString("SYSTEM TABLE")}};
    private static MDdesc[] tabpriv_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 32, "grantor"), new MDdesc(12, 21, 32, "grantee"), new MDdesc(12, 21, 32, "privilege"), new MDdesc(12, 21, 32, "is_grantable")};
    private static MDdesc[] tabsup_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 32, "supertable_name")};
    private static MDdesc[] getc_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(4, 30, 4, "data_type"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(4, 30, 4, "column_size"), new MDdesc(4, 30, 4, "buffer_length"), new MDdesc(4, 30, 4, "decimal_digits"), new MDdesc(4, 30, 4, "num_prec_radix"), new MDdesc(4, 30, 4, "nullable"), new MDdesc(12, 21, 256, "remarks"), new MDdesc(12, 21, 32, "column_def"), new MDdesc(4, 30, 4, "sql_data_type"), new MDdesc(4, 30, 4, "sql_datetime_sub"), new MDdesc(4, 30, 4, "char_octet_length"), new MDdesc(4, 30, 4, "ordinal_position"), new MDdesc(12, 21, 32, "is_nullable"), new MDdesc(12, 21, 32, "scope_catlog"), new MDdesc(12, 21, 32, "scope_schema"), new MDdesc(12, 21, 32, "scope_table"), new MDdesc(5, 30, 2, "source_data_type")};
    private static MDdesc[] getColPriv_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(12, 21, 32, "grantor"), new MDdesc(12, 21, 32, "grantee"), new MDdesc(12, 21, 32, "privilege"), new MDdesc(12, 21, 32, "is_grantable")};
    private static MDdesc[] bestRow_desc = new MDdesc[]{new MDdesc(5, 30, 2, "scope"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(5, 30, 2, "data_type"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(4, 30, 4, "column_size"), new MDdesc(4, 30, 4, "buffer_length"), new MDdesc(5, 30, 2, "decimal_digits"), new MDdesc(5, 30, 2, "pseudo_column")};
    private static MDdesc[] idx_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(16, 21, 1, "non_unique"), new MDdesc(12, 21, 32, "index_qualifier"), new MDdesc(12, 21, 32, "index_name"), new MDdesc(5, 30, 2, "type"), new MDdesc(5, 30, 2, "ordinal_position"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(12, 21, 32, "asc_or_desc"), new MDdesc(4, 30, 4, "cardinality"), new MDdesc(4, 30, 4, "pages"), new MDdesc(12, 21, 32, "filter_condition")};
    private static MDdesc[] pk_desc = new MDdesc[]{new MDdesc(12, 21, 32, "table_cat"), new MDdesc(12, 21, 32, "table_schem"), new MDdesc(12, 21, 32, "table_name"), new MDdesc(12, 21, 32, "column_name"), new MDdesc(5, 30, 2, "key_seq"), new MDdesc(12, 21, 32, "pk_name")};
    private static MDdesc[] keys_desc = new MDdesc[]{new MDdesc(12, 21, 32, "pktable_cat"), new MDdesc(12, 21, 32, "pktable_schem"), new MDdesc(12, 21, 32, "pktable_name"), new MDdesc(12, 21, 32, "pkcolumn_name"), new MDdesc(12, 21, 32, "fktable_cat"), new MDdesc(12, 21, 32, "fktable_schem"), new MDdesc(12, 21, 32, "fktable_name"), new MDdesc(12, 21, 32, "fkcolumn_name"), new MDdesc(5, 30, 2, "key_seq"), new MDdesc(5, 30, 2, "update_rule"), new MDdesc(5, 30, 2, "delete_rule"), new MDdesc(12, 21, 32, "fk_name"), new MDdesc(12, 21, 32, "pk_name"), new MDdesc(5, 30, 2, "deferrability")};
    private static final SqlNull NULL = new SqlNull();
    private static final SqlSmallInt S0 = new SqlSmallInt(0);
    private static final SqlSmallInt S1 = new SqlSmallInt(1);
    private static final SqlSmallInt S31 = new SqlSmallInt(31);
    private static final SqlInt I0 = new SqlInt(0);
    private static final SqlInt I3 = new SqlInt(3);
    private static final SqlInt I5 = new SqlInt(5);
    private static final SqlInt I7 = new SqlInt(7);
    private static final SqlInt I8 = new SqlInt(8);
    private static final SqlInt I10 = new SqlInt(10);
    private static final SqlInt I15 = new SqlInt(15);
    private static final SqlInt I19 = new SqlInt(19);
    private static final SqlInt I29 = new SqlInt(29);
    private static final SqlInt I31 = new SqlInt(31);
    private static final SqlInt I2000 = new SqlInt(2000);
    private static final SqlString QUOTE = new SqlString("'");
    private static final SqlString S_HEX = new SqlString("X'");
    private static final SqlString S_LEN = new SqlString("length");
    private static final SqlString S_PREC = new SqlString("precision");
    private static final SqlString S_PS = new SqlString("precision,scale");
    private static final SqlSmallInt T_NULL = new SqlSmallInt(1);
    private static final SqlSmallInt T_SRCH = new SqlSmallInt(3);
    private static final SqlSmallInt T_PRDN = new SqlSmallInt(0);
    private static final SqlSmallInt T_PRDB = new SqlSmallInt(2);
    private static final SqlString S_TINT = new SqlString("integer1");
    private static final SqlString S_SINT = new SqlString("smallint");
    private static final SqlString S_INT = new SqlString("integer");
    private static final SqlString S_BINT = new SqlString("bigint");
    private static final SqlString S_FLT = new SqlString("float");
    private static final SqlString S_REAL = new SqlString("real");
    private static final SqlString S_DBL = new SqlString("double precision");
    private static final SqlString S_DEC = new SqlString("decimal");
    private static final SqlString S_CHAR = new SqlString("char");
    private static final SqlString S_VCH = new SqlString("varchar");
    private static final SqlString S_LVCH = new SqlString("long varchar");
    private static final SqlString S_BYTE = new SqlString("byte");
    private static final SqlString S_VBYT = new SqlString("byte varying");
    private static final SqlString S_LBYT = new SqlString("long byte");
    private static final SqlString S_IDAT = new SqlString("ingresdate");
    private static final SqlString S_ADAT = new SqlString("ansidate");
    private static final SqlString S_TIME = new SqlString("time");
    private static final SqlString S_TS = new SqlString("timestamp");
    private static final SqlSmallInt T_TINT = new SqlSmallInt(-6);
    private static final SqlSmallInt T_SINT = new SqlSmallInt(5);
    private static final SqlSmallInt T_INT = new SqlSmallInt(4);
    private static final SqlSmallInt T_BINT = new SqlSmallInt(-5);
    private static final SqlSmallInt T_FLT = new SqlSmallInt(6);
    private static final SqlSmallInt T_REAL = new SqlSmallInt(7);
    private static final SqlSmallInt T_DBL = new SqlSmallInt(8);
    private static final SqlSmallInt T_DEC = new SqlSmallInt(3);
    private static final SqlSmallInt T_CHAR = new SqlSmallInt(1);
    private static final SqlSmallInt T_VCH = new SqlSmallInt(12);
    private static final SqlSmallInt T_LVCH = new SqlSmallInt(-1);
    private static final SqlSmallInt T_BYTE = new SqlSmallInt(-2);
    private static final SqlSmallInt T_VBYT = new SqlSmallInt(-3);
    private static final SqlSmallInt T_LBYT = new SqlSmallInt(-4);
    private static final SqlSmallInt T_DATE = new SqlSmallInt(91);
    private static final SqlSmallInt T_TIME = new SqlSmallInt(92);
    private static final SqlSmallInt T_TS = new SqlSmallInt(93);
    private static final SqlData[][] OpenSqlTypeValues = new SqlData[][]{{S_CHAR, T_CHAR, I2000, QUOTE, QUOTE, S_LEN, T_NULL, S1, T_SRCH, S0, S0, S0, S_CHAR, S0, S0, I0, I0, I10}, {S_INT, T_INT, I10, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_INT, S0, S0, I0, I0, I10}, {S_SINT, T_SINT, I5, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_SINT, S0, S0, I0, I0, I10}, {S_FLT, T_FLT, I7, NULL, NULL, S_PREC, T_NULL, S0, T_PRDB, S1, S0, S0, S_FLT, S0, S0, I0, I0, I10}, {S_REAL, T_REAL, I7, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_REAL, S0, S0, I0, I0, I10}, {S_DBL, T_DBL, I15, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_DBL, S0, S0, I0, I0, I10}, {S_VCH, T_VCH, I2000, QUOTE, QUOTE, S_LEN, T_NULL, S1, T_SRCH, S0, S0, S0, S_VCH, S0, S0, I0, I0, I10}, {S_IDAT, T_TS, I29, QUOTE, QUOTE, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_IDAT, S0, S0, I0, I0, I10}};
    private static final SqlData[][] sqlTypeValues = new SqlData[][]{{S_TINT, T_TINT, I3, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_TINT, S0, S0, I0, I0, I10}, {S_BINT, T_BINT, I19, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_INT, S0, S0, I0, I0, I10}, {S_LBYT, T_LBYT, I0, S_HEX, QUOTE, NULL, T_NULL, S0, T_PRDN, S0, S0, S0, S_LBYT, S0, S0, I0, I0, I10}, {S_VBYT, T_VBYT, I2000, S_HEX, QUOTE, S_LEN, T_NULL, S0, T_PRDB, S1, S0, S0, S_VBYT, S0, S0, I0, I0, I10}, {S_BYTE, T_BYTE, I2000, S_HEX, QUOTE, S_LEN, T_NULL, S0, T_PRDB, S1, S0, S0, S_BYTE, S0, S0, I0, I0, I10}, {S_LVCH, T_LVCH, I0, QUOTE, QUOTE, NULL, T_NULL, S1, T_SRCH, S1, S0, S0, S_LVCH, S0, S0, I0, I0, I10}, {S_CHAR, T_CHAR, I2000, QUOTE, QUOTE, S_LEN, T_NULL, S1, T_SRCH, S1, S0, S0, S_CHAR, S0, S0, I0, I0, I10}, {S_DEC, T_DEC, I31, NULL, NULL, S_PS, T_NULL, S0, T_PRDB, S0, S0, S0, S_DEC, S0, S31, I0, I0, I10}, {S_INT, T_INT, I10, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_INT, S0, S0, I0, I0, I10}, {S_SINT, T_SINT, I5, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_SINT, S0, S0, I0, I0, I10}, {S_FLT, T_FLT, I15, NULL, NULL, S_PREC, T_NULL, S0, T_PRDB, S0, S0, S0, S_FLT, S0, S0, I0, I0, I10}, {S_REAL, T_REAL, I7, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_REAL, S0, S0, I0, I0, I10}, {S_DBL, T_DBL, I15, NULL, NULL, NULL, T_NULL, S0, T_PRDB, S0, S0, S0, S_DBL, S0, S0, I0, I0, I10}, {S_VCH, T_VCH, I2000, QUOTE, QUOTE, S_LEN, T_NULL, S1, T_SRCH, S1, S0, S0, S_VCH, S0, S0, I0, I0, I10}, {S_ADAT, T_DATE, I10, QUOTE, QUOTE, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_ADAT, S0, S0, I0, I0, I10}, {S_TIME, T_TIME, I8, QUOTE, QUOTE, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_TIME, S0, S0, I0, I0, I10}, {S_TS, T_TS, I29, QUOTE, QUOTE, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_TS, S0, S0, I0, I0, I10}, {S_IDAT, T_TS, I29, QUOTE, QUOTE, NULL, T_NULL, S0, T_PRDB, S1, S0, S0, S_IDAT, S0, S0, I0, I0, I10}};
    private static MDdesc[] md_desc = new MDdesc[]{new MDdesc(12, 21, 32, "type_name"), new MDdesc(5, 30, 2, "data_type"), new MDdesc(4, 30, 4, "precision"), new MDdesc(12, 21, 1, "literal_prefix"), new MDdesc(12, 21, 1, "literal_suffix"), new MDdesc(12, 21, 32, "create_params"), new MDdesc(5, 30, 2, "nullable"), new MDdesc(5, 30, 2, "case_sensitive"), new MDdesc(5, 30, 2, "searchable"), new MDdesc(5, 30, 2, "unsigned_attribute"), new MDdesc(5, 30, 2, "fixed_prec_scale"), new MDdesc(5, 30, 2, "auto_increment"), new MDdesc(12, 21, 32, "local_type_name"), new MDdesc(5, 30, 2, "minimum_scale"), new MDdesc(5, 30, 2, "maximum_scale"), new MDdesc(4, 30, 4, "sql_data_type"), new MDdesc(4, 30, 4, "sql_datetime_sub"), new MDdesc(4, 30, 4, "num_prec_radix")};
    private static MDdesc[] super_desc = new MDdesc[]{new MDdesc(12, 21, 32, "type_cat"), new MDdesc(12, 21, 32, "type_schem"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(12, 21, 32, "supertype_cat"), new MDdesc(12, 21, 32, "supertype_schem"), new MDdesc(12, 21, 32, "supertype_name")};
    private static MDdesc[] udt_desc = new MDdesc[]{new MDdesc(12, 21, 32, "type_cat"), new MDdesc(12, 21, 32, "type_schem"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(12, 21, 32, "class_name"), new MDdesc(12, 21, 32, "data_type"), new MDdesc(12, 21, 256, "remarks"), new MDdesc(5, 30, 2, "base_type")};
    private static MDdesc[] att_desc = new MDdesc[]{new MDdesc(12, 21, 32, "type_cat"), new MDdesc(12, 21, 32, "type_schem"), new MDdesc(12, 21, 32, "type_name"), new MDdesc(12, 21, 32, "attr_name"), new MDdesc(4, 30, 4, "data_type"), new MDdesc(12, 21, 32, "attr_type_name"), new MDdesc(4, 30, 4, "attr_size"), new MDdesc(4, 30, 4, "decimal_digits"), new MDdesc(4, 30, 4, "num_prec_radix"), new MDdesc(4, 30, 4, "nullable"), new MDdesc(12, 21, 256, "remarks"), new MDdesc(12, 21, 32, "attr_def"), new MDdesc(4, 30, 4, "sql_data_type"), new MDdesc(4, 30, 4, "sql_datetime_sub"), new MDdesc(4, 30, 4, "char_octet_length"), new MDdesc(4, 30, 4, "ordinal_position"), new MDdesc(12, 21, 32, "is_nullable"), new MDdesc(12, 21, 32, "scope_catalog"), new MDdesc(12, 21, 32, "scope_schema"), new MDdesc(12, 21, 32, "scope_table"), new MDdesc(12, 21, 32, "attr_name"), new MDdesc(5, 30, 2, "source_data_type")};

    JdbcDBMD(DrvConn drvConn) throws SQLException {
        String string;
        this.conn = drvConn;
        this.trace = drvConn.trace;
        this.title = this.trace.getTraceName() + "-DatabaseMetaData";
        String string2 = drvConn.dbCaps.getDbCap("STANDARD_CATALOG_LEVEL");
        if (string2 != null) {
            try {
                this.std_catl_lvl = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = drvConn.dbCaps.getDbCap("DB_NAME_CASE")) != null && string.equals("UPPER")) {
            this.upper = true;
        }
        if (drvConn.ucs2_supported) {
            this.param_type = 1111;
        }
    }

    public String getDriverName() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDriverName(): " + this.conn.driverName);
        }
        return this.conn.driverName;
    }

    public String getDriverVersion() throws SQLException {
        String string = "3.4.3";
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDriverVersion(): " + string);
        }
        return string;
    }

    public int getDriverMajorVersion() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDriverMajorVersion(): " + 3);
        }
        return 3;
    }

    public int getDriverMinorVersion() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDriverMinorVersion(): " + 4);
        }
        return 4;
    }

    public int getJDBCMajorVersion() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getJDBCMajorVersion(): " + 3);
        }
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getJDBCMinorVersion(): " + 0);
        }
        return 0;
    }

    public boolean supportsStatementPooling() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsStatementPooling(): " + false);
        }
        return false;
    }

    public boolean supportsBatchUpdates() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsBatchUpdates(): " + true);
        }
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsGetGeneratedKeys(): " + true);
        }
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMultipleResultSets(): " + false);
        }
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMultipleOpenResults(): " + false);
        }
        return false;
    }

    public boolean supportsResultSetType(int n) {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsResultSetType( " + n + " ): " + bl);
        }
        return bl;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 1003: {
                switch (n2) {
                    case 1007: 
                    case 1008: {
                        bl = true;
                    }
                }
                break;
            }
            case 1005: {
                switch (n2) {
                    case 1008: {
                        bl = true;
                    }
                }
                break;
            }
            case 1004: {
                switch (n2) {
                    case 1007: {
                        bl = true;
                    }
                }
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsResultSetConcurrency( " + n + ", " + n2 + " ): " + bl);
        }
        return bl;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        boolean bl;
        boolean bl2 = bl = n == 2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsResultSetHoldability(" + n + "): " + bl);
        }
        return bl;
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getResultSetHoldability(): " + 2);
        }
        return 2;
    }

    public int getSQLStateType() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLStateType(): " + 2);
        }
        return 2;
    }

    public boolean usesLocalFiles() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".usesLocalFiles(): " + false);
        }
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".usesLocalFilePerTable(): " + false);
        }
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.conn.jdbc;
    }

    public String getURL() throws SQLException {
        String string = "jdbc:" + this.conn.protocol + "://" + this.conn.host + "/" + this.conn.database;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getURL(): " + string);
        }
        return string;
    }

    public String getDatabaseProductName() throws SQLException {
        String string = this.conn.dbCaps.getDbCap("DBMS_TYPE");
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDatabaseProductName(): " + string);
        }
        return string;
    }

    public String getDatabaseProductVersion() throws SQLException {
        String string = this.conn.dbInfo.getDbmsInfo("_version");
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDatabaseProductVersion(): " + string);
        }
        return string;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        int n;
        int n2;
        String string;
        block9: {
            string = this.conn.dbInfo.getDbmsInfo("_version");
            n2 = 0;
            n = 0;
            try {
                block2: for (int i = 0; i < string.length(); ++i) {
                    if (!Character.isDigit(string.charAt(i))) continue;
                    for (int j = i + 1; j < string.length(); ++j) {
                        if (Character.isDigit(string.charAt(j))) continue;
                        if (string.charAt(j) != '.') {
                            i = j;
                            continue block2;
                        }
                        int n3 = j;
                        while (++n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                        }
                        if (n3 - j - 1 <= 0) {
                            i = n3;
                            continue block2;
                        }
                        n2 = Integer.parseInt(string.substring(i, j));
                        n = Integer.parseInt(string.substring(j + 1, n3));
                        break block9;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDatabaseMajorVersion(): " + n2);
        }
        if (this.trace.enabled(5)) {
            this.trace.write("\t: '" + string + "' => " + n2 + "." + n);
        }
        return n2;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int n;
        int n2;
        String string;
        block9: {
            string = this.conn.dbInfo.getDbmsInfo("_version");
            n2 = 0;
            n = 0;
            try {
                block2: for (int i = 0; i < string.length(); ++i) {
                    if (!Character.isDigit(string.charAt(i))) continue;
                    for (int j = i + 1; j < string.length(); ++j) {
                        if (Character.isDigit(string.charAt(j))) continue;
                        if (string.charAt(j) != '.') {
                            i = j;
                            continue block2;
                        }
                        int n3 = j;
                        while (++n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                        }
                        if (n3 - j - 1 <= 0) {
                            i = n3;
                            continue block2;
                        }
                        n2 = Integer.parseInt(string.substring(i, j));
                        n = Integer.parseInt(string.substring(j + 1, n3));
                        break block9;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDatabaseMinorVersion(): " + n);
        }
        if (this.trace.enabled(5)) {
            this.trace.write("\t: '" + string + "' => " + n2 + "." + n);
        }
        return n;
    }

    public String getUserName() throws SQLException {
        ResultSet resultSet = null;
        String string = null;
        String string2 = "select user_name from iidbconstants for readonly";
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUserName()");
        }
        try {
            Statement statement = this.conn.jdbc.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getUsername(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUserName(): " + string);
        }
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl = this.conn.readOnly;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly(): " + bl);
        }
        return bl;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("SQL92_LEVEL");
        if (string != null && string.equals("NONE")) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsANSI92EntryLevelSQL(): " + bl);
        }
        return bl;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("SQL92_LEVEL");
        if (string != null && (string.equals("INTERMEDIATE") || string.equals("FULL"))) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsANSI92IntermediateSQL(): " + bl);
        }
        return bl;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("SQL92_LEVEL");
        if (string != null && string.equals("FULL")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsANSI92FullSQL(): " + bl);
        }
        return bl;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("SQL92_LEVEL");
        if (!(string == null || string.equals("FIPS-IEF") || string.equals("INTERMEDIATE") || string.equals("FULL"))) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsIntegrityEnhancementFacility(): " + bl);
        }
        return bl;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMinimumSQLGrammar(): " + true);
        }
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCoreSQLGrammar(): " + true);
        }
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsExtendedSQLGrammar(): " + false);
        }
        return false;
    }

    public String getCatalogTerm() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogTerm(): '" + empty + "'");
        }
        return empty;
    }

    public String getCatalogSeparator() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogSeparator(): '" + empty + "'");
        }
        return empty;
    }

    public boolean isCatalogAtStart() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCatalogAtStart(): " + false);
        }
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchemaTerm(): " + "schema");
        }
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getProcedureTerm(): " + "procedure");
        }
        return "procedure";
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsStoredProcedures(): " + true);
        }
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsNamedParameters(): " + true);
        }
        return true;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".allProceduresAreCallable(): " + false);
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsTransactions(): " + true);
        }
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMultipleTransactions(): " + true);
        }
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 8: {
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                if (this.std_catl_lvl < 605) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsTransactionIsolationLevel( " + n + " ): " + bl);
        }
        return bl;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDefaultTransactionIsolation(): " + 8);
        }
        return 8;
    }

    public boolean supportsSavepoints() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("SAVEPOINTS");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSavepoints(): " + bl);
        }
        return bl;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOpenStatementsAcrossCommit(): " + true);
        }
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOpenStatementsAcrossRollback(): " + true);
        }
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOpenCursorsAcrossCommit(): " + false);
        }
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOpenCursorsAcrossRollback(): " + false);
        }
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsDataDefinitionAndDataManipulationTransactions() : " + true);
        }
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsDataManipulationTransactionsOnly(): " + false);
        }
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".dataDefinitionCausesTransactionCommit(): " + false);
        }
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".dataDefinitionIgnoredInTransactions(): " + false);
        }
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCatalogsInDataManipulation(): " + false);
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCatalogsInProcedureCalls(): " + false);
        }
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCatalogsInTableDefinitions(): " + false);
        }
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCatalogsInIndexDefinitions(): " + false);
        }
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCatalogsInPrivilegeDefinitions(): " + false);
        }
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OWNER_NAME");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSchemasInDataManipulation(): " + bl);
        }
        return bl;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OWNER_NAME");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSchemasInProcedureCalls(): " + bl);
        }
        return bl;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OWNER_NAME");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSchemasInTableDefinitions(): " + bl);
        }
        return bl;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OWNER_NAME");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSchemasInIndexDefinitions(): " + bl);
        }
        return bl;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OWNER_NAME");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSchemasInPrivilegeDefinitions(): " + bl);
        }
        return bl;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsAlterTableWithAddColumn(): " + false);
        }
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsAlterTableWithDropColumn(): " + "false");
        }
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsPositionedDelete(): " + true);
        }
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsPositionedUpdate(): " + true);
        }
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSelectForUpdate(): " + true);
        }
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".allTablesAreSelectable(): " + false);
        }
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("UNION");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsUnion(): " + bl);
        }
        return bl;
    }

    public boolean supportsUnionAll() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("UNION");
        if (string != null && !string.equals("ALL")) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsUnionAll(): " + bl);
        }
        return bl;
    }

    public boolean supportsOuterJoins() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("OUTER_JOIN");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOuterJoins(): " + bl);
        }
        return bl;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean bl = this.supportsOuterJoins();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsLimitedOuterJoins(): " + bl);
        }
        return bl;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        boolean bl = this.supportsOuterJoins();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsFullOuterJoins(): " + bl);
        }
        return bl;
    }

    public boolean supportsGroupBy() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsGroupBy(): " + true);
        }
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsGroupByBeyondSelect(): " + true);
        }
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsGroupByUnrelated(): " + false);
        }
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsOrderByUnrelated(): " + false);
        }
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsExpressionsInOrderBy(): " + false);
        }
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSubqueriesInComparisons(): " + true);
        }
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSubqueriesInExists(): " + true);
        }
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSubqueriesInIns(): " + true);
        }
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsSubqueriesInQuantifieds(): " + true);
        }
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsCorrelatedSubqueries(): " + true);
        }
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsTableCorrelationNames(): " + true);
        }
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsDifferentTableCorrelationNames(): " + false);
        }
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsColumnAliasing(): " + true);
        }
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsNonNullableColumns(): " + true);
        }
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsConvert(): " + true);
        }
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        String string = this.getStringType(n);
        String string2 = this.getStringType(n2);
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = SqlParse.getConvertTypes();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsConvert( " + n + ", " + n2 + " ): ");
        }
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            if (!enumeration2.nextElement().toString().equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            bl = false;
            enumeration2 = enumeration;
            while (enumeration2.hasMoreElements()) {
                if (!enumeration2.nextElement().toString().equals(string2)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            if (n2 == n) {
                bl2 = true;
            } else if (n2 == -4 || n2 == -1) {
                bl2 = false;
            } else if (n2 == -2 || n2 == -3) {
                if (n != -7 && n != 16 && n != -5 && n != -1) {
                    bl2 = true;
                }
            } else if (n2 == 1 || n2 == 12) {
                if (n != -7 && n != 16 && n != -5) {
                    bl2 = true;
                }
            } else if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 4 || n2 == 7 || n2 == 5 || n2 == -6) {
                if (n == 1 || n == 3 || n == 8 || n == 6 || n == 2 || n == 4 || n == 7 || n == 5 || n == -6 || n == 12) {
                    bl2 = true;
                }
            } else if (n2 == 91) {
                if (n == 1 || n == 12 || n == 93) {
                    bl2 = true;
                }
            } else if (n2 == 92) {
                if (n == 1 || n == 12 || n == 93) {
                    bl2 = true;
                }
            } else if (n2 == 93 && (n == 1 || n == 12 || n == 91 || n == 92)) {
                bl2 = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsConvert( " + n + ", " + n2 + " ): " + bl2);
        }
        return bl2;
    }

    public String getSQLKeywords() throws SQLException {
        String string = "abort,byref,callproc,comment,copy,define,disable,do,elseif,enable,endif,endloop,endwhile,excluding,if,import,index,integrity,message,modify,permit,raise,referencing,register,relocate,remove,repeat,return,save,savepoint,until,while.";
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLKeywords(): " + string);
        }
        return string;
    }

    public String getNumericFunctions() throws SQLException {
        String string = SqlParse.getNumFuncs();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNumericFunctions(): " + string);
        }
        return string;
    }

    public String getStringFunctions() throws SQLException {
        String string = SqlParse.getStrFuncs();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getStringFunctions(): " + string);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        String string = SqlParse.getSysFuncs();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSystemFunctions(): " + string);
        }
        return string;
    }

    public String getTimeDateFunctions() throws SQLException {
        String string = SqlParse.getTdtFuncs();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimeDateFunctions(): " + string);
        }
        return string;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("ESCAPE");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsLikeEscapeClause(): " + bl);
        }
        return bl;
    }

    public String getSearchStringEscape() throws SQLException {
        String string = "\\";
        String string2 = this.conn.dbCaps.getDbCap("ESCAPE_CHAR");
        if (string2 != null) {
            string = string2;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSearchStringEscape(): " + string);
        }
        return string;
    }

    public String getExtraNameCharacters() throws SQLException {
        String string = "@#$";
        String string2 = this.conn.dbCaps.getDbCap("IDENT_CHAR");
        if (string2 != null) {
            string = string2;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getExtraNameCharacters(): " + string);
        }
        return string;
    }

    public String getIdentifierQuoteString() throws SQLException {
        String string;
        String string2 = string = this.conn.dbCaps.getDbCap("DB_DELIMITED_CASE") != null ? "\"" : space;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getIdentifierQuoteString(): '" + string + "'");
        }
        return string;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("DB_NAME_CASE");
        if (string != null && !string.equals("LOWER")) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesLowerCaseIdentifiers(): " + bl);
        }
        return bl;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesUpperCaseIdentifiers(): " + this.upper);
        }
        return this.upper;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesMixedCaseIdentifiers(): " + false);
        }
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("DB_NAME_CASE");
        if (string != null && string.equals("MIXED")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMixedCaseIdentifiers(): " + bl);
        }
        return bl;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("DB_DELIMITED_CASE");
        if (string != null && string.equals("LOWER")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesLowerCaseQuotedIdentifiers(): " + bl);
        }
        return bl;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("DB_DELIMITED_CASE");
        if (string != null && string.equals("UPPER")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesUpperCaseQuotedIdentifiers(): " + bl);
        }
        return bl;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".storesMixedCaseQuotedIdentifiers(): " + false);
        }
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("DB_DELIMITED_CASE");
        if (string != null && string.equals("MIXED")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".supportsMixedCaseQuotedIdentifiers(): " + bl);
        }
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        boolean bl = true;
        String string = this.conn.dbCaps.getDbCap("NULL_SORTING");
        if (string != null && !string.equals("HIGH")) {
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nullsAreSortedHigh(): " + bl);
        }
        return bl;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("NULL_SORTING");
        if (string != null && string.equals("LOW")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nullsAreSortedLow(): " + bl);
        }
        return bl;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("NULL_SORTING");
        if (string != null && string.equals("FIRST")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nullsAreSortedAtStart(): " + bl);
        }
        return bl;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean bl = false;
        String string = this.conn.dbCaps.getDbCap("NULL_SORTING");
        if (string != null && string.equals("LAST")) {
            bl = true;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nullsAreSortedAtEnd(): " + bl);
        }
        return bl;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nullPlusNonNullIsNull(): " + true);
        }
        return true;
    }

    public boolean deletesAreDetected(int n) {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deletesAreDetected( " + n + " ): " + bl);
        }
        return bl;
    }

    public boolean insertsAreDetected(int n) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertsAreDetected( " + n + " ): " + false);
        }
        return false;
    }

    public boolean updatesAreDetected(int n) {
        boolean bl = false;
        switch (n) {
            case 1003: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updatesAreDetected( " + n + " ): " + bl);
        }
        return bl;
    }

    public boolean ownDeletesAreVisible(int n) {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".ownDeletesAreVisible( " + n + " ): " + bl);
        }
        return bl;
    }

    public boolean ownInsertsAreVisible(int n) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".ownInsertsAreVisible( " + n + " ): " + false);
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".ownUpdatesAreVisible( " + n + " ): " + bl);
        }
        return bl;
    }

    public boolean othersDeletesAreVisible(int n) {
        boolean bl = false;
        switch (n) {
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".othersDeletesAreVisible(" + n + "): " + bl);
        }
        return bl;
    }

    public boolean othersInsertsAreVisible(int n) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".othersInsertsAreVisible(" + n + "): " + false);
        }
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) {
        boolean bl = false;
        switch (n) {
            case 1005: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".othersUpdatesAreVisible(" + n + "): " + bl);
        }
        return bl;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".locatorsUpdateCopy(): true");
        }
        return true;
    }

    public int getMaxConnections() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxConnections(): " + n);
        }
        return n;
    }

    public int getMaxStatements() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("SQL_MAX_STATEMENTS");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxStatements(): " + n);
        }
        return n;
    }

    public int getMaxRowSize() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("SQL_MAX_ROW_LEN");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxRowSize(): " + n);
        }
        return n;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".doesMaxRowSizeIncludeBlobs(): " + false);
        }
        return false;
    }

    public int getMaxIndexLength() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxIndexLength(): " + n);
        }
        return n;
    }

    public int getMaxStatementLength() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxStatementLength(): " + n);
        }
        return n;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxCatalogNameLength(): " + n);
        }
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        String string;
        int n = 32;
        if (this.std_catl_lvl < 605) {
            n = 20;
        }
        if ((string = this.conn.dbCaps.getDbCap("SQL_MAX_SCHEMA_NAME_LEN")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxSchemaNameLength(): " + n);
        }
        return n;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        int n = 32;
        if (this.std_catl_lvl < 605) {
            n = 20;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxProcedureNameLength(): " + n);
        }
        return n;
    }

    public int getMaxTableNameLength() throws SQLException {
        String string;
        int n = 32;
        if (this.std_catl_lvl < 605) {
            n = 20;
        }
        if ((string = this.conn.dbCaps.getDbCap("SQL_MAX_TABLE_NAME_LEN")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxTableNameLength(): " + n);
        }
        return n;
    }

    public int getMaxColumnNameLength() throws SQLException {
        String string;
        int n = 32;
        if (this.std_catl_lvl < 605) {
            n = 20;
        }
        if ((string = this.conn.dbCaps.getDbCap("SQL_MAX_COLUMN_NAME_LEN")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnNameLength(): " + n);
        }
        return n;
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxCursorNameLength(): " + 32);
        }
        return 32;
    }

    public int getMaxUserNameLength() throws SQLException {
        String string;
        int n = 32;
        if (this.std_catl_lvl < 605) {
            n = 20;
        }
        if ((string = this.conn.dbCaps.getDbCap("SQL_MAX_USER_NAME_LEN")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxUserNameLength(): " + n);
        }
        return n;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("SQL_MAX_BYTE_LITERAL_LEN");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxBinaryLiteralLength(): " + n);
        }
        return n;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("SQL_MAX_CHAR_LITERAL_LEN");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxCharLiteralLength(): " + n);
        }
        return n;
    }

    public int getMaxColumnsInTable() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("MAX_COLUMNS");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnsInTable(): " + n);
        }
        return n;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        int n = 0;
        String string = this.conn.dbCaps.getDbCap("MAX_COLUMNS");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnsInIndex(): " + n);
        }
        return n;
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxTablesInSelect(): " + 30);
        }
        return 30;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnsInSelect(): " + n);
        }
        return n;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnsInGroupBy(): " + n);
        }
        return n;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        int n = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMaxColumnsInOrderBy(): " + n);
        }
        return n;
    }

    public ResultSet getCatalogs() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogs(): " + null);
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)cat_desc.length, this.trace);
        for (int i = 0; i < cat_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.cat_desc[i].col_name = JdbcDBMD.cat_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.cat_desc[i].col_name, i + 1, JdbcDBMD.cat_desc[i].sql_type, JdbcDBMD.cat_desc[i].dbms_type, JdbcDBMD.cat_desc[i].length, (byte)0, (byte)0, false);
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    public ResultSet getSchemas() throws SQLException {
        MDschemaRS mDschemaRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)schema_desc.length, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchemas()");
        }
        String string = this.std_catl_lvl >= 605 ? "select schema_name from iischema order by schema_name" : "select table_owner from iitables union select table_owner from iiviews";
        for (int i = 0; i < schema_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.schema_desc[i].col_name = JdbcDBMD.schema_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.schema_desc[i].col_name, i + 1, JdbcDBMD.schema_desc[i].sql_type, JdbcDBMD.schema_desc[i].dbms_type, JdbcDBMD.schema_desc[i].length, (byte)0, (byte)0, false);
        }
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDschemaRS = new MDschemaRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getSchemas(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDschemaRS;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        MDprocedureRS mDprocedureRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)proc_desc.length, this.trace);
        String string4 = empty;
        for (int i = 0; i < proc_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.proc_desc[i].col_name = JdbcDBMD.proc_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.proc_desc[i].col_name, i + 1, JdbcDBMD.proc_desc[i].sql_type, JdbcDBMD.proc_desc[i].dbms_type, JdbcDBMD.proc_desc[i].length, (byte)0, (byte)0, false);
        }
        String string5 = "select distinct procedure_owner, procedure_name from iiprocedures";
        String string6 = " order by procedure_owner, procedure_name";
        if (this.conn.is_ingres) {
            string4 = " where system_use ='U'";
        }
        string4 = string4 + this.makePattern(string2, string4.length(), "procedure_owner", false);
        string4 = string4 + this.makePattern(string3, string4.length(), "procedure_name", false);
        String string7 = string5 + string4 + string6;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getProcedures( " + string + ", " + string2 + ", " + string3 + " )");
        }
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDprocedureRS = new MDprocedureRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string7));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getProcedures(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDprocedureRS;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        MDprocedureColRS mDprocedureColRS = null;
        String string5 = empty;
        String string6 = empty;
        String string7 = empty;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)procCol_desc.length, this.trace);
        for (int i = 0; i < procCol_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.procCol_desc[i].col_name = JdbcDBMD.procCol_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.procCol_desc[i].col_name, i + 1, JdbcDBMD.procCol_desc[i].sql_type, JdbcDBMD.procCol_desc[i].dbms_type, JdbcDBMD.procCol_desc[i].length, (byte)0, (byte)0, false);
        }
        string5 = "select distinct procedure_owner, procedure_name, param_name, param_datatype_code, param_datatype, param_scale, param_length, param_scale, param_nulls, param_sequence from iiproc_params";
        string6 = " order by procedure_owner, procedure_name, param_sequence";
        if (!this.conn.is_ingres) {
            string5 = "select distinct proc_owner, proc_name, param_name, param_datatype_code, param_datatype, param_scale, param_length, param_scale, param_null, param_sequence from iigwprocparams";
            string6 = " order by proc_owner, proc_name, param_sequence";
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getProcedureColumns( " + string + ", " + string2 + ", " + string3 + ", " + string4 + " )");
        }
        String string8 = "procedure_owner";
        if (!this.conn.is_ingres) {
            string8 = "proc_owner";
        }
        string7 = string7 + this.makePattern(string2, string7.length(), string8, false);
        string8 = "procedure_name";
        if (!this.conn.is_ingres) {
            string8 = "proc_name";
        }
        string7 = string7 + this.makePattern(string3, string7.length(), string8, false);
        string7 = string7 + this.makePattern(string4, string7.length(), "param_name", false);
        String string9 = string5 + string7 + string6;
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDprocedureColRS = new MDprocedureColRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string9));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getProcedureColumns(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDprocedureColRS;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n;
        String string4 = "select table_owner, table_name, table_type, system_use from iitables";
        String string5 = empty;
        String string6 = " order by table_type, table_owner, table_name";
        String string7 = " system_use = 'S' and table_type in ('T','V')";
        String[] stringArray2 = new String[3];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)tables_desc.length, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTables( " + string + ", " + string2 + ", " + string3 + ", " + stringArray + " )");
        }
        for (n = 0; n < tables_desc.length; ++n) {
            if (this.upper) {
                JdbcDBMD.tables_desc[n].col_name = JdbcDBMD.tables_desc[n].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.tables_desc[n].col_name, n + 1, JdbcDBMD.tables_desc[n].sql_type, JdbcDBMD.tables_desc[n].dbms_type, JdbcDBMD.tables_desc[n].length, (byte)0, (byte)0, false);
        }
        string5 = string5 + this.makePattern(string2, string5.length(), "table_owner", false);
        string5 = string5 + this.makePattern(string3, string5.length(), "table_name", false);
        if (stringArray == null) {
            bl3 = true;
            bl2 = true;
            bl = true;
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("TABLE")) {
                    bl = true;
                }
                if (stringArray[n].equals("VIEW")) {
                    bl2 = true;
                }
                if (!stringArray[n].equals("SYSTEM TABLE")) continue;
                bl3 = true;
            }
        }
        if (!(bl || bl2 || bl3)) {
            return new RsltData(this.conn, jdbcRSMD, null);
        }
        if (!bl && !bl2) {
            stringArray2[n2++] = string7;
        } else {
            stringArray2[n2] = " system_use <> 'S' and table_name not like 'ii%' and table_type";
            if (bl && bl2) {
                int n3 = n2;
                stringArray2[n3] = stringArray2[n3] + " in ('T','V')";
            } else if (bl) {
                int n4 = n2;
                stringArray2[n4] = stringArray2[n4] + " = 'T'";
            } else {
                int n5 = n2;
                stringArray2[n5] = stringArray2[n5] + " = 'V'";
            }
            if (bl3) {
                stringArray2[n2] = " ((" + stringArray2[n2] + ") or (" + string7 + "))";
            }
            ++n2;
        }
        if (n2 > 0) {
            string5 = string5.length() == 0 ? " where" : string5 + " and";
            string5 = string5 + stringArray2[0];
            for (n = 1; n < n2; ++n) {
                string5 = string5 + " and" + stringArray2[n];
            }
        }
        String string8 = string4 + string5 + string6;
        MDtableRS mDtableRS = null;
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDtableRS = new MDtableRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string8));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getTables(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDtableRS;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTableTypes()");
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD(1, this.trace);
        if (this.upper) {
            JdbcDBMD.tabtyp_desc.col_name = JdbcDBMD.tabtyp_desc.col_name.toUpperCase();
        }
        jdbcRSMD.setColumnInfo(JdbcDBMD.tabtyp_desc.col_name, 1, JdbcDBMD.tabtyp_desc.sql_type, JdbcDBMD.tabtyp_desc.dbms_type, JdbcDBMD.tabtyp_desc.length, (byte)0, (byte)0, false);
        return new RsltData(this.conn, jdbcRSMD, tableTypeValues);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        MDgetTablePrivRS mDgetTablePrivRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)tabpriv_desc.length, this.trace);
        String string4 = " select object_owner, object_name, permit_grantor, permit_user, text_segment from iipermits";
        String string5 = " where text_sequence = 1";
        String string6 = " order by object_owner, object_name";
        string5 = string5 + this.makePattern(string2, string5.length(), "object_owner", false);
        string5 = string5 + this.makePattern(string3, string5.length(), "object_name", false);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTablePrivileges( " + string + ", " + string2 + ", " + string3 + " )");
        }
        for (int i = 0; i < tabpriv_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.tabpriv_desc[i].col_name = JdbcDBMD.tabpriv_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.tabpriv_desc[i].col_name, i + 1, JdbcDBMD.tabpriv_desc[i].sql_type, JdbcDBMD.tabpriv_desc[i].dbms_type, JdbcDBMD.tabpriv_desc[i].length, (byte)0, (byte)0, false);
        }
        if (!this.conn.is_ingres) {
            return new RsltData(this.conn, jdbcRSMD, null);
        }
        String string7 = string4 + string5 + string6;
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDgetTablePrivRS = new MDgetTablePrivRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string7));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getTablePrivileges(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDgetTablePrivRS;
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSuperTables('" + string + "','" + string2 + "','" + string3 + "')");
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)tabsup_desc.length, this.trace);
        for (int i = 0; i < super_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.tabsup_desc[i].col_name = JdbcDBMD.tabsup_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.tabsup_desc[i].col_name, i + 1, JdbcDBMD.tabsup_desc[i].sql_type, JdbcDBMD.tabsup_desc[i].dbms_type, JdbcDBMD.tabsup_desc[i].length, (byte)0, (byte)0, false);
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        MDgetColRS mDgetColRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)getc_desc.length, this.trace);
        String string5 = this.conn.dbCaps.getDbCap("DBMS_TYPE");
        boolean bl = false;
        for (int i = 0; i < getc_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.getc_desc[i].col_name = JdbcDBMD.getc_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.getc_desc[i].col_name, i + 1, JdbcDBMD.getc_desc[i].sql_type, JdbcDBMD.getc_desc[i].dbms_type, JdbcDBMD.getc_desc[i].length, (byte)0, (byte)0, false);
        }
        String string6 = "select table_owner, table_name, column_name, column_ingdatatype, column_datatype, column_length, column_scale, column_nulls, column_sequence from iicolumns";
        String string7 = empty;
        String string8 = " order by table_owner, table_name, column_sequence";
        if (string5 != null && string5.equals("IDMS")) {
            bl = true;
        }
        string7 = string7 + this.makePattern(string2, string7.length(), "table_owner", bl);
        string7 = string7 + this.makePattern(string3, string7.length(), "table_name", bl);
        string7 = string7 + this.makePattern(string4, string7.length(), "column_name", bl);
        String string9 = string6 + string7 + string8;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumns( " + string + ", " + string2 + ", " + string3 + ", " + string4 + " )");
        }
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDgetColRS = new MDgetColRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string9));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getColumns(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDgetColRS;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        MDgetColPrivRS mDgetColPrivRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)getColPriv_desc.length, this.trace);
        String string5 = this.conn.dbCaps.getDbCap("DBMS_TYPE");
        String string6 = "select table_owner, table_name, column_name from iicolumns";
        String string7 = " where table_name = '" + string3 + "'";
        String string8 = " order by column_name";
        boolean bl = false;
        if (string5 != null && string5.equals("IDMS")) {
            bl = true;
        }
        string7 = string7 + this.makePattern(string4, string7.length(), "column_name", bl);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnPrivileges( " + string + ", " + string2 + ", " + string3 + ", " + string4 + " )");
        }
        for (int i = 0; i < getColPriv_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.getColPriv_desc[i].col_name = JdbcDBMD.getColPriv_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.getColPriv_desc[i].col_name, i + 1, JdbcDBMD.getColPriv_desc[i].sql_type, JdbcDBMD.getColPriv_desc[i].dbms_type, JdbcDBMD.getColPriv_desc[i].length, (byte)0, (byte)0, false);
        }
        String string9 = string6 + string7 + string8;
        try {
            Statement statement = this.conn.jdbc.createStatement();
            mDgetColPrivRS = new MDgetColPrivRS(this.conn, jdbcRSMD, (JdbcRslt)statement.executeQuery(string9));
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getColumnPrivileges(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDgetColPrivRS;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        int n2;
        PreparedStatement preparedStatement;
        JdbcRslt jdbcRslt = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)bestRow_desc.length, this.trace);
        for (int i = 0; i < bestRow_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.bestRow_desc[i].col_name = JdbcDBMD.bestRow_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.bestRow_desc[i].col_name, i + 1, JdbcDBMD.bestRow_desc[i].sql_type, JdbcDBMD.bestRow_desc[i].dbms_type, JdbcDBMD.bestRow_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBestRowIdentifier( " + string + ", " + string2 + ", " + string3 + ", " + n + ", " + bl + " )");
        }
        if (n == 0 && this.conn.is_ingres) {
            string5 = "select distinct 'tid' from iitables";
            string6 = " where table_type = 'T'";
            if (string2 != null) {
                string6 = string6 + " and table_owner = ?";
            }
            if (string3 != null) {
                string6 = string6 + " and table_name = ?";
            }
            string4 = string5 + string6;
            try {
                PreparedStatement preparedStatement2 = this.conn.jdbc.prepareStatement(string4);
                int n3 = 1;
                if (string2 != null) {
                    preparedStatement2.setObject(n3++, (Object)string2, this.param_type);
                }
                if (string3 != null) {
                    preparedStatement2.setObject(n3++, (Object)string3, this.param_type);
                }
                jdbcRslt = new MDgetBestRowRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement2.executeQuery(), false);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".getBestRowIdentifier(): failed (tid)!");
                }
                if (this.trace.enabled(1)) {
                    ((SqlEx)sQLException).trace(this.trace);
                }
                throw sQLException;
            }
            return jdbcRslt;
        }
        string5 = "select distinct c.column_name, c.column_ingdatatype,c.column_datatype, c.column_length, c.column_scale from iitables t, iicolumns c";
        string6 = " where t.table_name = c.table_name and t.table_owner = c.table_owner and t.unique_rule = 'U' and c.key_sequence <> 0";
        if (!bl) {
            string6 = string6 + " and c.column_nulls <> 'Y'";
        }
        if (string2 != null) {
            string6 = string6 + " and c.table_owner = ?";
        }
        if (string3 != null) {
            string6 = string6 + " and c.table_name = ?";
        }
        string4 = string5 + string6;
        try {
            preparedStatement = this.conn.jdbc.prepareStatement(string4);
            n2 = 1;
            if (string2 != null) {
                preparedStatement.setObject(n2++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n2++, (Object)string3, this.param_type);
            }
            if ((jdbcRslt = new MDgetBestRowRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery(), true)).next()) {
                jdbcRslt.close();
                jdbcRslt = new MDgetBestRowRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery(), true);
                return jdbcRslt;
            }
            jdbcRslt.close();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getBestRowIdentifier(): failed! (primary)");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        string5 = "select distinct i.index_name,i.index_owner, i.base_name,i.base_owner from iiindexes i";
        string6 = " where i.unique_rule = 'U'";
        if (string2 != null) {
            string6 = string6 + " and i.base_owner = ?";
        }
        if (string3 != null) {
            string6 = string6 + " and i.base_name = ?";
        }
        string4 = string5 + string6;
        try {
            preparedStatement = this.conn.jdbc.prepareStatement(string4);
            n2 = 1;
            if (string2 != null) {
                preparedStatement.setObject(n2++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n2++, (Object)string3, this.param_type);
            }
            jdbcRslt = (JdbcRslt)preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getBestRowIdentifier(): failed (idx1)!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        if (jdbcRslt.next()) {
            string7 = jdbcRslt.getString(1);
            string8 = jdbcRslt.getString(2);
            string9 = jdbcRslt.getString(3);
            string10 = jdbcRslt.getString(4);
            jdbcRslt.close();
        }
        jdbcRslt.close();
        string5 = "select distinct c.column_name, c.column_ingdatatype, c.column_datatype, c.column_length, c.column_scale from iicolumns c, iiindex_columns ic ";
        string6 = empty;
        if (string7 != null && string8 != null && string9 != null && string10 != null) {
            string6 = " where c.table_name = ? and c.table_owner = ? and ic.index_name = ? and ic.index_owner = ? and ic.column_name = c.column_name ";
        }
        if (!bl) {
            string6 = string6.length() == 0 ? string6 + " where c.column_nulls <> 'Y'" : string6 + " and c.column_nulls <> 'Y'";
        }
        string4 = string5 + string6;
        try {
            preparedStatement = this.conn.jdbc.prepareStatement(string4);
            n2 = 1;
            if (string7 != null && string8 != null && string9 != null && string10 != null) {
                preparedStatement.setObject(n2++, (Object)string9, this.param_type);
                preparedStatement.setObject(n2++, (Object)string10, this.param_type);
                preparedStatement.setObject(n2++, (Object)string7, this.param_type);
                preparedStatement.setObject(n2++, (Object)string8, this.param_type);
            }
            jdbcRslt = new MDgetBestRowRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery(), true);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getBestRowIdentifier(): failed (idx)!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return jdbcRslt;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)bestRow_desc.length, this.trace);
        for (int i = 0; i < bestRow_desc.length; ++i) {
            jdbcRSMD.setColumnInfo(JdbcDBMD.bestRow_desc[i].col_name, i + 1, JdbcDBMD.bestRow_desc[i].sql_type, JdbcDBMD.bestRow_desc[i].dbms_type, JdbcDBMD.bestRow_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getVersionColumns( " + string + ", " + string2 + ", " + string3 + " )");
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        MDindexRS mDindexRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)idx_desc.length, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getIndexInfo( " + string + ", " + string2 + ", " + string3 + ", " + bl + ", " + bl2 + " )");
        }
        String string4 = "select idx.base_owner, idx.base_name, idx.unique_rule, idx.index_owner, idx.index_name, idc.key_sequence, idc.column_name, idc.sort_direction from iiindexes idx, iiindex_columns idc ";
        String string5 = "where idx.index_owner = idc.index_owner and idx.index_name = idc.index_name ";
        String string6 = "order by 3 desc, 5, 6";
        if (string2 != null) {
            string5 = string5 + "and idx.base_owner = ? ";
        }
        if (string3 != null) {
            string5 = string5 + "and idx.base_name = ? ";
        }
        if (bl) {
            string5 = string5 + "and idx.unique_rule = 'U' ";
        }
        String string7 = string4 + string5 + string6;
        for (int i = 0; i < idx_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.idx_desc[i].col_name = JdbcDBMD.idx_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.idx_desc[i].col_name, i + 1, JdbcDBMD.idx_desc[i].sql_type, JdbcDBMD.idx_desc[i].dbms_type, JdbcDBMD.idx_desc[i].length, (byte)0, (byte)0, false);
        }
        try {
            PreparedStatement preparedStatement = this.conn.jdbc.prepareStatement(string7);
            int n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n++, (Object)string3, this.param_type);
            }
            mDindexRS = new MDindexRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getIndexInfo(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDindexRS;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        int n;
        PreparedStatement preparedStatement;
        int n2;
        JdbcRslt jdbcRslt = null;
        String string4 = this.conn.dbCaps.getDbCap("STANDARD_CATALOG_LEVEL");
        String string5 = empty;
        String string6 = empty;
        String string7 = empty;
        String string8 = null;
        int n3 = 0;
        if (string4 != null) {
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)pk_desc.length, this.trace);
        if (this.conn.is_ingres && n3 >= 605) {
            string5 = "select distinct k.schema_name, k.table_name, k.column_name, k.key_position, k.constraint_name from iikeys k, iiconstraints c";
            string6 = " where c.constraint_type = 'P'  and k.constraint_name = c.constraint_name";
            if (string2 != null) {
                string6 = string6 + " and k.schema_name = ?";
            }
            if (string3 != null) {
                string6 = string6 + " and k.table_name = ?";
            }
            string7 = " order by k.column_name";
        }
        for (n2 = 0; n2 < pk_desc.length; ++n2) {
            if (this.upper) {
                JdbcDBMD.pk_desc[n2].col_name = JdbcDBMD.pk_desc[n2].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.pk_desc[n2].col_name, n2 + 1, JdbcDBMD.pk_desc[n2].sql_type, JdbcDBMD.pk_desc[n2].dbms_type, JdbcDBMD.pk_desc[n2].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrimaryKeys( " + string + ", " + string2 + ", " + string3 + " )");
        }
        if ((string8 = string5 + string6 + string7).length() > 0) {
            try {
                PreparedStatement preparedStatement2 = this.conn.jdbc.prepareStatement(string8);
                int n4 = 1;
                if (string2 != null) {
                    preparedStatement2.setObject(n4++, (Object)string2, this.param_type);
                }
                if (string3 != null) {
                    preparedStatement2.setObject(n4, (Object)string3, this.param_type);
                }
                if ((jdbcRslt = new MDprimaryKeyRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement2.executeQuery(), true)).next()) {
                    jdbcRslt.close();
                    jdbcRslt = new MDprimaryKeyRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement2.executeQuery(), true);
                    return jdbcRslt;
                }
                jdbcRslt.close();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".getPrimaryKeys(): iikeys failed!");
                }
                if (this.trace.enabled(1)) {
                    ((SqlEx)sQLException).trace(this.trace);
                }
                throw sQLException;
            }
        }
        string5 = "select key_id from iialt_columns";
        string6 = " where key_sequence <> 0 ";
        if (string2 != null) {
            string6 = string6 + " and table_owner = ?";
        }
        if (string3 != null) {
            string6 = string6 + " and table_name = ?";
        }
        string8 = string5 + string6;
        try {
            preparedStatement = this.conn.jdbc.prepareStatement(string8);
            n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n, (Object)string3, this.param_type);
            }
            if ((jdbcRslt = (JdbcRslt)preparedStatement.executeQuery()).next()) {
                n2 = jdbcRslt.getInt(1);
                jdbcRslt.close();
                string5 = "select table_owner, table_name,  column_name, key_sequence from iialt_columns";
                string6 = " where key_sequence <> 0  and key_id = " + n2;
                string7 = " order by column_name";
                if (string2 != null) {
                    string6 = string6 + " and table_owner = ?";
                }
                if (string3 != null) {
                    string6 = string6 + " and table_name = ?";
                }
                string8 = string5 + string6 + string7;
                try {
                    preparedStatement = this.conn.jdbc.prepareStatement(string8);
                    n = 1;
                    if (string2 != null) {
                        preparedStatement.setObject(n++, (Object)string2, this.param_type);
                    }
                    if (string3 != null) {
                        preparedStatement.setObject(n, (Object)string3, this.param_type);
                    }
                    jdbcRslt = new MDprimaryKeyRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery(), false);
                    return jdbcRslt;
                }
                catch (SQLException sQLException) {
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".getPrimaryKeys(): full iialt_columns failed!");
                    }
                    if (this.trace.enabled(1)) {
                        ((SqlEx)sQLException).trace(this.trace);
                    }
                    throw sQLException;
                }
            }
            jdbcRslt.close();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getPrimaryKeys(): iialt_columns failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        string5 = "select t.table_owner, c.table_name, c.column_name, c.key_sequence from iitables t, iicolumns c";
        string6 = " where t.table_name = c.table_name and t.unique_rule  = 'U' and c.key_sequence <> 0";
        if (string2 != null) {
            string6 = string6 + " and t.table_owner = ?";
        }
        if (string3 != null) {
            string6 = string6 + " and t.table_name = ?";
        }
        string7 = " order by c.column_name";
        string8 = string5 + string6 + string7;
        try {
            preparedStatement = this.conn.jdbc.prepareStatement(string8);
            n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n, (Object)string3, this.param_type);
            }
            jdbcRslt = new MDprimaryKeyRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery(), false);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getPrimaryKeys(): iitables failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return jdbcRslt;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        MDkeysRS mDkeysRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)keys_desc.length, this.trace);
        for (int i = 0; i < keys_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.keys_desc[i].col_name = JdbcDBMD.keys_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.keys_desc[i].col_name, i + 1, JdbcDBMD.keys_desc[i].sql_type, JdbcDBMD.keys_desc[i].dbms_type, JdbcDBMD.keys_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getImportedKeys( " + string + ", " + string2 + ", " + string3 + " )");
        }
        if (!this.conn.is_ingres) {
            return new RsltData(this.conn, jdbcRSMD, null);
        }
        String string4 = " select distinct p.schema_name, p.table_name, p.column_name, f.schema_name, f.table_name, f.column_name, p.key_position, f.constraint_name, p.constraint_name from iikeys p, iiconstraints c, iiref_constraints rc, iikeys f";
        String string5 = " where c.constraint_type = 'R' and c.constraint_name = rc.ref_constraint_name and p.constraint_name = rc.unique_constraint_name and f.constraint_name = rc.ref_constraint_name and p.key_position = f.key_position ";
        String string6 = " order by 1, 2, 7";
        if (string2 != null) {
            string5 = string5 + " and f.schema_name = ?";
        }
        if (string3 != null) {
            string5 = string5 + " and f.table_name = ?";
        }
        String string7 = string4 + string5 + string6;
        try {
            PreparedStatement preparedStatement = this.conn.jdbc.prepareStatement(string7);
            int n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n++, (Object)string3, this.param_type);
            }
            mDkeysRS = new MDkeysRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getImportedKeys(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDkeysRS;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        MDkeysRS mDkeysRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)keys_desc.length, this.trace);
        for (int i = 0; i < keys_desc.length; ++i) {
            jdbcRSMD.setColumnInfo(JdbcDBMD.keys_desc[i].col_name, i + 1, JdbcDBMD.keys_desc[i].sql_type, JdbcDBMD.keys_desc[i].dbms_type, JdbcDBMD.keys_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getExportedKeys( " + string + ", " + string2 + ", " + string3 + " )");
        }
        if (!this.conn.is_ingres) {
            return new RsltData(this.conn, jdbcRSMD, null);
        }
        String string4 = " select distinct p.schema_name, p.table_name, p.column_name, f.schema_name, f.table_name, f.column_name, f.key_position, f.constraint_name, p.constraint_name from iikeys p, iiconstraints c, iiref_constraints rc, iikeys f";
        String string5 = " where c.constraint_type = 'R' and c.constraint_name = rc.ref_constraint_name and p.constraint_name = rc.unique_constraint_name and f.constraint_name = rc.ref_constraint_name and p.key_position = f.key_position ";
        String string6 = " order by 4, 5, 7";
        if (string2 != null) {
            string5 = string5 + " and p.schema_name = ? ";
        }
        if (string3 != null) {
            string5 = string5 + " and p.table_name = ? ";
        }
        String string7 = string4 + string5 + string6;
        try {
            PreparedStatement preparedStatement = this.conn.jdbc.prepareStatement(string7);
            int n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n++, (Object)string3, this.param_type);
            }
            mDkeysRS = new MDkeysRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getExportedKeys(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDkeysRS;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        MDkeysRS mDkeysRS = null;
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)keys_desc.length, this.trace);
        for (int i = 0; i < keys_desc.length; ++i) {
            jdbcRSMD.setColumnInfo(JdbcDBMD.keys_desc[i].col_name, i + 1, JdbcDBMD.keys_desc[i].sql_type, JdbcDBMD.keys_desc[i].dbms_type, JdbcDBMD.keys_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCrossReference( " + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + " )");
        }
        if (!this.conn.is_ingres) {
            return new RsltData(this.conn, jdbcRSMD, null);
        }
        String string7 = " select distinct p.schema_name, p.table_name, p.column_name, f.schema_name, f.table_name, f.column_name, f.key_position, f.constraint_name, p.constraint_name from iikeys p, iiconstraints c, iiref_constraints rc, iikeys f";
        String string8 = " where c.constraint_type = 'R' and c.constraint_name = rc.ref_constraint_name and p.constraint_name = rc.unique_constraint_name and f.constraint_name = rc.ref_constraint_name and p.key_position = f.key_position ";
        String string9 = " order by 4, 5, 7";
        if (string2 != null) {
            string8 = string8 + " and p.schema_name = ?";
        }
        if (string5 != null) {
            string8 = string8 + " and f.schema_name = ?";
        }
        if (string3 != null) {
            string8 = string8 + " and p.table_name = ?";
        }
        if (string6 != null) {
            string8 = string8 + " and f.table_name = ?";
        }
        String string10 = string7 + string8 + string9;
        try {
            PreparedStatement preparedStatement = this.conn.jdbc.prepareStatement(string10);
            int n = 1;
            if (string2 != null) {
                preparedStatement.setObject(n++, (Object)string2, this.param_type);
            }
            if (string5 != null) {
                preparedStatement.setObject(n++, (Object)string5, this.param_type);
            }
            if (string3 != null) {
                preparedStatement.setObject(n++, (Object)string3, this.param_type);
            }
            if (string6 != null) {
                preparedStatement.setObject(n++, (Object)string6, this.param_type);
            }
            mDkeysRS = new MDkeysRS(this.conn, jdbcRSMD, (JdbcRslt)preparedStatement.executeQuery());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getCrossReference(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
        return mDkeysRS;
    }

    public ResultSet getTypeInfo() throws SQLException {
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)md_desc.length, this.trace);
        for (int i = 0; i < md_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.md_desc[i].col_name = JdbcDBMD.md_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.md_desc[i].col_name, i + 1, JdbcDBMD.md_desc[i].sql_type, JdbcDBMD.md_desc[i].dbms_type, JdbcDBMD.md_desc[i].length, (byte)0, (byte)0, false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTypeInfo()");
        }
        SqlData[][] sqlDataArray = this.conn.sqlLevel > 0 ? sqlTypeValues : OpenSqlTypeValues;
        SqlData[][] sqlDataArray2 = new SqlData[sqlDataArray.length][];
        for (int i = 0; i < sqlDataArray.length; ++i) {
            int n;
            String string = null;
            sqlDataArray2[i] = new SqlData[sqlDataArray[i].length];
            for (n = 0; n < sqlDataArray[i].length; ++n) {
                sqlDataArray2[i][n] = sqlDataArray[i][n];
            }
            if (sqlDataArray2[i][0] == S_CHAR) {
                string = this.conn.dbCaps.getDbCap("SQL_MAX_CHAR_COLUMN_LEN");
            } else if (sqlDataArray2[i][0] == S_VCH) {
                string = this.conn.dbCaps.getDbCap("SQL_MAX_VCHR_COLUMN_LEN");
            } else if (sqlDataArray2[i][0] == S_BYTE) {
                string = this.conn.dbCaps.getDbCap("SQL_MAX_BYTE_COLUMN_LEN");
            } else if (sqlDataArray2[i][0] == S_VBYT) {
                string = this.conn.dbCaps.getDbCap("SQL_MAX_VBYT_COLUMN_LEN");
            }
            if (string == null) continue;
            try {
                n = 0;
                n = Integer.parseInt(string);
                sqlDataArray2[i][2] = new SqlInt(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new RsltData(this.conn, jdbcRSMD, sqlDataArray2);
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSuperTypes('" + string + "','" + string2 + "','" + string3 + "')");
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)super_desc.length, this.trace);
        for (int i = 0; i < super_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.super_desc[i].col_name = JdbcDBMD.super_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.super_desc[i].col_name, i + 1, JdbcDBMD.super_desc[i].sql_type, JdbcDBMD.super_desc[i].dbms_type, JdbcDBMD.super_desc[i].length, (byte)0, (byte)0, false);
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUDTs( " + string + ", " + string2 + ", " + string3 + " )");
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)udt_desc.length, this.trace);
        for (int i = 0; i < udt_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.udt_desc[i].col_name = JdbcDBMD.udt_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.udt_desc[i].col_name, i + 1, JdbcDBMD.udt_desc[i].sql_type, JdbcDBMD.udt_desc[i].dbms_type, JdbcDBMD.udt_desc[i].length, (byte)0, (byte)0, false);
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUDTs('" + string + "','" + string2 + "','" + string3 + "','" + string4 + "')");
        }
        JdbcRSMD jdbcRSMD = new JdbcRSMD((short)att_desc.length, this.trace);
        for (int i = 0; i < att_desc.length; ++i) {
            if (this.upper) {
                JdbcDBMD.att_desc[i].col_name = JdbcDBMD.att_desc[i].col_name.toUpperCase();
            }
            jdbcRSMD.setColumnInfo(JdbcDBMD.att_desc[i].col_name, i + 1, JdbcDBMD.att_desc[i].sql_type, JdbcDBMD.att_desc[i].dbms_type, JdbcDBMD.att_desc[i].length, (byte)0, (byte)0, false);
        }
        return new RsltData(this.conn, jdbcRSMD, null);
    }

    private String makePattern(String string, int n, String string2, boolean bl) throws SQLException {
        String string3;
        String string4 = this.conn.dbCaps.getDbCap("DBMS_TYPE");
        String string5 = empty;
        String string6 = "trim(";
        String string7 = ")";
        int n2 = 0;
        String string8 = this.conn.dbCaps.getDbCap("INGRES/SQL_LEVEL");
        if (string8 != null) {
            try {
                n2 = Integer.parseInt(string8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".makePattern(" + string + ", " + n + ", " + string2 + ", " + bl + ") - dbmsType=" + string4);
        }
        if (bl) {
            string3 = " = ";
            string7 = "";
            string6 = "";
            if (string != null && string.equals("%")) {
                string = null;
            }
        } else {
            string3 = " like ";
            if (string4 != null) {
                if (string4.equals("DB2")) {
                    string6 = "rtrim(";
                } else if (string4.equals("INGRES") && n2 == 601) {
                    string7 = "";
                    string6 = "";
                    if (string != null && string.length() >= 1 && string.length() < 24 && string.charAt(string.length() - 1) != '%') {
                        string = string + " %";
                    }
                }
            }
        }
        if (string != null) {
            string5 = n == 0 ? " where " : " and ";
            string5 = string5 + string6 + string2 + string7 + string3 + "'" + string + "'";
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".makePattern(): " + string + "," + string5);
        }
        return string5;
    }

    private String getStringType(int n) throws SqlEx {
        switch (n) {
            case 0: {
                return "NULL";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 70: {
                return "DATALINK";
            }
            case 1111: {
                return "OTHER";
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ": Unsupported SQL type " + n);
        }
        throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
    }

    private static int convToJavaType(short s, int n) {
        switch (s) {
            case 3: {
                return 93;
            }
            case 4: {
                return 91;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 92;
            }
            case 7: {
                return 92;
            }
            case 8: {
                return 92;
            }
            case 9: {
                return 93;
            }
            case 10: {
                return 3;
            }
            case 18: {
                return 93;
            }
            case 19: {
                return 93;
            }
            case 20: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 21: {
                return 12;
            }
            case 27: {
                return 12;
            }
            case 22: {
                return -1;
            }
            case 28: {
                return -1;
            }
            case 23: {
                return -2;
            }
            case 24: {
                return -3;
            }
            case 25: {
                return -4;
            }
            case 30: {
                switch (n) {
                    case 1: {
                        return -6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 4;
                    }
                    case 8: {
                        return -5;
                    }
                }
                return 0;
            }
            case 31: {
                switch (n) {
                    case 4: {
                        return 7;
                    }
                    case 8: {
                        return 8;
                    }
                }
                return 0;
            }
            case 32: {
                return 1;
            }
            case 33: {
                return 12;
            }
            case 34: {
                return 12;
            }
            case 37: {
                return 12;
            }
            case 41: {
                return 12;
            }
        }
        return 0;
    }

    private static int colSize(int n, int n2) throws SqlEx {
        switch (n2) {
            case 3: {
                switch (n) {
                    case 5: {
                        return 14;
                    }
                }
                return -1;
            }
            case -3: 
            case -2: 
            case 1: 
            case 12: {
                return -1;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return 0;
            }
        }
        return -1;
    }

    private static class MDdesc {
        public String col_name = null;
        public int sql_type = 1111;
        public short dbms_type = 0;
        public short length = 0;

        public MDdesc(int n, short s, short s2, String string) {
            this.sql_type = n;
            this.dbms_type = s;
            this.length = s2;
            this.col_name = string;
        }
    }

    private static class MDkeysRS
    extends RsltXlat {
        public MDkeysRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            this.setNull(4);
            this.convert(5, 4);
            this.convert(6, 5);
            this.convert(7, 6);
            this.convert(8, 7);
            this.setShort(9, (short)0);
            this.setShort(10, (short)0);
            this.convert(11, 8);
            this.convert(12, 9);
            this.setShort(13, (short)7);
        }
    }

    private static class MDprimaryKeyRS
    extends RsltXlat {
        private boolean is_ingres;

        public MDprimaryKeyRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt, boolean bl) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
            this.is_ingres = bl;
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            this.convert(4, 4);
            if (this.is_ingres) {
                this.convert(5, 5);
            } else {
                this.setNull(5);
            }
        }
    }

    private static class MDindexRS
    extends RsltXlat {
        public MDindexRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            String string = this.dbmsRS.getString(3);
            this.setBoolean(3, string != null && string.equals("D"));
            this.convert(4, 4);
            this.convert(5, 5);
            this.setShort(6, (short)3);
            this.convert(7, 6);
            this.convert(8, 7);
            this.convert(9, 8);
            this.setInt(10, 0);
            this.setInt(11, 0);
            this.setNull(12);
        }
    }

    private static class MDgetBestRowRS
    extends RsltXlat {
        private boolean pkyOrIdx;

        public MDgetBestRowRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt, boolean bl) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
            this.pkyOrIdx = bl;
        }

        protected void load_data() throws SQLException {
            this.setShort(0, (short)0);
            if (!this.pkyOrIdx) {
                this.convert(1, 1);
                this.setShort(2, (short)4);
                this.setString(3, "TID");
                this.setInt(4, 10);
                this.setNull(5);
                this.setShort(7, (short)2);
            } else {
                this.convert(1, 1);
                short s = (short)Math.abs(this.dbmsRS.getInt(2));
                int n = this.dbmsRS.getInt(4);
                int n2 = JdbcDBMD.convToJavaType(s, n);
                this.setShort(2, (short)n2);
                this.convert(3, 3);
                int n3 = JdbcDBMD.colSize(s, n2);
                if (n3 < 0) {
                    this.convert(4, 4);
                } else {
                    this.setInt(4, n3);
                }
                this.convert(5, 5);
                this.setShort(7, (short)1);
            }
            this.setShort(6, (short)0);
        }
    }

    private static class MDgetColPrivRS
    extends RsltXlat {
        public MDgetColPrivRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            this.convert(4, 1);
            this.setNull(5);
            this.setNull(6);
            this.setNull(7);
        }
    }

    private static class MDgetColRS
    extends RsltXlat {
        public MDgetColRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            short s = this.dbmsRS.getShort(4);
            if (s != -1) {
                s = (short)Math.abs(s);
            } else {
                String string = this.dbmsRS.getString(5).toLowerCase();
                s = (short)IdMap.get(string, DbmsConst.dataTypeMap);
            }
            int n = this.dbmsRS.getInt(6);
            int n2 = JdbcDBMD.convToJavaType(s, n);
            this.setInt(4, n2);
            this.convert(5, 5);
            int n3 = JdbcDBMD.colSize(s, n2);
            if (n3 < 0) {
                this.convert(6, 6);
                this.convert(15, 6);
            } else {
                this.setInt(6, n3);
                this.setInt(15, n3);
            }
            this.setNull(7);
            if (s == 5) {
                this.setInt(8, 2);
            } else {
                this.convert(8, 7);
            }
            this.convert(16, 9);
            this.setInt(9, 10);
            String string = this.dbmsRS.getString(8);
            if (string == null || string.length() < 1) {
                this.setInt(10, 2);
                this.setString(17, empty);
            } else if (string.equals("N")) {
                this.setInt(10, 0);
                this.setString(17, NO);
            } else {
                this.setInt(10, 1);
                this.setString(17, YES);
            }
            this.setNull(11);
            this.setNull(12);
            this.setNull(13);
            this.setNull(14);
            this.convert(16, 9);
            this.setNull(18);
            this.setNull(19);
            this.setNull(20);
            this.setNull(21);
        }
    }

    private static class MDgetTablePrivRS
    extends RsltXlat {
        public MDgetTablePrivRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            this.convert(4, 4);
            String string = this.dbmsRS.getString(5);
            if (string == null) {
                this.setNull(5);
            } else {
                this.setString(5, string.substring(6, string.lastIndexOf("on")).toUpperCase());
            }
            this.setNull(6);
        }
    }

    private static class MDtableRS
    extends RsltXlat {
        public MDtableRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            String string = this.dbmsRS.getString(3);
            String string2 = this.dbmsRS.getString(4);
            if (string == null || string.length() < 1) {
                string = space;
            }
            if (string2 == null || string2.length() < 1) {
                string2 = space;
            }
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            if (string2.charAt(0) == 'S') {
                this.setString(3, "SYSTEM TABLE");
            } else {
                switch (string.charAt(0)) {
                    case 'T': {
                        this.setString(3, "TABLE");
                        break;
                    }
                    case 'V': {
                        this.setString(3, "VIEW");
                        break;
                    }
                    default: {
                        this.setString(3, "UNKNOWN");
                    }
                }
            }
            this.setNull(4);
            this.setNull(5);
            this.setNull(6);
            this.setNull(7);
            this.setNull(8);
            this.setNull(9);
        }
    }

    private static class MDprocedureColRS
    extends RsltXlat {
        public MDprocedureColRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.convert(3, 3);
            this.setShort(4, (short)0);
            short s = (short)Math.abs(this.dbmsRS.getInt(4));
            int n = this.dbmsRS.getInt(7);
            int n2 = JdbcDBMD.convToJavaType(s, n);
            this.setShort(5, (short)n2);
            this.convert(6, 5);
            this.convert(7, 6);
            this.convert(8, 7);
            this.convert(9, 8);
            this.setShort(10, (short)10);
            String string = this.dbmsRS.getString(9);
            if (string == null || string.length() < 1) {
                this.setShort(11, (short)2);
            } else if (string.equals("N")) {
                this.setShort(11, (short)0);
            } else {
                this.setShort(11, (short)1);
            }
            this.setNull(12);
        }
    }

    private static class MDprocedureRS
    extends RsltXlat {
        public MDprocedureRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.setNull(0);
            this.convert(1, 1);
            this.convert(2, 2);
            this.setNull(3);
            this.setNull(4);
            this.setNull(5);
            this.setNull(6);
            this.setShort(7, (short)0);
        }
    }

    private static class MDschemaRS
    extends RsltXlat {
        public MDschemaRS(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
            super(drvConn, jdbcRSMD, jdbcRslt);
        }

        protected void load_data() throws SQLException {
            this.convert(0, 1);
            this.setNull(1);
        }
    }
}

