/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Enumeration;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.context.StringKeyedMapAdapter;

public class PortletSessionMap
extends StringKeyedMapAdapter
implements ExternalContext.SharedMap {
    private PortletRequest request;

    public PortletSessionMap(PortletRequest request) {
        this.request = request;
    }

    private PortletSession getSession() {
        return this.request.getPortletSession(false);
    }

    protected Object getAttribute(String key) {
        PortletSession session = this.getSession();
        return session == null ? null : session.getAttribute(key);
    }

    protected void setAttribute(String key, Object value) {
        this.request.getPortletSession(true).setAttribute(key, value);
    }

    protected void removeAttribute(String key) {
        PortletSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    protected Enumeration getAttributeNames() {
        PortletSession session = this.getSession();
        return session == null ? CollectionUtils.EMPTY_ENUMERATION : session.getAttributeNames();
    }

    public Object getMutex() {
        PortletSession session = this.request.getPortletSession(true);
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        return mutex != null ? mutex : session;
    }
}

