/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.context.StringKeyedMapAdapter;

public class HttpSessionMap
extends StringKeyedMapAdapter
implements ExternalContext.SharedMap {
    private HttpServletRequest request;

    public HttpSessionMap(HttpServletRequest request) {
        this.request = request;
    }

    private HttpSession getSession() {
        return this.request.getSession(false);
    }

    protected Object getAttribute(String key) {
        HttpSession session = this.getSession();
        return session == null ? null : session.getAttribute(key);
    }

    protected void setAttribute(String key, Object value) {
        this.request.getSession(true).setAttribute(key, value);
    }

    protected void removeAttribute(String key) {
        HttpSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    protected Enumeration getAttributeNames() {
        HttpSession session = this.getSession();
        return session == null ? CollectionUtils.EMPTY_ENUMERATION : session.getAttributeNames();
    }

    public Object getMutex() {
        HttpSession session = this.request.getSession(true);
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        return mutex != null ? mutex : session;
    }
}

