/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.webflow.execution.FlowExecution;

public class FlowExecutionByteArray
implements Serializable {
    private static final long serialVersionUID = -6346556580752644469L;
    private byte[] data;
    private boolean compressed;

    public FlowExecutionByteArray(byte[] data, boolean compressed) {
        this.data = data;
        this.compressed = compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionByteArray(FlowExecution flowExecution, boolean compress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(384);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(flowExecution);
            oos.flush();
            this.data = compress ? this.compress(baos.toByteArray()) : baos.toByteArray();
        }
        finally {
            oos.close();
        }
        this.compressed = compress;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecution deserializeFlowExecution() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.getData(true)));
        try {
            FlowExecution flowExecution = (FlowExecution)ois.readObject();
            return flowExecution;
        }
        finally {
            ois.close();
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getData(boolean decompress) throws IOException {
        if (this.isCompressed() && decompress) {
            return this.decompress(this.data);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
        try {
            gzipos.write(dataToCompress);
            gzipos.flush();
        }
        finally {
            gzipos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decompress(byte[] dataToDecompress) throws IOException {
        GZIPInputStream gzipin = new GZIPInputStream(new ByteArrayInputStream(dataToDecompress));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)gzipin, (OutputStream)baos);
        }
        finally {
            gzipin.close();
        }
        return baos.toByteArray();
    }
}

