/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.io.File;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.XmlFlowBuilder;
import org.springframework.webflow.registry.ExternalizedFlowRegistrar;

public class XmlFlowRegistrar
extends ExternalizedFlowRegistrar {
    private static final String XML_SUFFIX = ".xml";

    protected boolean isFlowDefinition(File file) {
        return file.getName().endsWith(XML_SUFFIX);
    }

    protected FlowBuilder createFlowBuilder(Resource location, FlowArtifactFactory flowArtifactFactory) {
        return new XmlFlowBuilder(location, flowArtifactFactory);
    }

    protected String getFlowId(Resource location) {
        return StringUtils.delete((String)location.getFilename(), (String)XML_SUFFIX);
    }
}

