/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.Collection;
import java.util.Map;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.expression.SetPropertyAttempt;
import org.springframework.core.style.ToStringCreator;

public class CollectionAddingPropertyExpression
implements PropertyExpression {
    private Expression collectionExpression;

    public CollectionAddingPropertyExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public void setValue(Object target, Object value, Map context) throws EvaluationException {
        Collection collection = (Collection)this.evaluateAgainst(target, context);
        if (collection == null) {
            throw new EvaluationException((EvaluationAttempt)new SetPropertyAttempt(this.collectionExpression, target, value, context), (Throwable)new IllegalArgumentException("The collection expression evaluated to a [null] reference"));
        }
        if (value != null) {
            collection.add(value);
        }
    }

    public Object evaluateAgainst(Object target, Map context) throws EvaluationException {
        return this.collectionExpression.evaluateAgainst(target, context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("collectionExpression", (Object)this.collectionExpression).toString();
    }
}

