/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.Transition;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowExecutionContext;

public class MockRequestContext
implements RequestContext {
    private FlowExecutionContext flowExecutionContext = new MockFlowExecutionContext();
    private ExternalContext externalContext = new MockExternalContext();
    private AttributeMap requestScope = new AttributeMap();
    private Event lastEvent;
    private Transition lastTransition;
    private AttributeMap attributes = new AttributeMap();

    public MockRequestContext() {
    }

    public MockRequestContext(ParameterMap requestParameterMap) {
        this.externalContext = new MockExternalContext(requestParameterMap);
    }

    public Flow getActiveFlow() {
        return this.getFlowExecutionContext().getActiveSession().getFlow();
    }

    public State getCurrentState() {
        return this.getFlowExecutionContext().getActiveSession().getState();
    }

    public AttributeMap getRequestScope() {
        return this.requestScope;
    }

    public AttributeMap getFlowScope() {
        return this.getFlowExecutionContext().getActiveSession().getScope();
    }

    public AttributeMap getConversationScope() {
        return this.getFlowExecutionContext().getScope();
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public Transition getLastTransition() {
        return this.lastTransition;
    }

    public UnmodifiableAttributeMap getAttributes() {
        return this.attributes.unmodifiable();
    }

    public void setAttributes(AttributeCollection attributes) {
        this.attributes.replaceWith(attributes);
    }

    public UnmodifiableAttributeMap getModel() {
        return this.getConversationScope().union(this.getFlowScope()).union(this.getRequestScope()).unmodifiable();
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public void setLastTransition(Transition lastTransition) {
        this.lastTransition = lastTransition;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void setFlowExecutionContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public MockFlowExecutionContext getMockFlowExecutionContext() {
        return (MockFlowExecutionContext)this.flowExecutionContext;
    }

    public MockExternalContext getMockExternalContext() {
        return (MockExternalContext)this.externalContext;
    }

    public void setActiveSession(FlowSession flowSession) {
        this.getMockFlowExecutionContext().setActiveSession(flowSession);
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValues);
    }

    public AttributeMap getAttributeMap() {
        return this.attributes;
    }
}

