/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import java.io.IOException;

class PLPInputStream
extends BaseInputStream {
    static final long PLP_NULL = -1L;
    private static final long UNKNOWN_PLP_LEN = -2L;
    private static final byte[] EMPTY_PLP_BYTES = new byte[0];
    int payloadLength;
    private static final int PLP_EOS = -1;
    private int currentChunkRemain;
    private int markedChunkRemain;
    private int leftOverReadLimit = 0;
    private byte[] oneByteArray = new byte[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isNull(TDSReader tDSReader) throws SQLServerException {
        TDSReaderMark tDSReaderMark = tDSReader.mark();
        try {
            boolean bl = null == PLPInputStream.makeTempStream(tDSReader, false, null);
            return bl;
        }
        finally {
            tDSReader.reset(tDSReaderMark);
        }
    }

    static final PLPInputStream makeTempStream(TDSReader tDSReader, boolean bl, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        return PLPInputStream.makeStream(tDSReader, bl, bl, serverDTVImpl);
    }

    static final PLPInputStream makeStream(TDSReader tDSReader, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
        if (null != pLPInputStream) {
            pLPInputStream.setLoggingInfo(inputStreamGetterArgs.logContext);
        }
        return pLPInputStream;
    }

    private static final PLPInputStream makeStream(TDSReader tDSReader, boolean bl, boolean bl2, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        long l = tDSReader.readLong();
        if (-1L == l) {
            return null;
        }
        return new PLPInputStream(tDSReader, l, bl, bl2, serverDTVImpl);
    }

    PLPInputStream(TDSReader tDSReader, long l, boolean bl, boolean bl2, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, bl, bl2, serverDTVImpl);
        this.payloadLength = -2L != l ? (int)l : -1;
        this.markedChunkRemain = 0;
        this.currentChunkRemain = 0;
    }

    byte[] getBytes() throws SQLServerException {
        byte[] byArray;
        this.readBytesInternal(null, 0, 0);
        if (-1 == this.currentChunkRemain) {
            byArray = EMPTY_PLP_BYTES;
        } else {
            byArray = new byte[-1 != this.payloadLength ? this.payloadLength : this.currentChunkRemain];
            int n = 0;
            while (-1 != this.currentChunkRemain) {
                if (byArray.length == n) {
                    byte[] byArray2 = new byte[n + this.currentChunkRemain];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
                n += this.readBytesInternal(byArray, n, this.currentChunkRemain);
            }
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        return byArray;
    }

    public long skip(long l) throws IOException {
        long l2;
        this.checkClosed();
        if (l < 0L) {
            return 0L;
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (-1L == (l2 = (long)this.readBytes(null, 0, (int)l))) {
            return 0L;
        }
        return l2;
    }

    public int available() throws IOException {
        this.checkClosed();
        try {
            if (0 == this.currentChunkRemain) {
                this.readBytesInternal(null, 0, 0);
            }
            if (-1 == this.currentChunkRemain) {
                return 0;
            }
            int n = this.tdsReader.available();
            if (n > this.currentChunkRemain) {
                n = this.currentChunkRemain;
            }
            return n;
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        if (-1 != this.readBytes(this.oneByteArray, 0, 1)) {
            return this.oneByteArray[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        if (null == byArray) {
            throw new NullPointerException();
        }
        this.checkClosed();
        return this.readBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (null == byArray) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.checkClosed();
        return this.readBytes(byArray, n, n2);
    }

    int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (0 == n2) {
            return 0;
        }
        try {
            return this.readBytesInternal(byArray, n, n2);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private int readBytesInternal(byte[] byArray, int n, int n2) throws SQLServerException {
        if (-1 == this.currentChunkRemain) {
            return -1;
        }
        int n3 = 0;
        while (true) {
            if (0 == this.currentChunkRemain) {
                this.currentChunkRemain = (int)this.tdsReader.readUnsignedInt();
                assert (this.currentChunkRemain >= 0);
                if (0 == this.currentChunkRemain) {
                    this.currentChunkRemain = -1;
                    break;
                }
            }
            if (n3 == n2) break;
            int n4 = n2 - n3;
            if (n4 > this.currentChunkRemain) {
                n4 = this.currentChunkRemain;
            }
            if (null == byArray) {
                this.tdsReader.skip(n4);
            } else {
                this.tdsReader.readBytes(byArray, n + n3, n4);
            }
            n3 += n4;
            this.currentChunkRemain -= n4;
        }
        if (n3 > 0) {
            if (this.isReadLimitSet && this.leftOverReadLimit > 0) {
                this.leftOverReadLimit -= n3;
                if (this.leftOverReadLimit < 0) {
                    this.clearCurrentMark();
                }
            }
            return n3;
        }
        if (-1 == this.currentChunkRemain) {
            return -1;
        }
        return 0;
    }

    public void mark(int n) {
        if (null != this.tdsReader && n > 0) {
            this.currentMark = this.tdsReader.mark();
            this.markedChunkRemain = this.currentChunkRemain;
            this.leftOverReadLimit = n;
            this.setReadLimit(n);
        }
    }

    public void close() throws IOException {
        if (null == this.tdsReader) {
            return;
        }
        while (this.skip(this.tdsReader.getConnection().getTDSPacketSize()) != 0L) {
        }
        this.closeHelper();
    }

    public void reset() throws IOException {
        this.resetHelper();
        this.leftOverReadLimit = this.readLimit;
        this.currentChunkRemain = this.markedChunkRemain;
    }
}

