/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLFeatureNotSupportedException;
import com.microsoft.sqlserver.jdbc.SQLServerBlobOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerBlob
implements Blob,
Serializable {
    private byte[] value;
    private SQLServerConnection con;
    private boolean isClosed = false;
    ArrayList<Closeable> activeStreams = new ArrayList(1);
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerBlob");
    private static int baseID = 0;
    private final String traceID = " SQLServerBlob:" + SQLServerBlob.nextInstanceID();

    public final String toString() {
        return this.traceID;
    }

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    @Deprecated
    public SQLServerBlob(SQLServerConnection sQLServerConnection, byte[] byArray) {
        this.con = sQLServerConnection;
        if (null == byArray) {
            throw new NullPointerException(SQLServerException.getErrString("R_cantSetNull"));
        }
        this.value = byArray;
        if (logger.isLoggable(Level.FINE)) {
            String string = null != sQLServerConnection ? sQLServerConnection.toString() : "null connection";
            logger.fine(this.toString() + " created by (" + string + ")");
        }
    }

    SQLServerBlob(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.value = new byte[0];
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerConnection.toString() + ")");
        }
    }

    SQLServerBlob(BaseInputStream baseInputStream) throws SQLServerException {
        this.value = baseInputStream.getBytes();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (null connection)");
        }
    }

    public void free() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (!this.isClosed) {
            if (null != this.activeStreams) {
                for (Closeable closeable : this.activeStreams) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        logger.fine(this.toString() + " ignored IOException closing stream " + closeable + ": " + iOException.getMessage());
                    }
                }
                this.activeStreams = null;
            }
            this.value = null;
            this.isClosed = true;
        }
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{"Blob"}), null, true);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        return this.getBinaryStreamInternal(0, this.value.length);
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    private InputStream getBinaryStreamInternal(int n, int n2) {
        assert (null != this.value);
        assert (n >= 0);
        assert (0 <= n2 && n2 <= this.value.length - n);
        assert (null != this.activeStreams);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.value, n, n2);
        this.activeStreams.add(byteArrayInputStream);
        return byteArrayInputStream;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        Object[] objectArray;
        Object object;
        this.checkClosed();
        if (l < 1L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n < 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (--l > (long)this.value.length) {
            l = this.value.length;
        }
        if ((long)n > (long)this.value.length - l) {
            n = (int)((long)this.value.length - l);
        }
        object = new byte[n];
        System.arraycopy(this.value, (int)l, object, 0, n);
        return object;
    }

    public long length() throws SQLException {
        this.checkClosed();
        return this.value.length;
    }

    public long position(Blob blob, long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == blob) {
            return -1L;
        }
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == byArray) {
            return -1L;
        }
        for (int i = (int)(--l); i <= this.value.length - byArray.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray.length; ++j) {
                if (this.value[i + j] == byArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    public void truncate(long l) throws SQLException {
        Object object;
        this.checkClosed();
        if (l < 0L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if ((long)this.value.length > l) {
            object = new byte[(int)l];
            System.arraycopy(this.value, 0, object, 0, (int)l);
            this.value = (byte[])object;
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{l}), null, true);
        }
        return new SQLServerBlobOutputStream(this, l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.checkClosed();
        if (null == byArray) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        Object[] objectArray;
        Object object;
        this.checkClosed();
        if (null == byArray) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        if (n < 0 || n > byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n2 < 0 || n2 > byArray.length - n) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (l <= 0L || l > (long)(this.value.length + 1)) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if ((long)n2 >= (long)this.value.length - --l) {
            DataTypes.getCheckedLength(this.con, JDBCType.BLOB, l + (long)n2, false);
            assert (l + (long)n2 <= Integer.MAX_VALUE);
            object = new byte[(int)l + n2];
            System.arraycopy(this.value, 0, object, 0, (int)l);
            System.arraycopy(byArray, n, object, (int)l, n2);
            this.value = (byte[])object;
        } else {
            System.arraycopy(byArray, n, this.value, (int)l, n2);
        }
        return n2;
    }
}

