/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLFeatureNotSupportedException;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobWriter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class SQLServerClobBase
implements Serializable {
    private String value;
    private final SQLCollation sqlCollation;
    private boolean isClosed = false;
    private ArrayList<Closeable> activeStreams = new ArrayList(1);
    SQLServerConnection con;
    private final Logger logger;
    private final String traceID = this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + ":" + SQLServerClobBase.nextInstanceID();
    private static int baseID = 0;

    public final String toString() {
        return this.traceID;
    }

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    abstract JDBCType getJdbcType();

    private String getDisplayClassName() {
        String string = this.getJdbcType().className();
        return string.substring(1 + string.lastIndexOf(46));
    }

    SQLServerClobBase(SQLServerConnection sQLServerConnection, String string, SQLCollation sQLCollation, Logger logger) {
        this.con = sQLServerConnection;
        this.value = string;
        this.sqlCollation = sQLCollation;
        this.logger = logger;
        if (logger.isLoggable(Level.FINE)) {
            String string2 = null != sQLServerConnection ? sQLServerConnection.toString() : "null connection";
            logger.fine(this.toString() + " created by (" + string2 + ")");
        }
    }

    public void free() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (!this.isClosed) {
            if (null != this.activeStreams) {
                for (Closeable closeable : this.activeStreams) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        this.logger.fine(this.toString() + " ignored IOException closing stream " + closeable + ": " + iOException.getMessage());
                    }
                }
                this.activeStreams = null;
            }
            this.value = null;
            this.isClosed = true;
        }
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{this.getDisplayClassName()}), null, true);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        BufferedInputStream bufferedInputStream;
        this.checkClosed();
        if (null != this.sqlCollation && !this.sqlCollation.supportsAsciiConversion()) {
            DataTypes.throwConversionError(this.getDisplayClassName(), "AsciiStream");
        }
        try {
            bufferedInputStream = new BufferedInputStream(new ReaderInputStream(new StringReader(this.value), "US-ASCII", this.value.length()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLServerException(unsupportedEncodingException.getMessage(), null, 0, (Throwable)unsupportedEncodingException);
        }
        this.activeStreams.add(bufferedInputStream);
        return bufferedInputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        StringReader stringReader = new StringReader(this.value);
        this.activeStreams.add(stringReader);
        return stringReader;
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    public String getSubString(long l, int n) throws SQLException {
        Object[] objectArray;
        MessageFormat messageFormat;
        this.checkClosed();
        if (l < 1L) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (--l > (long)this.value.length()) {
            l = this.value.length();
        }
        if ((long)n > (long)this.value.length() - l) {
            n = (int)((long)this.value.length() - l);
        }
        return this.value.substring((int)l, (int)l + n);
    }

    public long length() throws SQLException {
        this.checkClosed();
        return this.value.length();
    }

    public long position(Clob clob, long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == clob) {
            return -1L;
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    public long position(String string, long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == string) {
            return -1L;
        }
        int n = this.value.indexOf(string, (int)(l - 1L));
        if (-1 != n) {
            return n + 1;
        }
        return -1L;
    }

    public void truncate(long l) throws SQLException {
        this.checkClosed();
        if (l < 0L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (l <= Integer.MAX_VALUE && (long)this.value.length() > l) {
            this.value = this.value.substring(0, (int)l);
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return new SQLServerClobAsciiOutputStream(this, l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        return new SQLServerClobWriter(this, l);
    }

    public int setString(long l, String string) throws SQLException {
        this.checkClosed();
        if (null == string) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        Object[] objectArray;
        Serializable serializable;
        this.checkClosed();
        if (null == string) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        if (n < 0 || n > string.length()) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if (n2 < 0 || n2 > string.length() - n) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if (l < 1L || l > (long)(this.value.length() + 1)) {
            serializable = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)serializable).format(objectArray), null, true);
        }
        if ((long)n2 >= (long)this.value.length() - --l) {
            DataTypes.getCheckedLength(this.con, this.getJdbcType(), l + (long)n2, false);
            assert (l + (long)n2 <= Integer.MAX_VALUE);
            serializable = new StringBuilder((int)l + n2);
            ((StringBuilder)serializable).append(this.value.substring(0, (int)l));
            ((StringBuilder)serializable).append(string.substring(n, n + n2));
            this.value = ((StringBuilder)serializable).toString();
        } else {
            serializable = new StringBuilder(this.value.length());
            ((StringBuilder)serializable).append(this.value.substring(0, (int)l));
            ((StringBuilder)serializable).append(string.substring(n, n + n2));
            ((StringBuilder)serializable).append(this.value.substring((int)l + n2));
            this.value = ((StringBuilder)serializable).toString();
        }
        return n2;
    }
}

