/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Util;
import javax.transaction.xa.Xid;

final class XidImpl
implements Xid {
    private final int formatId;
    private final byte[] gtrid;
    private final byte[] bqual;
    private final String traceID;

    public XidImpl(int n, byte[] byArray, byte[] byArray2) {
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
        this.traceID = " XID:" + XidImpl.xidDisplay(this);
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public String toString() {
        return this.traceID;
    }

    static String xidDisplay(Xid xid) {
        if (null == xid) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("formatId=");
        stringBuffer.append(xid.getFormatId());
        stringBuffer.append(" gtrid=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getGlobalTransactionId()));
        stringBuffer.append(" bqual=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getBranchQualifier()));
        return stringBuffer.toString();
    }
}

