/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierNode
implements ParseTreeNode {
    private final List<Segment> segments;

    public IdentifierNode(Segment ... segments) {
        if (segments.length < 1) {
            throw new IllegalArgumentException();
        }
        this.segments = UnmodifiableArrayList.asCopyOf(segments);
    }

    public IdentifierNode(List<Segment> segments) {
        if (segments.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.segments = new UnmodifiableArrayList<Segment>(segments.toArray(new Segment[segments.size()]));
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public List<Segment> getSegmentList() {
        return this.segments;
    }

    @Override
    public ParseRegion getRegion() {
        return IdentifierNode.sumSegmentRegions(this.segments);
    }

    private static ParseRegion sumSegmentRegions(final List<? extends Segment> segments) {
        return ParseRegion.sum((Iterable<ParseRegion>)new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                return ((Segment)segments.get(index)).getRegion();
            }

            @Override
            public int size() {
                return segments.size();
            }
        });
    }

    public IdentifierNode append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new IdentifierNode(newSegments);
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        writer.getPrintWriter().print(this.toString());
    }

    public String toString() {
        return IdentifierNode.unparseIdentifierList(this.segments);
    }

    @Override
    public IdentifierNode deepCopy() {
        return this;
    }

    public static List<Segment> parseIdentifier(String identifier) {
        return IdentifierParser.parseIdentifier(identifier);
    }

    static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        IdentifierNode.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Olap4jUtil.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    static String unparseIdentifierList(List<? extends Segment> segments) {
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = segments.get(i);
            if (i > 0) {
                buf.append('.');
            }
            segment.toString(buf);
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quoting {
        UNQUOTED,
        QUOTED,
        KEY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeySegment
    implements Segment {
        private final List<NameSegment> subSegmentList;

        public KeySegment(NameSegment ... subSegments) {
            if (subSegments.length < 1) {
                throw new IllegalArgumentException();
            }
            this.subSegmentList = UnmodifiableArrayList.asCopyOf(subSegments);
        }

        public KeySegment(List<NameSegment> subSegmentList) {
            if (subSegmentList.size() < 1) {
                throw new IllegalArgumentException();
            }
            this.subSegmentList = new UnmodifiableArrayList<NameSegment>(subSegmentList.toArray(new NameSegment[subSegmentList.size()]));
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        @Override
        public void toString(StringBuilder buf) {
            for (NameSegment segment : this.subSegmentList) {
                buf.append('&');
                segment.toString(buf);
            }
        }

        @Override
        public ParseRegion getRegion() {
            return IdentifierNode.sumSegmentRegions(this.subSegmentList);
        }

        @Override
        public Quoting getQuoting() {
            return Quoting.KEY;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public List<NameSegment> getKeyParts() {
            return this.subSegmentList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameSegment
    implements Segment {
        final String name;
        final Quoting quoting;
        private final ParseRegion region;

        public NameSegment(ParseRegion region, String name, Quoting quoting) {
            this.region = region;
            this.name = name;
            this.quoting = quoting;
            if (quoting != Quoting.QUOTED && quoting != Quoting.UNQUOTED) {
                throw new IllegalArgumentException();
            }
        }

        public NameSegment(String name) {
            this(null, name, Quoting.QUOTED);
        }

        @Override
        public String toString() {
            switch (this.quoting) {
                case UNQUOTED: {
                    return this.name;
                }
                case QUOTED: {
                    return IdentifierNode.quoteMdxIdentifier(this.name);
                }
            }
            throw Olap4jUtil.unexpected(this.quoting);
        }

        @Override
        public void toString(StringBuilder buf) {
            switch (this.quoting) {
                case UNQUOTED: {
                    buf.append(this.name);
                    return;
                }
                case QUOTED: {
                    IdentifierNode.quoteMdxIdentifier(this.name, buf);
                    return;
                }
            }
            throw Olap4jUtil.unexpected(this.quoting);
        }

        @Override
        public ParseRegion getRegion() {
            return this.region;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Quoting getQuoting() {
            return this.quoting;
        }

        @Override
        public List<NameSegment> getKeyParts() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Segment {
        public String toString();

        public void toString(StringBuilder var1);

        public ParseRegion getRegion();

        public Quoting getQuoting();

        public String getName();

        public List<NameSegment> getKeyParts();
    }
}

