/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mondrian.olap.Connection;
import mondrian.olap.MondrianException;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import org.apache.log4j.Logger;
import org.olap4j.metadata.XmlaConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaUtil
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger(XmlaUtil.class);
    private static final String[] CHAR_TABLE = new String[256];
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z].*");

    private static void initCharTable(String charStr) {
        char[] chars;
        for (char c : chars = charStr.toCharArray()) {
            XmlaUtil.CHAR_TABLE[c] = XmlaUtil.encodeChar(c);
        }
    }

    private static String encodeChar(char c) {
        StringBuilder buf = new StringBuilder();
        buf.append("_x");
        String str = Integer.toHexString(c);
        for (int i = 4 - str.length(); i > 0; --i) {
            buf.append("0");
        }
        return buf.append(str).append("_").toString();
    }

    public static String encodeElementName(String name) {
        char[] nameChars;
        StringBuilder buf = new StringBuilder();
        for (char ch : nameChars = name.toCharArray()) {
            String encodedStr;
            String string = encodedStr = ch >= CHAR_TABLE.length ? null : CHAR_TABLE[ch];
            if (encodedStr == null) {
                buf.append(ch);
                continue;
            }
            buf.append(encodedStr);
        }
        return buf.toString();
    }

    public static void element2Text(Element elem, StringWriter writer) throws XmlaException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(elem), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
    }

    public static Element text2Element(String text) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(new StringReader(text)));
    }

    public static Element stream2Element(InputStream stream) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(stream));
    }

    private static Element _2Element(InputSource source) throws XmlaException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
    }

    public static Element firstChildElement(Element parent, String ns, String lname) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaUtil.firstChildElement:  ns=\"" + ns + "\", lname=\"" + lname + "\""));
        }
        NodeList nlst = parent.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaUtil.firstChildElement:  e.getNamespaceURI()=\"" + e.getNamespaceURI() + "\", e.getLocalName()=\"" + e.getLocalName() + "\""));
            }
            if (ns != null && !ns.equals(e.getNamespaceURI()) || lname != null && !lname.equals(e.getLocalName())) continue;
            return e;
        }
        return null;
    }

    public static Element[] filterChildElements(Element parent, String ns, String lname) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nlst = parent.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (ns != null && !ns.equals(e.getNamespaceURI()) || lname != null && !lname.equals(e.getLocalName())) continue;
            elems.add(e);
        }
        return elems.toArray(new Element[elems.size()]);
    }

    public static String textInElement(Element elem) {
        StringBuilder buf = new StringBuilder(100);
        elem.normalize();
        NodeList nlst = elem.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Text)) continue;
            String data = ((Text)n).getData();
            buf.append(data);
        }
        return buf.toString();
    }

    public static Throwable rootThrowable(Throwable throwable) {
        Throwable rootThrowable = throwable.getCause();
        if (rootThrowable != null && rootThrowable instanceof MondrianException) {
            return XmlaUtil.rootThrowable(rootThrowable);
        }
        return throwable;
    }

    public static String normalizeNumericString(String numericStr) {
        int index = numericStr.indexOf(46);
        if (index > 0) {
            if (numericStr.indexOf(101) != -1) {
                return numericStr;
            }
            if (numericStr.indexOf(69) != -1) {
                return numericStr;
            }
            boolean found = false;
            int p = numericStr.length();
            char c = numericStr.charAt(p - 1);
            while (c == '0') {
                found = true;
                c = numericStr.charAt(--p - 1);
            }
            if (c == '.') {
                --p;
            }
            if (found) {
                return numericStr.substring(0, p);
            }
        }
        return numericStr;
    }

    public static MetadataRowset getMetadataRowset(final Connection connection, String catalogName, String methodName, final Map<String, Object> restrictionMap) {
        RowsetDefinition rowsetDefinition = RowsetDefinition.valueOf(methodName);
        final HashMap<String, String> propertyMap = new HashMap<String, String>();
        String dataSourceName = "xxx";
        propertyMap.put(PropertyDefinition.DataSourceInfo.name(), "xxx");
        DataSourcesConfig.DataSource dataSource = new DataSourcesConfig.DataSource();
        dataSource.name = "xxx";
        DataSourcesConfig.DataSources dataSources = new DataSourcesConfig.DataSources();
        dataSources.dataSources = new DataSourcesConfig.DataSource[]{dataSource};
        DataSourcesConfig.Catalog catalog = new DataSourcesConfig.Catalog();
        catalog.name = catalogName;
        catalog.definition = "dummy";
        dataSource.catalogs = new DataSourcesConfig.Catalogs();
        dataSource.catalogs.catalogs = new DataSourcesConfig.Catalog[]{catalog};
        Rowset rowset = rowsetDefinition.getRowset(new XmlaRequest(){

            @Override
            public XmlaConstants.Method getMethod() {
                return XmlaConstants.Method.DISCOVER;
            }

            @Override
            public Map<String, String> getProperties() {
                return propertyMap;
            }

            @Override
            public Map<String, Object> getRestrictions() {
                return restrictionMap;
            }

            @Override
            public String getStatement() {
                return null;
            }

            @Override
            public String getRoleName() {
                return null;
            }

            @Override
            public Role getRole() {
                return connection.getRole();
            }

            @Override
            public String getRequestType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDrillThrough() {
                throw new UnsupportedOperationException();
            }

            public XmlaConstants.Format getFormat() {
                throw new UnsupportedOperationException();
            }
        }, new XmlaHandler(dataSources, null, "xmla"){

            protected Connection getConnection(DataSourcesConfig.Catalog catalog, Role role, String roleName) throws XmlaException {
                return connection;
            }
        });
        ArrayList<Rowset.Row> rowList = new ArrayList<Rowset.Row>();
        rowset.populate(new DefaultXmlaResponse(new ByteArrayOutputStream(), Charset.defaultCharset().name(), Enumeration.ResponseMimeType.SOAP), rowList);
        MetadataRowset result = new MetadataRowset();
        ArrayList<RowsetDefinition.Column> colDefs = new ArrayList<RowsetDefinition.Column>();
        for (RowsetDefinition.Column columnDefinition : rowsetDefinition.columnDefinitions) {
            if (columnDefinition.type == RowsetDefinition.Type.Rowset) continue;
            colDefs.add(columnDefinition);
        }
        for (Rowset.Row row : rowList) {
            Object[] values = new Object[colDefs.size()];
            int k = -1;
            for (RowsetDefinition.Column colDef : colDefs) {
                Object o = row.get(colDef.name);
                if (o instanceof List) {
                    o = XmlaUtil.toString((List)o);
                } else if (o instanceof String[]) {
                    o = XmlaUtil.toString(Arrays.asList((String[])o));
                }
                values[++k] = o;
            }
            result.rowList.add(Arrays.asList(values));
        }
        for (RowsetDefinition.Column colDef : colDefs) {
            String columnName = colDef.name;
            if (LOWERCASE_PATTERN.matcher(columnName).matches()) {
                columnName = Util.camelToUpper(columnName);
            }
            if (columnName.equals("VALUE")) {
                columnName = "PROPERTY_VALUE";
            }
            result.headerList.add(columnName);
        }
        return result;
    }

    private static <T> String toString(List<T> list) {
        StringBuilder buf = new StringBuilder();
        int k = -1;
        for (T t : list) {
            if (++k > 0) {
                buf.append(", ");
            }
            buf.append(t);
        }
        return buf.toString();
    }

    public static Enumeration.ResponseMimeType chooseResponseMimeType(String accept) {
        for (String s : accept.split(",")) {
            Enumeration.ResponseMimeType mimeType;
            int semicolon = (s = s.trim()).indexOf(";");
            if (semicolon >= 0) {
                s = s.substring(0, semicolon);
            }
            if ((mimeType = Enumeration.ResponseMimeType.MAP.get(s)) == null) continue;
            return mimeType;
        }
        return null;
    }

    public static boolean shouldEmitInvisibleMembers(XmlaRequest request) {
        String value = request.getProperties().get(PropertyDefinition.EmitInvisibleMembers.name());
        return Boolean.parseBoolean(value);
    }

    public static void generateMetamodelJavadoc() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter("C:/open/mondrian/olap4j_javadoc.java"));
        pw.println("    /**");
        String prefix = "     * ";
        for (RowsetDefinition o : RowsetDefinition.values()) {
            pw.println(prefix);
            pw.println(prefix + "<p>" + o.name() + "</p>");
            pw.println(prefix + "<ol>");
            for (RowsetDefinition.Column columnDefinition : o.columnDefinitions) {
                String type;
                String columnName = columnDefinition.name;
                if (LOWERCASE_PATTERN.matcher(columnName).matches()) {
                    columnName = Util.camelToUpper(columnName);
                }
                if (columnName.equals("VALUE")) {
                    columnName = "PROPERTY_VALUE";
                }
                switch (columnDefinition.type) {
                    case StringSometimesArray: 
                    case EnumString: 
                    case UUID: {
                        type = "String";
                        break;
                    }
                    case DateTime: {
                        type = "Timestamp";
                        break;
                    }
                    case Boolean: {
                        type = "boolean";
                        break;
                    }
                    case UnsignedLong: 
                    case Long: {
                        type = "long";
                        break;
                    }
                    case UnsignedInteger: 
                    case Integer: {
                        type = "int";
                        break;
                    }
                    default: {
                        type = columnDefinition.type.name();
                    }
                }
                String s = prefix + "<li><b>" + columnName + "</b> " + type + (columnDefinition.nullable ? " (may be <code>null</code>)" : "") + " => " + columnDefinition.description + "</li>";
                s = s.replaceAll("\n|\r|\r\n", "<br/>");
                String between = System.getProperty("line.separator") + prefix + "        ";
                pw.println(XmlaUtil.breakLines(s, 79, between));
            }
            pw.println(prefix + "</ol>");
        }
        pw.close();
    }

    private static String breakLines(String s, int lineLen, String between) {
        StringBuilder buf = new StringBuilder();
        int originalLineLen = lineLen;
        while (s.length() > 0) {
            if (s.length() > lineLen) {
                int space = s.lastIndexOf(32, lineLen);
                if (space >= 0) {
                    buf.append(s.substring(0, space));
                    buf.append(between);
                    lineLen = originalLineLen - between.length();
                    s = s.substring(space + 1);
                    continue;
                }
                space = s.indexOf(32, lineLen);
                if (space >= 0) {
                    buf.append(s.substring(0, space));
                    buf.append(between);
                    lineLen = originalLineLen - between.length();
                    s = s.substring(space + 1);
                    continue;
                }
                buf.append(s);
                s = "";
                continue;
            }
            buf.append(s);
            s = "";
        }
        return buf.toString();
    }

    static {
        XmlaUtil.initCharTable(" \t\r\n(){}[]+/*%!,?");
    }

    public static class Wildcard {
        public final String pattern;

        public Wildcard(String pattern) {
            this.pattern = pattern;
        }
    }

    public static class MetadataRowset {
        public final List<String> headerList = new ArrayList<String>();
        public final List<List<Object>> rowList = new ArrayList<List<Object>>();
    }
}

