package org.codehaus.mojo.cobertura;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on cobertura-maven-plugin.<br/> Call <pre>  mvn cobertura:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Sep 16 18:24:00 EEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:cobertura-maven-plugin:2.5-Jaspersoft", 0 );
        append( sb, "", 0 );

        append( sb, "Cobertura Maven Plugin", 0 );
        append( sb, "Cobertura plugin for maven 2. Cobertura is a free Java tool that calculates the percentage of code accessed by tests. It can be used to identify which parts of your Java program are lacking test coverage.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 10 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "cobertura:check", 0 );
            append( sb, "Check the Last Instrumentation Results.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "clean".equals( goal ) )
        {
            append( sb, "cobertura:clean", 0 );
            append( sb, "Clean up rogue files that cobertura maven plugin is tracking.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cobertura".equals( goal ) )
        {
            append( sb, "cobertura:cobertura", 0 );
            append( sb, "Launch cobertura standard lifecycle : Instrumentation, test and report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cobertura-consolidate".equals( goal ) )
        {
            append( sb, "cobertura:cobertura-consolidate", 0 );
            append( sb, "Launch cobertura consolidated lifecycle : Instrumentation, test, consolidation and report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cobertura-sonar".equals( goal ) )
        {
            append( sb, "cobertura:cobertura-sonar", 0 );
            append( sb, "Launch complete cobertura analysis (clean, Instrument, test, consolidation and report) on all modules independently.\nIt invokes the clean and cobertura:cobertura-consolidate goals on the project when maven pass on the first module.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "consolidate".equals( goal ) )
        {
            append( sb, "cobertura:consolidate", 0 );
            append( sb, "Gather cobertura coverage information through modules to create a global ser file. This global ser file is written in {agregator-module}/target/cobertura/consolidate-cobertura.ser\nMoreover, each cobertura files in each modules will be updated with coverage information from other modules. Thus, tests from other modules can participate in the coverage of others modules.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dump-datafile".equals( goal ) )
        {
            append( sb, "cobertura:dump-datafile", 0 );
            append( sb, "Cobertura Datafile Dump Mojo", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "cobertura:help", 0 );
            append( sb, "Display help information on cobertura-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0cobertura:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "instrument".equals( goal ) )
        {
            append( sb, "cobertura:instrument", 0 );
            append( sb, "Instrument the compiled classes.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "check", 2 );
                append( sb, "The Check Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "instrumentation", 2 );
                append( sb, "The Instrumentation Configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output coberura errors, avoid info messages.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "cobertura:report", 0 );
            append( sb, "Generates a Cobertura Report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataFileName (Default: target/cobertura/cobertura.ser)", 2 );
                append( sb, "The relative name of the cobertura ser file\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: UTF-8)", 2 );
                append( sb, "The encoding for the java source code files.", 3 );
                append( sb, "", 0 );

                append( sb, "format", 2 );
                append( sb, "The format of the report. (supports \'html\' or \'xml\'. defaults to \'html\')", 3 );
                append( sb, "", 0 );

                append( sb, "formats", 2 );
                append( sb, "The format of the report. (can be \'html\' and/or \'xml\'. defaults to \'html\')", 3 );
                append( sb, "", 0 );

                append( sb, "maxmem", 2 );
                append( sb, "Maximum memory to pass to JVM of Cobertura processes.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/cobertura)", 2 );
                append( sb, "The output filename for the report relative to the module.", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Only output cobertura errors, avoid info messages.", 3 );
                append( sb, "", 0 );

                append( sb, "useConsolidated (Default: false)", 2 );
                append( sb, "Use the consolidated cobertura coverage for report generation.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
