/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


package com.jaspersoft.jasperserver.remote;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import java.io.StringWriter;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/**
 *
 * @author gtoffoli
 */
public class ServicesUtils {

    private final static Log log = LogFactory.getLog(ServicesUtils.class);
    private final static String JS_PROPS_FILE="jasperserver.properties"; // No I18N
    private final static String JS_VERSION="JS_VERSION"; // No I18N

    private ApplicationContext context = null; // Used to get various messages

    public ServicesUtils(ApplicationContext context)
    {
        this.context = context;
    }

    /**
     * Convenient method to create an Operation result with a specific error code and message.
     * @param errorCode
     * @param message
     * @return
     */
    public OperationResult createOperationResult(int errorCode, String message)
    {
        OperationResult or = new OperationResult();
        or.setReturnCode(errorCode);
        or.setMessage(message);
        // this is supposed to be the server version
        or.setVersion( getVersion() );
        return or;
    }

    /**
     * convenient method to load the JasperReports Server version
     * @return the JS version
     */
    public String getVersion()
    {
        return context.getMessage(JS_VERSION, new Object[]{}, Locale.getDefault());
    }


    /**
     * Convenient method to convert a REST obejct (like OperationResult) in an XML string.
     * Not suggested for big objects.
     * @param obj
     * @return
     */
    public static String marshall(Object obj)
    {
        StringWriter sw = new StringWriter();
        Marshaller.marshal(obj, sw);
        return sw.toString();
    }
}
