package com.jaspersoft.jasperserver.rest.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class POSTTest extends RESTTest{
	
	@Before
	public void setUp() {
    	super.setUp();
    	httpReq = new HttpPost();
     }
	
	/** POST TESTS **/
    //successful creation of new folder
//	@Test 
//    public void Post200NewFolder() throws Exception 
//    {
//		//putting the first resource
//		putSampleResource(SAMPLE_FOLDER_RD, SAMPLE_FOLDER_SERVER_PATH);
//				
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(LOCAL_UPDATE_RDS+SAMPLE_FOLDER_RD)));
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_FOLDER_SERVER_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_FOLDER_SERVER_PATH);
//    }
	
	  //creation of new file resource the RD is before the binaries
	@Test 
    public void Post200CreateNewFile_V1() throws Exception 
    {
		putSampleImageFileResource(SAMPLE_IMAGE_FILE_SERVER_PATH);

		String fileRd = LOCAL_UPDATE_RDS+SAMPLE_IMAGE_FILE_RD;
		String fileBins = LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN;
    	
    	//building the body
		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
		
		//appending the file descriptor from a file 
		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor(new File(fileRd))));
		
		//appending the binaries to the request body
		FileBody bin = new FileBody(new File(fileBins));
		reqEntity.addPart(REQUEST_SAMPLE_IMAGE_PATH, bin );
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
    }
//    
//    //creation of new file resource the binaries is before the RD
//	@Test 
//    public void Put200CreateNewFile_V2() throws Exception 
//    {
//		String fileRd = LOCAL_RDS+SAMPLE_IMAGE_FILE_RD;
//		String fileBins = LOCAL_RESOURCES_LOCATION+SAMPLE_IMAGE_FILE_BIN;
//    	
//    	//building the body
//		MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
//		
//		//appending the binaries to the request body
//		FileBody bin = new FileBody(new File(fileBins));
//		reqEntity.addPart(REQUEST_PARAMENTER_RESOURCE_BIN, bin );
//		
//		//appending the file descriptor from a file 
//		reqEntity.addPart(REQUEST_PARAMENTER_RD, new StringBody(RESTTestUtils.getResourceDescriptor((new File(fileRd)))));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
//    }
//	
	@Test 
    public void Post200NewDataType() throws Exception 
    {
		putSampleResource(SAMPLE_DATA_TYPE_RD, SAMPLE_DATA_TYPE_SERVER_PATH);
		
    	//building the body
		BasicHttpEntity reqEntity = new BasicHttpEntity();
		
		//appending the file descriptor from a file 
		reqEntity.setContent(new FileInputStream(new File(LOCAL_UPDATE_RDS+SAMPLE_DATA_TYPE_RD)));
		
		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
		
		//executing the request
		httpRes = executeCall(httpReq, SAMPLE_DATA_TYPE_SERVER_PATH);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_DATA_TYPE_SERVER_PATH);
    }
	
	@Test //copies a file from /ContentFiles to /ContentFiles/JUNIT_NEW_FOLDER  
    public void Post200CopyFile() throws Exception 
    {
		putSampleFolder();
		putSampleResource(SAMPLE_DATA_TYPE_RD, SAMPLE_DATA_TYPE_SERVER_PATH);
		
    	//executing the request
		List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair(COPY_TO, SAMPLE_FOLDER_SERVER_ACTUAL_PATH+"/COPY_TO_TEST"));
    	
		httpRes = executeCall(httpReq, SAMPLE_DATA_TYPE_SERVER_PATH, qparams);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_FOLDER_SERVER_PATH);
		deleteResource(SAMPLE_DATA_TYPE_SERVER_PATH);
    }
	
	//http://localhost:8080/jasperserver/rest/resources/reports/samples?copyTo=/reports/NEW_FOLDER
	@Test //copies a file from /ContentFiles to /ContentFiles/JUNIT_NEW_FOLDER  
    public void Post200CopyFolder() throws Exception 
    {
		//putSampleFolder();
		//putSampleResource(SAMPLE_DATA_TYPE_RD, SAMPLE_DATA_TYPE_SERVER_PATH);
		
    	//executing the request
		List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair(COPY_TO, "/datasources/JUNIT"));
    	
		httpRes = executeCall(httpReq, "/resource/reports/samples", qparams);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		//deleteResource(SAMPLE_FOLDER_SERVER_PATH);
		//deleteResource(SAMPLE_DATA_TYPE_SERVER_PATH);
    }
		
		
	
	@Test 
    public void Post200MoveFile() throws Exception 
    {
		putSampleFolder();
		putSampleResource(SAMPLE_DATA_TYPE_RD, SAMPLE_DATA_TYPE_SERVER_PATH);
		
    	//executing the request
		List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair(MOVE_TO, SAMPLE_FOLDER_SERVER_ACTUAL_PATH));
    	
		httpRes = executeCall(httpReq, SAMPLE_DATA_TYPE_SERVER_PATH, qparams);
		Assert.assertTrue("basic response check did not pass", isValidResposnse());
		
		deleteResource(SAMPLE_FOLDER_SERVER_PATH);
    }
//
//	
//	@Test 
//    public void Put200InputControl() throws Exception 
//    {
//		String rdFileName = LOCAL_RDS+SAMPLE_INPUT_CONTROL_RD;
//		
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_INPUT_CONTROL_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_INPUT_CONTROL_PATH);
//    }
//	
//	@Test 
//    public void Put200JDBC() throws Exception 
//    {
//		String rdFileName = LOCAL_RDS+SAMPLE_JDBC_FILE_RD;
//		
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_JDBC_FILE_SERVER_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_JDBC_FILE_SERVER_PATH);
//    }
//	
//	@Test 
//    public void Put200ListOfValues() throws Exception 
//    {
//		String rdFileName = LOCAL_RDS+SAMPLE_LIST_OF_VALUES_RD;
//		
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_LIST_OF_VALUES_SERVER_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_LIST_OF_VALUES_SERVER_PATH);
//    }
//	
//	@Test 
//    public void Put200NewOlapMondrianCon() throws Exception 
//    {
//		String rdFileName = LOCAL_RDS+SAMPLE_OLAP_MONDRIAN_CON_RD;
//		
//    	//building the body
//		BasicHttpEntity reqEntity = new BasicHttpEntity();
//		
//		//appending the file descriptor from a file 
//		reqEntity.setContent(new FileInputStream(new File(rdFileName)));
//		
//		((HttpEntityEnclosingRequestBase)httpReq).setEntity(reqEntity);
//		
//		
//		//executing the request
//		httpRes = executeCall(httpReq, SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH);
//		Assert.assertTrue("basic response check did not pass", isValidResposnse());
//		
//		deleteResource(SAMPLE_OLAP_MONDRIAN_CON_SERVER_PATH);
//    }

}
