/*
// $Id: //open/mondrian/src/main/mondrian/calc/StringCalc.java#4 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2006-2007 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.calc;

import mondrian.olap.Evaluator;

/**
 * Compiled expression whose result is a {@link String}.
 *
 * <p>When implementing this interface, it is convenient to extend
 * {@link mondrian.calc.impl.AbstractStringCalc}, but it is not required.
 *
 * @author jhyde
 * @version $Id: //open/mondrian/src/main/mondrian/calc/StringCalc.java#4 $
 * @since Sep 26, 2005
 */
public interface StringCalc extends Calc {
    /**
     * Evaluates this expression to yield a {@link String} value.
     *
     * @param evaluator Evaluation context
     * @return evaluation result
     */
    String evaluateString(Evaluator evaluator);
}

// End StringCalc.java
