/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package mondrian.test;

import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.sql.SQLException;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;

/**
 *
 * @author swood
 */
public class ParserTest extends FoodMartTestCase {
    private static final Logger LOGGER = Logger.getLogger(ParserTest.class);
    private static final String DIRECTORY = "testsrc";
    private static final String TEST_SCHEMA_XML = "FoodMart-3.1.xml";

    Connection foodMartConnection = null;

    public ParserTest() {
        super();
    }

    public ParserTest(String name) {
        super(name);
    }

    public synchronized void clearConnection() {
        if (foodMartConnection != null) {
            try {
                foodMartConnection.getDataSource().getConnection().close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            foodMartConnection = null;
        }
    }

    public void tearDown() {
        clearConnection();
    }

    public void testBadSchema() throws Exception {
        File file = new File(DIRECTORY, TEST_SCHEMA_XML);

        assertTrue(file.exists());
        
        FileReader reader = new FileReader(file);

        Parser xmlParser = XOMUtil.createDefaultParser();

        LOGGER.debug("XOMUtil.createDefaultParser class: " + xmlParser.getClass().getName());
        
        final DOMWrapper domWrapper = xmlParser.parse(reader);

        URL catalogURL = Util.toURL(file);

        Util.PropertyList connectProperties = getTestContext().getFoodMartConnectionProperties();
        connectProperties.put("catalog", catalogURL.toString());

        Connection foodMartConnection =
            DriverManager.getConnection(
                connectProperties,
                null);

    }
}
