/*
// $Id: //open/mondrian/src/main/mondrian/calc/impl/AbstractLevelCalc.java#2 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2006-2006 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.calc.impl;

import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.type.LevelType;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.Calc;

/**
 * Abstract implementation of the {@link mondrian.calc.LevelCalc} interface.
 *
 * <p>The derived class must
 * implement the {@link #evaluateLevel(mondrian.olap.Evaluator)} method,
 * and the {@link #evaluate(mondrian.olap.Evaluator)} method will call it.
 *
 * @author jhyde
 * @version $Id: //open/mondrian/src/main/mondrian/calc/impl/AbstractLevelCalc.java#2 $
 * @since Sep 26, 2005
 */
public abstract class AbstractLevelCalc
        extends AbstractCalc
        implements LevelCalc {
    private final Calc[] calcs;

    protected AbstractLevelCalc(Exp exp, Calc[] calcs) {
        super(exp);
        this.calcs = calcs;
        assert getType() instanceof LevelType;
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluateLevel(evaluator);
    }

    public Calc[] getCalcs() {
        return calcs;
    }
}

// End AbstractLevelCalc.java
