/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.NullViewSelector;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;

public class EndState
extends State {
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;
    private Set outputAttributeNames = CollectionFactory.createLinkedSetIfPossible((int)3);

    public EndState() {
    }

    public EndState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    public boolean addOutputAttributeName(String outputAttributeName) {
        return this.outputAttributeNames.add(outputAttributeName);
    }

    public boolean addOutputAttributeNames(String[] outputAttributeNames) {
        if (outputAttributeNames == null) {
            return false;
        }
        return this.outputAttributeNames.addAll(Arrays.asList(outputAttributeNames));
    }

    public String[] getOutputAttributeNames() {
        return this.outputAttributeNames.toArray(new String[0]);
    }

    protected ViewSelection doEnter(FlowExecutionControlContext context) throws StateException {
        FlowSession activeSession = context.getFlowExecutionContext().getActiveSession();
        if (activeSession.isRoot()) {
            ViewSelection selectedView = this.viewSelector.makeSelection(context);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning ending view selection " + selectedView));
            }
            context.endActiveFlowSession(this.createSessionOutput(activeSession.getScope()));
            return selectedView;
        }
        AttributeMap sessionOutput = this.createSessionOutput(activeSession.getScope());
        context.endActiveFlowSession(sessionOutput);
        return context.signalEvent(new Event(this, this.getId(), sessionOutput));
    }

    protected AttributeMap createSessionOutput(AttributeMap scope) {
        if (this.outputAttributeNames.isEmpty()) {
            return new AttributeMap();
        }
        AttributeMap output = new AttributeMap(this.outputAttributeNames.size());
        Iterator it = this.outputAttributeNames.iterator();
        while (it.hasNext()) {
            String attributeName = (String)it.next();
            output.put(attributeName, scope.get(attributeName));
        }
        return output;
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector).append("outputAttributeNames", (Object)this.outputAttributeNames);
    }
}

