/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.FlowException;

public class FlowArtifactException
extends FlowException {
    private String artifactId;
    private Class artifactType;

    public FlowArtifactException(String artifactId, Class artifactType) {
        this(artifactId, artifactType, null, null);
    }

    public FlowArtifactException(String artifactId, Class artifactType, Throwable cause) {
        this(artifactId, artifactType, null, cause);
    }

    public FlowArtifactException(String artifactId, Class artifactType, String message) {
        this(artifactId, artifactType, message, null);
    }

    public FlowArtifactException(String artifactId, Class artifactType, String message, Throwable cause) {
        super(StringUtils.hasText((String)message) ? message : "Unable to obtain a " + ClassUtils.getShortName((Class)artifactType) + " flow artifact with id '" + artifactId + "': make sure there is a valid [" + artifactType + "] exported with this id", cause);
        this.artifactType = artifactType;
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Class getArtifactType() {
        return this.artifactType;
    }
}

