/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.ConversationLock;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.execution.repository.support.SimpleFlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ConversationRedirect;

public class FlowExecutorImpl
implements FlowExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private boolean alwaysRedirectOnPause;

    public FlowExecutorImpl(FlowLocator flowLocator) {
        this(new SimpleFlowExecutionRepositoryFactory(flowLocator));
    }

    public FlowExecutorImpl(FlowExecutionRepositoryFactory repositoryFactory) {
        Assert.notNull((Object)repositoryFactory, (String)"The repository factory is required");
        this.repositoryFactory = repositoryFactory;
    }

    public boolean isAlwaysRedirectOnPause() {
        return this.alwaysRedirectOnPause;
    }

    public void setAlwaysRedirectOnPause(boolean alwaysRedirectOnPause) {
        this.alwaysRedirectOnPause = alwaysRedirectOnPause;
    }

    public ResponseInstruction launch(String flowId, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        FlowExecution flowExecution = repository.createFlowExecution(flowId);
        ViewSelection selectedView = flowExecution.start(context);
        if (flowExecution.isActive()) {
            FlowExecutionKey flowExecutionKey = repository.generateKey(flowExecution);
            repository.putFlowExecution(flowExecutionKey, flowExecution);
            this.setCurrentViewSelection(flowExecutionKey.getConversationId(), selectedView, repository);
            if (selectedView instanceof ApplicationView && this.alwaysRedirectOnPause) {
                selectedView = new ConversationRedirect((ApplicationView)selectedView);
            }
            return new ResponseInstruction(flowExecutionKey, flowExecution, selectedView);
        }
        return new ResponseInstruction(flowExecution, selectedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInstruction signalEvent(String eventId, FlowExecutionKey flowExecutionKey, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        ConversationLock lock = repository.getLock(flowExecutionKey.getConversationId());
        lock.lock();
        try {
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            ViewSelection selectedView = flowExecution.signalEvent(eventId, context);
            if (flowExecution.isActive()) {
                flowExecutionKey = repository.generateKey(flowExecution, flowExecutionKey.getConversationId());
                repository.putFlowExecution(flowExecutionKey, flowExecution);
                this.setCurrentViewSelection(flowExecutionKey.getConversationId(), selectedView, repository);
                if (selectedView instanceof ApplicationView && this.alwaysRedirectOnPause) {
                    selectedView = new ConversationRedirect((ApplicationView)selectedView);
                }
                ResponseInstruction responseInstruction = new ResponseInstruction(flowExecutionKey, flowExecution, selectedView);
                return responseInstruction;
            }
            repository.invalidateConversation(flowExecutionKey.getConversationId());
            ResponseInstruction responseInstruction = new ResponseInstruction(flowExecution, selectedView);
            return responseInstruction;
        }
        finally {
            lock.unlock();
        }
    }

    private void setCurrentViewSelection(Serializable conversationId, ViewSelection selectedView, FlowExecutionRepository repository) {
        if (selectedView instanceof ConversationRedirect) {
            repository.setCurrentViewSelection(conversationId, ((ConversationRedirect)selectedView).getApplicationView());
        } else {
            repository.setCurrentViewSelection(conversationId, selectedView);
        }
    }

    public ResponseInstruction getCurrentResponseInstruction(Serializable conversationId, ExternalContext context) throws FlowException {
        FlowExecutionRepository repository = this.getRepository(context);
        FlowExecutionKey flowExecutionKey = repository.getCurrentFlowExecutionKey(conversationId);
        FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
        ViewSelection selectedView = repository.getCurrentViewSelection(conversationId);
        return new ResponseInstruction(flowExecutionKey, flowExecution, selectedView);
    }

    protected FlowExecutionRepository getRepository(ExternalContext context) {
        return this.repositoryFactory.getRepository(context);
    }
}

