/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.Serializable;
import org.apache.avalon.framework.ExceptionUtil;

public final class Version
implements Serializable {
    private int m_major;
    private int m_minor;
    private int m_micro;

    public static Version getVersion(String version) throws NumberFormatException, IllegalArgumentException {
        String[] levels = ExceptionUtil.splitString(version, ".");
        if (0 == levels.length || 3 < levels.length) {
            throw new IllegalArgumentException("Malformed version string " + version);
        }
        int major = Integer.parseInt(levels[0]);
        int minor = 0;
        if (1 < levels.length) {
            minor = Integer.parseInt(levels[1]);
        }
        int micro = 0;
        if (2 < levels.length) {
            micro = Integer.parseInt(levels[2]);
        }
        return new Version(major, minor, micro);
    }

    public Version(int major, int minor, int micro) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public int getMicro() {
        return this.m_micro;
    }

    public boolean equals(Version other) {
        if (this.m_major != other.m_major) {
            return false;
        }
        if (this.m_minor != other.m_minor) {
            return false;
        }
        return this.m_micro == other.m_micro;
    }

    public boolean equals(Object other) {
        if (other instanceof Version) {
            return this.equals((Version)other);
        }
        return false;
    }

    public boolean complies(Version other) {
        if (this.m_major != other.m_major) {
            return false;
        }
        if (this.m_minor < other.m_minor) {
            return false;
        }
        return this.m_minor != other.m_minor || this.m_micro >= other.m_micro;
    }

    public String toString() {
        return this.m_major + "." + this.m_minor + "." + this.m_micro;
    }
}

