/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibBandCombineOpImage
extends PointOpImage {
    private double[] cmat = new double[9];
    private double[] offset = new double[3];
    private boolean isOffsetNonZero = false;

    public MlibBandCombineOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, imageLayout, map, true);
        int n = dArray.length;
        if (this.getSampleModel().getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)renderedImage.getSampleModel();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray[0] == nArray[1] && nArray[0] == nArray[2] && nArray2[0] > nArray2[2]) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 8 - 3 * n2;
                int n4 = 0;
                while (n4 < 3) {
                    this.cmat[n3--] = dArray[n2][n4];
                    ++n4;
                }
                this.offset[2 - n2] = dArray[n2][3];
                if (this.offset[n2] != 0.0) {
                    this.isOffsetNonZero = true;
                }
                ++n2;
            }
        } else {
            int n5 = 0;
            while (n5 < 3) {
                int n6 = 3 * n5;
                int n7 = 0;
                while (n7 < 3) {
                    this.cmat[n6++] = dArray[n5][n7];
                    ++n7;
                }
                this.offset[n5] = dArray[n5][3];
                if (this.offset[n5] != 0.0) {
                    this.isOffsetNonZero = true;
                }
                ++n5;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])this.cmat, (double[])this.offset);
                    } else {
                        Image.ColorConvert1((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])this.cmat);
                    }
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.cmat, (double[])this.offset);
                    } else {
                        Image.ColorConvert1_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.cmat);
                    }
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(string + JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

