/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public final class PerspectiveTransform
implements Cloneable,
Serializable {
    private static final double PERSPECTIVE_DIVIDE_EPSILON = 1.0E-10;
    double m00;
    double m01;
    double m02;
    double m10;
    double m11;
    double m12;
    double m20;
    double m21;
    double m22;

    public PerspectiveTransform() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
    }

    public PerspectiveTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
    }

    public PerspectiveTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public PerspectiveTransform(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
        this.m20 = fArray[6];
        this.m21 = fArray[7];
        this.m22 = fArray[8];
    }

    public PerspectiveTransform(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = fArray[0][0];
        this.m01 = fArray[0][1];
        this.m02 = fArray[0][2];
        this.m10 = fArray[1][0];
        this.m11 = fArray[1][1];
        this.m12 = fArray[1][2];
        this.m20 = fArray[2][0];
        this.m21 = fArray[2][1];
        this.m22 = fArray[2][2];
    }

    public PerspectiveTransform(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public PerspectiveTransform(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = dArray[0][0];
        this.m01 = dArray[0][1];
        this.m02 = dArray[0][2];
        this.m10 = dArray[1][0];
        this.m11 = dArray[1][1];
        this.m12 = dArray[1][2];
        this.m20 = dArray[2][0];
        this.m21 = dArray[2][1];
        this.m22 = dArray[2][2];
    }

    public PerspectiveTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = affineTransform.getScaleX();
        this.m01 = affineTransform.getShearX();
        this.m02 = affineTransform.getTranslateX();
        this.m10 = affineTransform.getShearY();
        this.m11 = affineTransform.getScaleY();
        this.m12 = affineTransform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    private final void makeAdjoint() {
        double d = this.m11 * this.m22 - this.m12 * this.m21;
        double d2 = this.m12 * this.m20 - this.m10 * this.m22;
        double d3 = this.m10 * this.m21 - this.m11 * this.m20;
        double d4 = this.m02 * this.m21 - this.m01 * this.m22;
        double d5 = this.m00 * this.m22 - this.m02 * this.m20;
        double d6 = this.m01 * this.m20 - this.m00 * this.m21;
        double d7 = this.m01 * this.m12 - this.m02 * this.m11;
        double d8 = this.m02 * this.m10 - this.m00 * this.m12;
        double d9 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = d;
        this.m01 = d4;
        this.m02 = d7;
        this.m10 = d2;
        this.m11 = d5;
        this.m12 = d8;
        this.m20 = d3;
        this.m21 = d6;
        this.m22 = d9;
    }

    private final void normalize() {
        double d = 1.0 / this.m22;
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 = 1.0;
    }

    private static final void getSquareToQuad(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, PerspectiveTransform perspectiveTransform) {
        double d9 = d - d3 + d5 - d7;
        double d10 = d2 - d4 + d6 - d8;
        perspectiveTransform.m22 = 1.0;
        if (d9 == 0.0 && d10 == 0.0) {
            perspectiveTransform.m00 = d3 - d;
            perspectiveTransform.m01 = d5 - d3;
            perspectiveTransform.m02 = d;
            perspectiveTransform.m10 = d4 - d2;
            perspectiveTransform.m11 = d6 - d4;
            perspectiveTransform.m12 = d2;
            perspectiveTransform.m20 = 0.0;
            perspectiveTransform.m21 = 0.0;
        } else {
            double d11 = d3 - d5;
            double d12 = d4 - d6;
            double d13 = d7 - d5;
            double d14 = d8 - d6;
            double d15 = 1.0 / (d11 * d14 - d13 * d12);
            perspectiveTransform.m20 = (d9 * d14 - d13 * d10) * d15;
            perspectiveTransform.m21 = (d11 * d10 - d9 * d12) * d15;
            perspectiveTransform.m00 = d3 - d + perspectiveTransform.m20 * d3;
            perspectiveTransform.m01 = d7 - d + perspectiveTransform.m21 * d7;
            perspectiveTransform.m02 = d;
            perspectiveTransform.m10 = d4 - d2 + perspectiveTransform.m20 * d4;
            perspectiveTransform.m11 = d8 - d2 + perspectiveTransform.m21 * d8;
            perspectiveTransform.m12 = d2;
        }
    }

    public static PerspectiveTransform getSquareToQuad(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        PerspectiveTransform.getSquareToQuad(d, d2, d3, d4, d5, d6, d7, d8, perspectiveTransform);
        return perspectiveTransform;
    }

    public static PerspectiveTransform getSquareToQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return PerspectiveTransform.getSquareToQuad((double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8);
    }

    public static PerspectiveTransform getQuadToSquare(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        PerspectiveTransform.getSquareToQuad(d, d2, d3, d4, d5, d6, d7, d8, perspectiveTransform);
        perspectiveTransform.makeAdjoint();
        return perspectiveTransform;
    }

    public static PerspectiveTransform getQuadToSquare(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return PerspectiveTransform.getQuadToSquare((double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8);
    }

    public static PerspectiveTransform getQuadToQuad(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.getQuadToSquare(d, d2, d3, d4, d5, d6, d7, d8);
        PerspectiveTransform perspectiveTransform2 = PerspectiveTransform.getSquareToQuad(d9, d10, d11, d12, d13, d14, d15, d16);
        perspectiveTransform.concatenate(perspectiveTransform2);
        return perspectiveTransform;
    }

    public static PerspectiveTransform getQuadToQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        return PerspectiveTransform.getQuadToQuad((double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8, (double)f9, (double)f10, (double)f11, (double)f12, (double)f13, (double)f14, (double)f15, (double)f16);
    }

    public double getDeterminant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public double[] getMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
        }
        return dArray;
    }

    public double[][] getMatrix(double[][] dArray) {
        if (dArray == null) {
            dArray = new double[3][3];
        }
        dArray[0][0] = this.m00;
        dArray[0][1] = this.m01;
        dArray[0][2] = this.m02;
        dArray[1][0] = this.m10;
        dArray[1][1] = this.m11;
        dArray[1][2] = this.m12;
        dArray[2][0] = this.m20;
        dArray[2][1] = this.m21;
        dArray[2][2] = this.m22;
        return dArray;
    }

    public void translate(double d, double d2) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToTranslation(d, d2);
        this.concatenate(perspectiveTransform);
    }

    public void rotate(double d) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToRotation(d);
        this.concatenate(perspectiveTransform);
    }

    public void rotate(double d, double d2, double d3) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToRotation(d, d2, d3);
        this.concatenate(perspectiveTransform);
    }

    public void scale(double d, double d2) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToScale(d, d2);
        this.concatenate(perspectiveTransform);
    }

    public void shear(double d, double d2) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToShear(d, d2);
        this.concatenate(perspectiveTransform);
    }

    public void setToIdentity() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m21 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
    }

    public void setToTranslation(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = d;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = d2;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToRotation(double d) {
        this.m00 = Math.cos(d);
        this.m01 = -Math.sin(d);
        this.m02 = 0.0;
        this.m10 = -this.m01;
        this.m11 = this.m00;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToRotation(double d, double d2, double d3) {
        this.setToRotation(d);
        double d4 = this.m10;
        double d5 = 1.0 - this.m00;
        this.m02 = d2 * d5 + d3 * d4;
        this.m12 = d3 * d5 - d2 * d4;
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToShear(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = d;
        this.m02 = 0.0;
        this.m10 = d2;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = affineTransform.getScaleX();
        this.m01 = affineTransform.getShearX();
        this.m02 = affineTransform.getTranslateX();
        this.m10 = affineTransform.getShearY();
        this.m11 = affineTransform.getScaleY();
        this.m12 = affineTransform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setTransform(PerspectiveTransform perspectiveTransform) {
        if (perspectiveTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = perspectiveTransform.m00;
        this.m01 = perspectiveTransform.m01;
        this.m02 = perspectiveTransform.m02;
        this.m10 = perspectiveTransform.m10;
        this.m11 = perspectiveTransform.m11;
        this.m12 = perspectiveTransform.m12;
        this.m20 = perspectiveTransform.m20;
        this.m21 = perspectiveTransform.m21;
        this.m22 = perspectiveTransform.m22;
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f4;
        this.m02 = f7;
        this.m10 = f2;
        this.m11 = f5;
        this.m12 = f8;
        this.m20 = f3;
        this.m21 = f6;
        this.m22 = f9;
    }

    public void setTransform(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.m00 = dArray[0][0];
        this.m01 = dArray[0][1];
        this.m02 = dArray[0][2];
        this.m10 = dArray[1][0];
        this.m11 = dArray[1][1];
        this.m12 = dArray[1][2];
        this.m20 = dArray[2][0];
        this.m21 = dArray[2][1];
        this.m22 = dArray[2][2];
    }

    public void concatenate(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getShearX();
        double d3 = affineTransform.getTranslateX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getScaleY();
        double d6 = affineTransform.getTranslateY();
        double d7 = this.m00 * d + this.m10 * d2 + this.m20 * d3;
        double d8 = this.m01 * d + this.m11 * d2 + this.m21 * d3;
        double d9 = this.m02 * d + this.m12 * d2 + this.m22 * d3;
        double d10 = this.m00 * d4 + this.m10 * d5 + this.m20 * d6;
        double d11 = this.m01 * d4 + this.m11 * d5 + this.m21 * d6;
        double d12 = this.m02 * d4 + this.m12 * d5 + this.m22 * d6;
        double d13 = this.m20;
        double d14 = this.m21;
        double d15 = this.m22;
        this.m00 = d7;
        this.m10 = d10;
        this.m20 = d13;
        this.m01 = d8;
        this.m11 = d11;
        this.m21 = d14;
        this.m02 = d9;
        this.m12 = d12;
        this.m22 = d15;
    }

    public void concatenate(PerspectiveTransform perspectiveTransform) {
        if (perspectiveTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = this.m00 * perspectiveTransform.m00 + this.m10 * perspectiveTransform.m01 + this.m20 * perspectiveTransform.m02;
        double d2 = this.m00 * perspectiveTransform.m10 + this.m10 * perspectiveTransform.m11 + this.m20 * perspectiveTransform.m12;
        double d3 = this.m00 * perspectiveTransform.m20 + this.m10 * perspectiveTransform.m21 + this.m20 * perspectiveTransform.m22;
        double d4 = this.m01 * perspectiveTransform.m00 + this.m11 * perspectiveTransform.m01 + this.m21 * perspectiveTransform.m02;
        double d5 = this.m01 * perspectiveTransform.m10 + this.m11 * perspectiveTransform.m11 + this.m21 * perspectiveTransform.m12;
        double d6 = this.m01 * perspectiveTransform.m20 + this.m11 * perspectiveTransform.m21 + this.m21 * perspectiveTransform.m22;
        double d7 = this.m02 * perspectiveTransform.m00 + this.m12 * perspectiveTransform.m01 + this.m22 * perspectiveTransform.m02;
        double d8 = this.m02 * perspectiveTransform.m10 + this.m12 * perspectiveTransform.m11 + this.m22 * perspectiveTransform.m12;
        double d9 = this.m02 * perspectiveTransform.m20 + this.m12 * perspectiveTransform.m21 + this.m22 * perspectiveTransform.m22;
        this.m00 = d;
        this.m10 = d2;
        this.m20 = d3;
        this.m01 = d4;
        this.m11 = d5;
        this.m21 = d6;
        this.m02 = d7;
        this.m12 = d8;
        this.m22 = d9;
    }

    public void preConcatenate(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getShearX();
        double d3 = affineTransform.getTranslateX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getScaleY();
        double d6 = affineTransform.getTranslateY();
        double d7 = d * this.m00 + d4 * this.m01;
        double d8 = d2 * this.m00 + d5 * this.m01;
        double d9 = d3 * this.m00 + d6 * this.m01 + this.m02;
        double d10 = d * this.m10 + d4 * this.m11;
        double d11 = d2 * this.m10 + d5 * this.m11;
        double d12 = d3 * this.m10 + d6 * this.m11 + this.m12;
        double d13 = d * this.m20 + d4 * this.m21;
        double d14 = d2 * this.m20 + d5 * this.m21;
        double d15 = d3 * this.m20 + d6 * this.m21 + this.m22;
        this.m00 = d7;
        this.m10 = d10;
        this.m20 = d13;
        this.m01 = d8;
        this.m11 = d11;
        this.m21 = d14;
        this.m02 = d9;
        this.m12 = d12;
        this.m22 = d15;
    }

    public void preConcatenate(PerspectiveTransform perspectiveTransform) {
        if (perspectiveTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = perspectiveTransform.m00 * this.m00 + perspectiveTransform.m10 * this.m01 + perspectiveTransform.m20 * this.m02;
        double d2 = perspectiveTransform.m00 * this.m10 + perspectiveTransform.m10 * this.m11 + perspectiveTransform.m20 * this.m12;
        double d3 = perspectiveTransform.m00 * this.m20 + perspectiveTransform.m10 * this.m21 + perspectiveTransform.m20 * this.m22;
        double d4 = perspectiveTransform.m01 * this.m00 + perspectiveTransform.m11 * this.m01 + perspectiveTransform.m21 * this.m02;
        double d5 = perspectiveTransform.m01 * this.m10 + perspectiveTransform.m11 * this.m11 + perspectiveTransform.m21 * this.m12;
        double d6 = perspectiveTransform.m01 * this.m20 + perspectiveTransform.m11 * this.m21 + perspectiveTransform.m21 * this.m22;
        double d7 = perspectiveTransform.m02 * this.m00 + perspectiveTransform.m12 * this.m01 + perspectiveTransform.m22 * this.m02;
        double d8 = perspectiveTransform.m02 * this.m10 + perspectiveTransform.m12 * this.m11 + perspectiveTransform.m22 * this.m12;
        double d9 = perspectiveTransform.m02 * this.m20 + perspectiveTransform.m12 * this.m21 + perspectiveTransform.m22 * this.m22;
        this.m00 = d;
        this.m10 = d2;
        this.m20 = d3;
        this.m01 = d4;
        this.m11 = d5;
        this.m21 = d6;
        this.m02 = d7;
        this.m12 = d8;
        this.m22 = d9;
    }

    public PerspectiveTransform createInverse() throws NoninvertibleTransformException, CloneNotSupportedException {
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)this.clone();
        perspectiveTransform.makeAdjoint();
        if (Math.abs(perspectiveTransform.m22) < 1.0E-10) {
            throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform0"));
        }
        perspectiveTransform.normalize();
        return perspectiveTransform;
    }

    public PerspectiveTransform createAdjoint() throws CloneNotSupportedException {
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)this.clone();
        perspectiveTransform.makeAdjoint();
        return perspectiveTransform;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.m20 * d + this.m21 * d2 + this.m22;
        point2D2.setLocation((this.m00 * d + this.m01 * d2 + this.m02) / d3, (this.m10 * d + this.m11 * d2 + this.m12) / d3);
        return point2D2;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Point2D[] var1_1, int var2_2, Point2D[] var3_3, int var4_4, int var5_5) {
        if (var1_1 != null && var3_3 != null) ** GOTO lbl11
        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1[var2_2++];
            if ((var7_7 = var3_3[var4_4++]) == null) {
                var7_7 = var6_6 instanceof Point2D.Double != false ? new Point2D.Double() : new Point2D.Float();
                var3_3[var4_4 - 1] = var7_7;
            }
            if ((var12_10 = this.m20 * (var8_8 = var6_6.getX()) + this.m21 * (var10_9 = var6_6.getY()) + this.m22) == 0.0) {
                var7_7.setLocation(var8_8, var10_9);
                continue;
            }
            var7_7.setLocation((this.m00 * var8_8 + this.m01 * var10_9 + this.m02) / var12_10, (this.m10 * var8_8 + this.m11 * var10_9 + this.m12) / var12_10);
lbl11:
            // 3 sources

            ** while (var5_5-- > 0)
        }
lbl12:
        // 1 sources

    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (fArray2 == null) {
            fArray2 = new float[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            float f;
            float f2;
            double d;
            if ((d = this.m20 * (double)(f2 = fArray[n++]) + this.m21 * (double)(f = fArray[n++]) + this.m22) == 0.0) {
                fArray2[n2++] = f2;
                fArray2[n2++] = f;
                continue;
            }
            fArray2[n2++] = (float)((this.m00 * (double)f2 + this.m01 * (double)f + this.m02) / d);
            fArray2[n2++] = (float)((this.m10 * (double)f2 + this.m11 * (double)f + this.m12) / d);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (dArray2 == null) {
            dArray2 = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d;
            double d2;
            double d3;
            if ((d3 = this.m20 * (d2 = dArray[n++]) + this.m21 * (d = dArray[n++]) + this.m22) == 0.0) {
                dArray2[n2++] = d2;
                dArray2[n2++] = d;
                continue;
            }
            dArray2[n2++] = (this.m00 * d2 + this.m01 * d + this.m02) / d3;
            dArray2[n2++] = (this.m10 * d2 + this.m11 * d + this.m12) / d3;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (dArray == null) {
            dArray = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            float f;
            float f2;
            double d;
            if ((d = this.m20 * (double)(f2 = fArray[n++]) + this.m21 * (double)(f = fArray[n++]) + this.m22) == 0.0) {
                dArray[n2++] = f2;
                dArray[n2++] = f;
                continue;
            }
            dArray[n2++] = (this.m00 * (double)f2 + this.m01 * (double)f + this.m02) / d;
            dArray[n2++] = (this.m10 * (double)f2 + this.m11 * (double)f + this.m12) / d;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (fArray == null) {
            fArray = new float[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d;
            double d2;
            double d3;
            if ((d3 = this.m20 * (d2 = dArray[n++]) + this.m21 * (d = dArray[n++]) + this.m22) == 0.0) {
                fArray[n2++] = (float)d2;
                fArray[n2++] = (float)d;
                continue;
            }
            fArray[n2++] = (float)((this.m00 * d2 + this.m01 * d + this.m02) / d3);
            fArray[n2++] = (float)((this.m10 * d2 + this.m11 * d + this.m12) / d3);
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        double d;
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = (this.m11 * this.m22 - this.m12 * this.m21) * d2 + (this.m02 * this.m21 - this.m01 * this.m22) * d3 + (this.m01 * this.m12 - this.m02 * this.m11);
        double d5 = (this.m12 * this.m20 - this.m10 * this.m22) * d2 + (this.m00 * this.m22 - this.m02 * this.m20) * d3 + (this.m02 * this.m10 - this.m00 * this.m12);
        double d6 = d = (this.m10 * this.m21 - this.m11 * this.m20) * d2 + (this.m01 * this.m20 - this.m00 * this.m21) * d3 + (this.m00 * this.m11 - this.m01 * this.m10);
        if (d < 0.0) {
            d6 = -d;
        }
        if (d6 < 1.0E-10) {
            throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform1"));
        }
        point2D2.setLocation(d4 / d, d5 / d);
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (dArray2 == null) {
            dArray2 = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d;
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = (this.m11 * this.m22 - this.m12 * this.m21) * d2 + (this.m02 * this.m21 - this.m01 * this.m22) * d3 + (this.m01 * this.m12 - this.m02 * this.m11);
            double d5 = (this.m12 * this.m20 - this.m10 * this.m22) * d2 + (this.m00 * this.m22 - this.m02 * this.m20) * d3 + (this.m02 * this.m10 - this.m00 * this.m12);
            double d6 = d = (this.m10 * this.m21 - this.m11 * this.m20) * d2 + (this.m01 * this.m20 - this.m00 * this.m21) * d3 + (this.m00 * this.m11 - this.m01 * this.m10);
            if (d < 0.0) {
                d6 = -d;
            }
            if (d6 < 1.0E-10) {
                throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform1"));
            }
            dArray2[n2++] = d4 / d;
            dArray2[n2++] = d5 / d;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Perspective transform matrix\n");
        stringBuffer.append(this.m00);
        stringBuffer.append("\t");
        stringBuffer.append(this.m01);
        stringBuffer.append("\t");
        stringBuffer.append(this.m02);
        stringBuffer.append("\n");
        stringBuffer.append(this.m10);
        stringBuffer.append("\t");
        stringBuffer.append(this.m11);
        stringBuffer.append("\t");
        stringBuffer.append(this.m12);
        stringBuffer.append("\n");
        stringBuffer.append(this.m20);
        stringBuffer.append("\t");
        stringBuffer.append(this.m21);
        stringBuffer.append("\t");
        stringBuffer.append(this.m22);
        stringBuffer.append("\n");
        return new String(stringBuffer);
    }

    public boolean isIdentity() {
        return this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 != 0.0 && this.m00 / this.m22 == 1.0 && this.m11 / this.m22 == 1.0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerspectiveTransform)) {
            return false;
        }
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)object;
        return this.m00 == perspectiveTransform.m00 && this.m10 == perspectiveTransform.m10 && this.m20 == perspectiveTransform.m20 && this.m01 == perspectiveTransform.m01 && this.m11 == perspectiveTransform.m11 && this.m21 == perspectiveTransform.m21 && this.m02 == perspectiveTransform.m02 && this.m12 == perspectiveTransform.m12 && this.m22 == perspectiveTransform.m22;
    }
}

