/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.NodeHandlerSupport;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.selection.DefaultSelectionModel;
import com.tonbeller.wcf.selection.SelectionChangeListener;
import com.tonbeller.wcf.tree.TreeComponent;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Element;

public class TreeHandler
extends NodeHandlerSupport {
    TreeComponent tree;
    FormComponent formComp;

    public void initialize(RequestContext context, XmlComponent xmlComp, Element element) throws Exception {
        String width;
        String border;
        super.initialize(context, xmlComp, element);
        this.formComp = (FormComponent)xmlComp;
        String ref = XoplonCtrl.getModelReference(element);
        Object bean = this.formComp.getBean();
        TreeModel tm = (TreeModel)PropertyUtils.getProperty((Object)bean, (String)ref);
        this.tree = new TreeComponent(element.getAttribute("id"), this.formComp, tm);
        DefaultSelectionModel dsm = new DefaultSelectionModel();
        String selmode = element.getAttribute("selmode");
        if ("href".equals(selmode)) {
            dsm.setMode(3);
        } else if ("single".equals(selmode)) {
            dsm.setMode(1);
        } else if ("multi".equals(selmode)) {
            dsm.setMode(2);
        } else if ("button".equals(selmode)) {
            dsm.setMode(4);
        } else {
            dsm.setMode(0);
        }
        this.tree.setSelectionModel(dsm);
        if (tm instanceof SelectionChangeListener) {
            dsm.addSelectionListener((SelectionChangeListener)((Object)tm));
        }
        if ((border = element.getAttribute("border")).length() > 0) {
            this.tree.setBorder(border);
        }
        if ((width = element.getAttribute("width")).length() > 0) {
            this.tree.setWidth(width);
        }
        this.tree.setRenderId(element.getAttribute("id"));
        this.tree.addFormListener(this.formComp);
        this.formComp.addFormListener(this.tree);
        this.tree.initialize(context);
    }

    public void destroy(HttpSession session) throws Exception {
        this.tree.destroy(session);
        super.destroy(session);
    }

    public void render(RequestContext context) throws Exception {
        super.render(context);
        Element parent = this.getElement();
        DomUtils.removeChildElements(parent);
        Element child = this.tree.render(context, parent.getOwnerDocument());
        parent.appendChild(child);
    }

    public FormComponent getFormComp() {
        return this.formComp;
    }

    public TreeComponent getTree() {
        return this.tree;
    }
}

