/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class PortletSessionTracker
implements HttpSessionBindingListener,
Serializable {
    private static PortletSessionTracker _instance = new PortletSessionTracker();
    private transient Map _sessions = new HashMap();

    public static void add(HttpSession session) {
        _instance._add(session);
    }

    public static HttpSessionBindingListener getInstance() {
        return _instance;
    }

    public static void invalidate(String sessionId) {
        _instance._invalidate(sessionId);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        PortletSessionTracker.invalidate(event.getSession().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _add(HttpSession session) {
        String sessionId = session.getId();
        Map map = this._sessions;
        synchronized (map) {
            HashSet<HttpSession> portletSessions = (HashSet<HttpSession>)this._sessions.get(sessionId);
            if (portletSessions == null) {
                portletSessions = new HashSet<HttpSession>();
                this._sessions.put(sessionId, portletSessions);
            }
            portletSessions.add(session);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _invalidate(String sessionId) {
        Map map = this._sessions;
        synchronized (map) {
            block6: {
                Set portletSessions = (Set)this._sessions.get(sessionId);
                if (portletSessions == null) break block6;
                Iterator itr = portletSessions.iterator();
                while (itr.hasNext()) {
                    HttpSession session = (HttpSession)itr.next();
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this._sessions.remove(sessionId);
            return;
        }
    }

    private PortletSessionTracker() {
    }
}

