/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerDetector {
    public static final String GERONIMO_CLASS = "/org/apache/geronimo/system/main/Daemon.class";
    public static final String GLASSFISH_CLASS = "/com/sun/appserv/ClassLoaderUtil.class";
    public static final String JBOSS_CLASS = "/org/jboss/Main.class";
    public static final String JETTY_CLASS = "/org/mortbay/jetty/Server.class";
    public static final String JONAS_CLASS = "/org/objectweb/jonas/server/Server.class";
    public static final String OC4J_CLASS = "oracle.oc4j.util.ClassUtils";
    public static final String ORION_CLASS = "/com/evermind/server/ApplicationServer.class";
    public static final String PRAMATI_CLASS = "/com/pramati/Server.class";
    public static final String RESIN_CLASS = "/com/caucho/server/resin/Resin.class";
    public static final String REXIP_CLASS = "/com/tcc/Main.class";
    public static final String SUN7_CLASS = "/com/iplanet/ias/tools/cli/IasAdminMain.class";
    public static final String SUN8_CLASS = "/com/sun/enterprise/cli/framework/CLIMain.class";
    public static final String TOMCAT_CLASS = "/org/apache/catalina/startup/Bootstrap.class";
    public static final String WEBLOGIC_CLASS = "/weblogic/Server.class";
    public static final String WEBSPHERE_CLASS = "/com/ibm/websphere/product/VersionInfo.class";
    private static Log _log;
    private static ServerDetector _instance;
    private String _serverId;
    private Boolean _geronimo;
    private Boolean _glassfish;
    private Boolean _jBoss;
    private Boolean _jetty;
    private Boolean _jonas;
    private Boolean _oc4j;
    private Boolean _orion;
    private Boolean _pramati;
    private Boolean _resin;
    private Boolean _rexIP;
    private Boolean _sun7;
    private Boolean _sun8;
    private Boolean _tomcat;
    private Boolean _webLogic;
    private Boolean _webSphere;
    static /* synthetic */ Class class$com$liferay$portal$kernel$util$ServerDetector;

    public static String getServerId() {
        ServerDetector sd = _instance;
        if (sd._serverId == null) {
            if (ServerDetector.isGeronimo()) {
                sd._serverId = "geronimo";
            } else if (ServerDetector.isGlassfish()) {
                sd._serverId = "glassfish";
            } else if (ServerDetector.isJBoss()) {
                sd._serverId = "jboss";
            } else if (ServerDetector.isJOnAS()) {
                sd._serverId = "jonas";
            } else if (ServerDetector.isOC4J()) {
                sd._serverId = "oc4j";
            } else if (ServerDetector.isOrion()) {
                sd._serverId = "orion";
            } else if (ServerDetector.isPramati()) {
                sd._serverId = "pramati";
            } else if (ServerDetector.isResin()) {
                sd._serverId = "resin";
            } else if (ServerDetector.isRexIP()) {
                sd._serverId = "rexip";
            } else if (ServerDetector.isSun7()) {
                sd._serverId = "sun7";
            } else if (ServerDetector.isSun8()) {
                sd._serverId = "sun8";
            } else if (ServerDetector.isWebLogic()) {
                sd._serverId = "weblogic";
            } else if (ServerDetector.isWebSphere()) {
                sd._serverId = "websphere";
            }
            if (ServerDetector.isJetty()) {
                sd._serverId = sd._serverId == null ? "jetty" : sd._serverId + "-jetty";
            } else if (ServerDetector.isTomcat()) {
                sd._serverId = sd._serverId == null ? "tomcat" : sd._serverId + "-tomcat";
            }
            if (_log.isInfoEnabled()) {
                _log.info("Detected server " + sd._serverId);
            }
            if (sd._serverId == null) {
                throw new RuntimeException("Server is not supported");
            }
        }
        return sd._serverId;
    }

    public static boolean isGeronimo() {
        ServerDetector sd = _instance;
        if (sd._geronimo == null) {
            sd._geronimo = ServerDetector._detect(GERONIMO_CLASS);
        }
        return sd._geronimo;
    }

    public static boolean isGlassfish() {
        ServerDetector sd = _instance;
        if (sd._glassfish == null) {
            sd._glassfish = ServerDetector._detect(GLASSFISH_CLASS);
        }
        return sd._glassfish;
    }

    public static boolean isJBoss() {
        ServerDetector sd = _instance;
        if (sd._jBoss == null) {
            sd._jBoss = ServerDetector._detect(JBOSS_CLASS);
        }
        return sd._jBoss;
    }

    public static boolean isJetty() {
        ServerDetector sd = _instance;
        if (sd._jetty == null) {
            sd._jetty = ServerDetector._detect(JETTY_CLASS);
        }
        return sd._jetty;
    }

    public static boolean isJOnAS() {
        ServerDetector sd = _instance;
        if (sd._jonas == null) {
            sd._jonas = ServerDetector._detect(JONAS_CLASS);
        }
        return sd._jonas;
    }

    public static boolean isOC4J() {
        ServerDetector sd = _instance;
        if (sd._oc4j == null) {
            sd._oc4j = ServerDetector._detect(OC4J_CLASS);
        }
        return sd._oc4j;
    }

    public static boolean isOrion() {
        ServerDetector sd = _instance;
        if (sd._orion == null) {
            sd._orion = ServerDetector._detect(ORION_CLASS);
        }
        return sd._orion;
    }

    public static boolean isPramati() {
        ServerDetector sd = _instance;
        if (sd._pramati == null) {
            sd._pramati = ServerDetector._detect(PRAMATI_CLASS);
        }
        return sd._pramati;
    }

    public static boolean isResin() {
        ServerDetector sd = _instance;
        if (sd._resin == null) {
            sd._resin = ServerDetector._detect(RESIN_CLASS);
        }
        return sd._resin;
    }

    public static boolean isRexIP() {
        ServerDetector sd = _instance;
        if (sd._rexIP == null) {
            sd._rexIP = ServerDetector._detect(REXIP_CLASS);
        }
        return sd._rexIP;
    }

    public static boolean isSun() {
        return ServerDetector.isSun7() || ServerDetector.isSun8();
    }

    public static boolean isSun7() {
        ServerDetector sd = _instance;
        if (sd._sun7 == null) {
            sd._sun7 = ServerDetector._detect(SUN7_CLASS);
        }
        return sd._sun7;
    }

    public static boolean isSun8() {
        ServerDetector sd = _instance;
        if (sd._sun8 == null) {
            sd._sun8 = ServerDetector._detect(SUN8_CLASS);
        }
        return sd._sun8;
    }

    public static boolean isTomcat() {
        ServerDetector sd = _instance;
        if (sd._tomcat == null) {
            sd._tomcat = ServerDetector._detect(TOMCAT_CLASS);
        }
        return sd._tomcat;
    }

    public static boolean isWebLogic() {
        ServerDetector sd = _instance;
        if (sd._webLogic == null) {
            sd._webLogic = ServerDetector._detect(WEBLOGIC_CLASS);
        }
        return sd._webLogic;
    }

    public static boolean isWebSphere() {
        ServerDetector sd = _instance;
        if (sd._webSphere == null) {
            sd._webSphere = ServerDetector._detect(WEBSPHERE_CLASS);
        }
        return sd._webSphere;
    }

    private static final Boolean _detect(String className) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(className);
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException cnfe) {
            ServerDetector sd = _instance;
            Class<?> c = sd.getClass();
            if (c.getResource(className) != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ServerDetector() {
    }

    static {
        Class clazz = class$com$liferay$portal$kernel$util$ServerDetector;
        if (clazz == null) {
            clazz = class$com$liferay$portal$kernel$util$ServerDetector = ServerDetector.class("[Lcom.liferay.portal.kernel.util.ServerDetector;", false);
        }
        _log = LogFactoryUtil.getLog(clazz);
        _instance = new ServerDetector();
    }
}

