/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.format;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.format.DateHandler;
import com.tonbeller.wcf.format.DoubleHandler;
import com.tonbeller.wcf.format.DoubleNaNHandler;
import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.IntegerHandler;
import com.tonbeller.wcf.format.Pattern;
import com.tonbeller.wcf.format.RegexHandler;
import com.tonbeller.wcf.format.RequiredStringHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public abstract class FormatHandlerSupport
implements FormatHandler {
    protected String name;
    protected String pattern;
    protected String errorMessage;
    protected ArrayList patterns = new ArrayList();
    protected Resources resources = Resources.instance();
    protected Locale locale;

    public void addPattern(Pattern p) {
        this.patterns.add(p);
    }

    protected String findPattern(String userPattern) {
        if (userPattern != null && userPattern.length() > 0) {
            return userPattern;
        }
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern p = (Pattern)it.next();
            if (!this.locale.getLanguage().equals(p.getLanguage())) continue;
            return p.getPattern();
        }
        return this.getPattern();
    }

    protected String getErrorMessage(String userInput) {
        if (this.resources != null) {
            String errorMessage = null;
            if (this instanceof RequiredStringHandler || userInput.length() == 0) {
                errorMessage = this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.noValue");
            } else if (this instanceof IntegerHandler) {
                if (this.getName().equals("int")) {
                    errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.invalidInteger");
                } else if (this.getName().equals("posint")) {
                    errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.notPositiveInteger");
                }
            } else if (this instanceof DateHandler) {
                if (this.getName().equals("date")) {
                    errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.invalidDate");
                } else if (this.getName().equals("dateTime")) {
                    errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.invalidDateTime");
                }
            } else if (this instanceof DoubleHandler || this instanceof DoubleNaNHandler) {
                errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.invalidDecimal");
            } else if (this instanceof RegexHandler) {
                errorMessage = userInput + this.getMessageFromResourceBundle("wcf.FormatHandlerSupport.error.invalidEmailAddr");
            }
            return errorMessage;
        }
        String errorMessage = null;
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern p = (Pattern)it.next();
            if (!this.locale.getLanguage().equals(p.getLanguage())) continue;
            errorMessage = p.getErrorMessage();
        }
        if (errorMessage == null) {
            errorMessage = this.getErrorMessage();
        }
        if (errorMessage == null) {
            return userInput;
        }
        return MessageFormat.format(errorMessage, userInput);
    }

    private String getMessageFromResourceBundle(String key) {
        if (this.resources.getResourceBundle() != null) {
            return this.resources.getResourceBundle().getMessage(key, null, this.getLocale());
        }
        return this.resources.getString(key);
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

