/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.pagestack;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.pagestack.Page;
import com.tonbeller.wcf.pagestack.PageStack;
import com.tonbeller.wcf.token.RequestToken;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class PageStackTag
extends LoopTagSupport {
    String page;
    String pageId;
    String title;
    String key;
    boolean clear;
    String bundle;
    Iterator iter;

    protected void prepare() throws JspTagException {
        String s = this.makeTitle();
        PageStack stack = PageStack.instance(this.pageContext.getSession());
        if (this.clear) {
            stack.clear();
        }
        if (this.page != null && s != null) {
            String path = this.addContextPath(this.page);
            Page curPg = new Page(this.pageId, path, this.page, s);
            curPg.setRequestToken(RequestToken.instance(this.pageContext.getSession()));
            stack.setCurrentPage(curPg);
        }
        this.iter = stack.iterator();
    }

    private String addContextPath(String path) {
        if (path.startsWith("/")) {
            HttpServletRequest hsr = (HttpServletRequest)this.pageContext.getRequest();
            path = hsr.getContextPath() + path;
        }
        return path;
    }

    protected Object next() throws JspTagException {
        return this.iter.next();
    }

    protected boolean hasNext() throws JspTagException {
        return this.iter.hasNext();
    }

    private String makeTitle() {
        if (this.key == null) {
            return this.eval(this.title);
        }
        if (this.bundle != null) {
            RequestContext context = RequestContext.instance();
            Resources res = Resources.instance((Class)PageStackTag.class);
            if (res == null) {
                res = context.getResources(this.bundle);
            }
            return res.getOptionalString(this.key, this.key);
        }
        return LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)this.key);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    private String eval(String el) {
        if (ExprUtils.isExpression(el)) {
            return String.valueOf(ExprUtils.getModelReference(this.pageContext, el));
        }
        return el;
    }
}

