/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentTag;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormDocument;
import com.tonbeller.wcf.table.TableComponent;
import com.tonbeller.wcf.table.TablePropertiesFormComponent;
import com.tonbeller.wcf.utils.I18nReplacer;
import com.tonbeller.wcf.utils.ResourceLocator;
import com.tonbeller.wcf.utils.XmlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class TablePropertiesFormTag
extends ComponentTag {
    private String xmlUri;
    private String table;
    private boolean bookmarkable = false;
    private boolean closable = true;
    private static Logger logger = Logger.getLogger((Class)TablePropertiesFormTag.class);

    public Component createComponent(RequestContext context) throws JspException {
        try {
            Locale locale = Resources.instance().getLocaleContextHolderLocale();
            if (locale == null) {
                locale = context.getLocale();
            }
            URL url = ResourceLocator.getResource(context.getServletContext(), locale, this.xmlUri);
            Document doc = XmlUtils.parse(url);
            I18nReplacer replacer = I18nReplacer.instance(Resources.instance(((Object)((Object)this)).getClass()));
            if (replacer != null) {
                replacer.replaceAll(doc);
            } else {
                FormDocument.replaceI18n(context, doc, null);
            }
            TableComponent tc = (TableComponent)context.getModelReference(this.table);
            TablePropertiesFormComponent fc = new TablePropertiesFormComponent(this.id, null, doc, tc);
            fc.setCloseable(this.closable);
            fc.setBookmarkable(this.bookmarkable);
            return fc;
        }
        catch (MalformedURLException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    public void setBookmarkable(boolean b) {
        this.bookmarkable = b;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setXmlUri(String string) {
        this.xmlUri = string;
    }

    public void setClosable(boolean b) {
        this.closable = b;
    }
}

