/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.DoubleProperty;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.StringProperty;
import org.eigenbase.util.property.TriggerableProperties;

public class MondrianProperties
extends TriggerableProperties {
    private final PropertySource propertySource;
    private int populateCount;
    private static final Logger LOGGER = Logger.getLogger(MondrianProperties.class);
    private static MondrianProperties instance;
    private static final String mondrianDotProperties = "mondrian.properties";
    public final transient IntegerProperty QueryLimit = new IntegerProperty((Properties)((Object)this), "mondrian.query.limit", 40);
    public final transient StringProperty JdbcDrivers = new StringProperty((Properties)((Object)this), "mondrian.jdbcDrivers", "sun.jdbc.odbc.JdbcOdbcDriver,org.hsqldb.jdbcDriver,oracle.jdbc.OracleDriver,com.mysql.jdbc.Driver");
    public final transient IntegerProperty ResultLimit = new IntegerProperty((Properties)((Object)this), "mondrian.result.limit", 0);
    public final transient StringProperty TestName = new StringProperty((Properties)((Object)this), "mondrian.test.Name", null);
    public final transient StringProperty TestClass = new StringProperty((Properties)((Object)this), "mondrian.test.Class", null);
    public final transient StringProperty TestConnectString = new StringProperty((Properties)((Object)this), "mondrian.test.connectString", null);
    public final transient StringProperty FoodmartJdbcURL = new StringProperty((Properties)((Object)this), "mondrian.foodmart.jdbcURL", "jdbc:odbc:MondrianFoodMart");
    public final transient StringProperty TestJdbcURL = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcURL", null);
    public final transient StringProperty TestJdbcUser = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcUser", null);
    public final transient StringProperty TestJdbcPassword = new StringProperty((Properties)((Object)this), "mondrian.test.jdbcPassword", null);
    public final transient IntegerProperty LargeDimensionThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.LargeDimensionThreshold", 100);
    public final transient IntegerProperty SparseSegmentCountThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.SparseSegmentValueThreshold", 1000);
    public final transient DoubleProperty SparseSegmentDensityThreshold = new DoubleProperty((Properties)((Object)this), "mondrian.rolap.SparseSegmentDensityThreshold", 0.5);
    public final transient StringProperty QueryFilePattern = new StringProperty((Properties)((Object)this), "mondrian.test.QueryFilePattern", null);
    public final transient StringProperty QueryFileDirectory = new StringProperty((Properties)((Object)this), "mondrian.test.QueryFileDirectory", null);
    public final transient IntegerProperty Iterations = new IntegerProperty((Properties)((Object)this), "mondrian.test.Iterations", 1);
    public final transient IntegerProperty VUsers = new IntegerProperty((Properties)((Object)this), "mondrian.test.VUsers", 1);
    public final transient IntegerProperty TimeLimit = new IntegerProperty((Properties)((Object)this), "mondrian.test.TimeLimit", 0);
    public final transient BooleanProperty Warmup = new BooleanProperty((Properties)((Object)this), "mondrian.test.Warmup", false);
    public final transient StringProperty CatalogURL = new StringProperty((Properties)((Object)this), "mondrian.catalogURL", null);
    public final transient BooleanProperty EnableCacheHitCounters = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.agg.enableCacheHitCounters", false);
    public final transient StringProperty WarnIfNoPatternForDialect = new StringProperty((Properties)((Object)this), "mondrian.test.WarnIfNoPatternForDialect", "NONE");
    public final transient BooleanProperty UseAggregates = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.Use", false);
    public final transient BooleanProperty ReadAggregates = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.Read", false);
    public final transient BooleanProperty ChooseAggregateByVolume = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.ChooseByVolume", false);
    public final transient StringProperty AggregateRules = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.rules", "/DefaultRules.xml");
    public final transient StringProperty AggregateRuleTag = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.rule.tag", "default");
    public final transient BooleanProperty GenerateAggregateSql = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.generateSql", false);
    public final transient BooleanProperty DisableCaching = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.star.disableCaching", false);
    public final transient BooleanProperty EnableTriggers = new BooleanProperty((Properties)((Object)this), "mondrian.olap.triggers.enable", true);
    public final transient BooleanProperty GenerateFormattedSql = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.generate.formatted.sql", false);
    public final transient BooleanProperty EnableNonEmptyOnAllAxis = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.nonempty", false);
    public final transient BooleanProperty ExpandNonNative = new BooleanProperty((Properties)((Object)this), "mondrian.native.ExpandNonNative", false);
    public final transient BooleanProperty CompareSiblingsByOrderKey = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.compareSiblingsByOrderKey", false);
    public final transient BooleanProperty EnableExpCache = new BooleanProperty((Properties)((Object)this), "mondrian.expCache.enable", true);
    public final transient IntegerProperty TestExpDependencies = new IntegerProperty((Properties)((Object)this), "mondrian.test.ExpDependencies", 0);
    public final transient IntegerProperty TestSeed = new IntegerProperty((Properties)((Object)this), "mondrian.test.random.seed", 1234);
    public final transient StringProperty LocalePropFile = new StringProperty((Properties)((Object)this), "mondrian.rolap.localePropFile", null);
    public final transient BooleanProperty EnableNativeCrossJoin = new BooleanProperty((Properties)((Object)this), "mondrian.native.crossjoin.enable", true);
    public final transient BooleanProperty EnableNativeTopCount = new BooleanProperty((Properties)((Object)this), "mondrian.native.topcount.enable", true);
    public final transient BooleanProperty EnableNativeFilter = new BooleanProperty((Properties)((Object)this), "mondrian.native.filter.enable", true);
    public final transient BooleanProperty EnableNativeNonEmpty = new BooleanProperty((Properties)((Object)this), "mondrian.native.nonempty.enable", true);
    public final transient StringProperty AlertNativeEvaluationUnsupported = new StringProperty((Properties)((Object)this), "mondrian.native.unsupported.alert", "OFF");
    public final transient BooleanProperty EnableTotalCount = new BooleanProperty((Properties)((Object)this), "mondrian.xmla.drillthroughTotalCount.enable", true);
    public final transient BooleanProperty CaseSensitive = new BooleanProperty((Properties)((Object)this), "mondrian.olap.case.sensitive", false);
    public final transient IntegerProperty MaxRows = new IntegerProperty((Properties)((Object)this), "mondrian.xmla.drillthroughMaxRows", 1000);
    public final transient IntegerProperty MaxConstraints = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.maxConstraints", 1000);
    public final transient BooleanProperty OptimizePredicates = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.aggregates.optimizePredicates", true);
    public final transient IntegerProperty MaxEvalDepth = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.evaluate.MaxEvalDepth", 10);
    public final transient StringProperty JdbcFactoryClass = new StringProperty((Properties)((Object)this), "mondrian.rolap.aggregates.jdbcFactoryClass", null);
    public final transient IntegerProperty QueryTimeout = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.queryTimeout", 0);
    public final transient BooleanProperty IgnoreInvalidMembers = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.ignoreInvalidMembers", false);
    public final transient BooleanProperty IgnoreInvalidMembersDuringQuery = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.ignoreInvalidMembersDuringQuery", false);
    public final transient StringProperty NullMemberRepresentation = new StringProperty((Properties)((Object)this), "mondrian.olap.NullMemberRepresentation", "#null");
    public final transient IntegerProperty IterationLimit = new IntegerProperty((Properties)((Object)this), "mondrian.rolap.iterationLimit", 0);
    public final transient BooleanProperty MemoryMonitor = new BooleanProperty((Properties)((Object)this), "mondrian.util.memoryMonitor.enable", false);
    public final transient IntegerProperty MemoryMonitorThreshold = new IntegerProperty((Properties)((Object)this), "mondrian.util.memoryMonitor.percentage.threshold", 90);
    public final transient StringProperty MemoryMonitorClass = new StringProperty((Properties)((Object)this), "mondrian.util.MemoryMonitor.class", null);
    public final transient StringProperty ExpCompilerClass = new StringProperty((Properties)((Object)this), "mondrian.calc.ExpCompiler.class", null);
    public final transient IntegerProperty CrossJoinOptimizerSize = new IntegerProperty((Properties)((Object)this), "mondrian.olap.fun.crossjoin.optimizer.size", 0);
    public final transient BooleanProperty NullDenominatorProducesNull = new BooleanProperty((Properties)((Object)this), "mondrian.olap.NullDenominatorProducesNull", false);
    public final transient BooleanProperty EnableGroupingSets = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.groupingsets.enable", false);
    public final transient BooleanProperty IgnoreMeasureForNonJoiningDimension = new BooleanProperty((Properties)((Object)this), "mondrian.olap.agg.IgnoreMeasureForNonJoiningDimension", false);
    public final transient BooleanProperty NeedDimensionPrefix = new BooleanProperty((Properties)((Object)this), "mondrian.olap.elements.NeedDimensionPrefix", false);
    public final transient BooleanProperty EnableRolapCubeMemberCache = new BooleanProperty((Properties)((Object)this), "mondrian.rolap.EnableRolapCubeMemberCache", true);
    public final transient StringProperty SolveOrderMode = new StringProperty((Properties)((Object)this), "mondrian.rolap.SolveOrderMode", SolveOrderModeEnum.ABSOLUTE.name());

    public static synchronized MondrianProperties instance() {
        if (instance == null) {
            instance = new MondrianProperties();
            instance.populate();
        }
        return instance;
    }

    public MondrianProperties() {
        this.propertySource = new FilePropertySource(new File(mondrianDotProperties));
    }

    public boolean triggersAreEnabled() {
        return this.EnableTriggers.get();
    }

    public void populate() {
        this.loadIfStale(this.propertySource);
        URL url = null;
        File file = new File(mondrianDotProperties);
        if (file.exists() && file.isFile()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn((Object)("Mondrian: file '" + file.getAbsolutePath() + "' could not be loaded"), (Throwable)e);
            }
        } else {
            url = MondrianProperties.class.getClassLoader().getResource(mondrianDotProperties);
        }
        if (url != null) {
            this.load(new UrlPropertySource(url));
        } else {
            LOGGER.warn((Object)("mondrian.properties can't be found under '" + new File(".").getAbsolutePath() + "' or classloader"));
        }
        int count = 0;
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (!key.startsWith("mondrian.")) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("populate: key=" + key + ", value=" + value));
            }
            super.setProperty(key, value);
            ++count;
        }
        if (this.populateCount++ == 0) {
            LOGGER.info((Object)("Mondrian: loaded " + count + " system properties"));
        }
    }

    private void loadIfStale(PropertySource source) {
        if (source.isStale()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Mondrian: loading " + source.getDescription()));
            }
            this.load(source);
        }
    }

    private void load(PropertySource source) {
        try {
            this.load(source.openStream());
            if (this.populateCount == 0) {
                LOGGER.info((Object)("Mondrian: properties loaded from '" + source.getDescription() + "'"));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Mondrian: error while loading properties from '" + source.getDescription() + "' (" + e + ")"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SolveOrderModeEnum {
        ABSOLUTE,
        SCOPED;

    }

    static class UrlPropertySource
    implements PropertySource {
        private final URL url;
        private long lastModified;

        UrlPropertySource(URL url) {
            this.url = url;
        }

        private URLConnection getConnection() {
            try {
                return this.url.openConnection();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        public InputStream openStream() {
            try {
                URLConnection connection = this.getConnection();
                this.lastModified = connection.getLastModified();
                return connection.getInputStream();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        public boolean isStale() {
            long lastModified = this.getConnection().getLastModified();
            return lastModified > this.lastModified;
        }

        public String getDescription() {
            return this.url.toExternalForm();
        }
    }

    static class FilePropertySource
    implements PropertySource {
        private final File file;
        private long lastModified;

        FilePropertySource(File file) {
            this.file = file;
            this.lastModified = 0L;
        }

        public InputStream openStream() {
            try {
                this.lastModified = this.file.lastModified();
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.file + "'");
            }
        }

        public boolean isStale() {
            return this.file.exists() && this.file.lastModified() > this.lastModified;
        }

        public String getDescription() {
            return "file=" + this.file.getAbsolutePath() + " (exists=" + this.file.exists() + ")";
        }
    }

    public static interface PropertySource {
        public InputStream openStream();

        public boolean isStale();

        public String getDescription();
    }
}

