/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapEvaluator;

public class AggregateFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver resolver = new ReflectiveMultiResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}, AggregateFunDef.class);

    public AggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AggregateCalc(call, listCalc, calc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AggregateCalc
    extends AbstractDoubleCalc {
        private final ListCalc listCalc;
        private final Calc calc;

        public AggregateCalc(Exp exp, ListCalc listCalc, Calc calc) {
            super(exp, new Calc[]{listCalc, calc});
            this.listCalc = listCalc;
            this.calc = calc;
        }

        @Override
        public double evaluateDouble(Evaluator evaluator) {
            Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
            if (aggregator == null) {
                throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
            }
            Aggregator rollup = aggregator.getRollup();
            if (rollup == null) {
                throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
            }
            List list = AbstractAggregateFunDef.evaluateCurrentList(this.listCalc, evaluator);
            if (aggregator == RolapAggregator.DistinctCount) {
                if (list.size() == 0) {
                    return 1.2345E-8;
                }
                if (list.get(0) instanceof Member) {
                    list = AggregateCalc.makeTupleList(list);
                }
                RolapEvaluator rolapEvaluator = null;
                if (evaluator instanceof RolapEvaluator) {
                    rolapEvaluator = (RolapEvaluator)evaluator;
                }
                if (rolapEvaluator == null || !rolapEvaluator.getDialect().supportsUnlimitedValueList()) {
                    list = AggregateCalc.optimizeChildren(list, evaluator.getSchemaReader(), evaluator.getMeasureCube());
                    this.checkIfAggregationSizeIsTooLarge(list);
                }
                Evaluator evaluator2 = evaluator.pushAggregation(list);
                Object o = evaluator2.evaluateCurrent();
                Number number = (Number)o;
                return GenericCalc.numberToDouble(number);
            }
            return (Double)rollup.aggregate(evaluator.push(), list, this.calc);
        }

        public static List<Member[]> makeTupleList(List<Member> list) {
            ArrayList<Member[]> tupleList = new ArrayList<Member[]>(list.size());
            for (Member member : list) {
                tupleList.add(new Member[]{member});
            }
            return tupleList;
        }

        private void checkIfAggregationSizeIsTooLarge(List list) {
            if (list.size() > MondrianProperties.instance().MaxConstraints.get()) {
                throw FunUtil.newEvalException(null, "Distinct Count aggregation is not supported over a large list");
            }
        }

        @Override
        public Calc[] getCalcs() {
            return new Calc[]{this.listCalc, this.calc};
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            if (dimension.isMeasures()) {
                return true;
            }
            return AggregateCalc.anyDependsButFirst(this.getCalcs(), dimension);
        }

        public static List optimizeChildren(List<Member[]> tuples, SchemaReader reader, Cube baseCubeForMeasure) {
            Map[] membersOccurancesInTuple = AggregateCalc.membersVersusOccurancesInTuple(tuples);
            int tupleLength = tuples.get(0).length;
            Set[] sets = new HashSet[tupleLength];
            boolean optimized = false;
            for (int i = 0; i < tupleLength; ++i) {
                if (!AggregateCalc.areOccurancesEqual(membersOccurancesInTuple[i].values())) continue;
                Set members = membersOccurancesInTuple[i].keySet();
                int originalSize = members.size();
                sets[i] = AggregateCalc.optimizeMemberSet(new HashSet<Member>(members), reader, baseCubeForMeasure);
                if (sets[i].size() == originalSize) continue;
                optimized = true;
            }
            if (optimized) {
                if (sets.length == 1) {
                    return new ArrayList(sets[0]);
                }
                return AggregateCalc.crossProd(sets);
            }
            return tuples;
        }

        public static Map[] membersVersusOccurancesInTuple(List<Member[]> tuples) {
            int tupleLength = tuples.get(0).length;
            Map[] counters = new Map[tupleLength];
            for (int i = 0; i < counters.length; ++i) {
                counters[i] = new HashMap();
            }
            for (Member[] tuple : tuples) {
                for (int i = 0; i < tuple.length; ++i) {
                    Map map = counters[i];
                    Member member = tuple[i];
                    if (map.containsKey(member)) {
                        Integer count = (Integer)map.get(member);
                        count = count + 1;
                        map.put(member, count);
                        continue;
                    }
                    map.put(member, 1);
                }
            }
            return counters;
        }

        public static boolean areOccurancesEqual(Collection<Integer> collection) {
            return new HashSet<Integer>(collection).size() == 1;
        }

        private static Set optimizeMemberSet(Set<Member> members, SchemaReader reader, Cube baseCubeForMeasure) {
            HashSet<Member> membersToBeOptimized = new HashSet<Member>();
            Set<Member> optimizedMembers = new HashSet<Member>();
            while (members.size() > 0) {
                boolean didOptimize;
                Iterator<Member> iterator = members.iterator();
                Member first = iterator.next();
                if (first.isAll()) {
                    optimizedMembers.clear();
                    optimizedMembers.add(first);
                    return optimizedMembers;
                }
                membersToBeOptimized.add(first);
                iterator.remove();
                Member firstParentMember = first.getParentMember();
                while (iterator.hasNext()) {
                    Member current = iterator.next();
                    if (current.isAll()) {
                        optimizedMembers.clear();
                        optimizedMembers.add(current);
                        return optimizedMembers;
                    }
                    Member currentParentMember = current.getParentMember();
                    if ((firstParentMember != null || currentParentMember != null) && (firstParentMember == null || !firstParentMember.equals(currentParentMember))) continue;
                    membersToBeOptimized.add(current);
                    iterator.remove();
                }
                int childCountOfParent = -1;
                if (firstParentMember != null) {
                    childCountOfParent = AggregateCalc.getChildCount(firstParentMember, reader);
                }
                if (childCountOfParent != -1 && membersToBeOptimized.size() == childCountOfParent && AggregateCalc.canOptimize(firstParentMember, baseCubeForMeasure)) {
                    optimizedMembers.add(firstParentMember);
                    didOptimize = true;
                } else {
                    optimizedMembers.addAll(membersToBeOptimized);
                    didOptimize = false;
                }
                membersToBeOptimized.clear();
                if (members.size() != 0 || !didOptimize) continue;
                Set<Member> temp = members;
                members = optimizedMembers;
                optimizedMembers = temp;
            }
            return optimizedMembers;
        }

        private static boolean canOptimize(Member parentMember, Cube baseCube) {
            return AggregateCalc.dimensionJoinsToBaseCube(parentMember.getDimension(), baseCube) || !parentMember.isAll();
        }

        private static List<Member[]> crossProd(Set[] sets) {
            ArrayList firstList = new ArrayList(sets[0]);
            ArrayList secondList = new ArrayList(sets[1]);
            List tupleList = CrossJoinFunDef.crossJoin(firstList, secondList);
            for (int i = 2; i < sets.length; ++i) {
                Set set = sets[i];
                tupleList = CrossJoinFunDef.crossJoin(tupleList, new ArrayList(set));
            }
            return tupleList;
        }

        private static boolean dimensionJoinsToBaseCube(Dimension dimension, Cube baseCube) {
            HashSet<Dimension> dimensions = new HashSet<Dimension>();
            dimensions.add(dimension);
            return baseCube.nonJoiningDimensions(dimensions).size() == 0;
        }

        private static int getChildCount(Member parentMember, SchemaReader reader) {
            int childrenCountFromCache = reader.getChildrenCountFromCache(parentMember);
            if (childrenCountFromCache != -1) {
                return childrenCountFromCache;
            }
            return reader.getMemberChildren(parentMember).length;
        }
    }
}

