/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ResultStyle;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.ArrayHolder;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapHierarchy;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunUtil
extends Util {
    static final String[] emptyStringArray = new String[0];
    private static final boolean debug = false;
    public static final NullMember NullMember = new NullMember();
    public static final double DoubleNull = 1.2345E-8;
    public static final double DoubleEmpty = -1.2345E-8;
    public static final int IntegerNull = -2147483647;
    public static final boolean BooleanNull = false;
    private static final String EMPTY_STRING = "";

    public static RuntimeException newEvalException(FunDef funDef, String message) {
        Util.discard((Object)funDef);
        return new MondrianEvaluationException(message);
    }

    public static RuntimeException newEvalException(Throwable throwable) {
        return new MondrianEvaluationException(throwable.getClass().getName() + ": " + throwable.getMessage());
    }

    public static boolean isMemberType(Calc calc) {
        Type type = calc.getType();
        return type instanceof SetType && ((SetType)type).getElementType() instanceof MemberType;
    }

    public static void checkIterListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case ITERABLE: 
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    public static void checkListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    static String getLiteralArg(ResolvedFunCall call, int i, String defaultValue, String[] allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        StringBuilder sb = new StringBuilder(64);
        for (int j = 0; j < allowedValues.length; ++j) {
            String allowedValue = allowedValues[j];
            if (allowedValue.equalsIgnoreCase(s)) {
                return allowedValue;
            }
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(allowedValue);
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + sb + "}");
    }

    static <E extends Enum<E>> E getLiteralArg(ResolvedFunCall call, int i, E defaultValue, Class<E> allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(s)) continue;
            return (E)e;
        }
        StringBuilder buf = new StringBuilder(64);
        int k = 0;
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(e.name());
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + buf + "}");
    }

    static void checkCompatible(Exp left, Exp right, FunDef funDef) {
        Type rightType;
        Type leftType = TypeUtil.stripSetType(left.getType());
        if (!TypeUtil.isUnionCompatible(leftType, rightType = TypeUtil.stripSetType(right.getType()))) {
            throw FunUtil.newEvalException(funDef, "Expressions must have the same hierarchy");
        }
    }

    static boolean checkFlag(int value, int mask, boolean strict) {
        return strict ? (value & mask) == mask : (value & mask) != 0;
    }

    static void addUnique(List left, List right, Set set) {
        assert (left != null);
        assert (right != null);
        if (right.isEmpty()) {
            return;
        }
        int n = right.size();
        for (int i = 0; i < n; ++i) {
            Object o;
            Object p = o = right.get(i);
            if (o instanceof Object[]) {
                p = new ArrayHolder<Object>((Object[])o);
            }
            if (!set.add(p)) continue;
            left.add(o);
        }
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Hierarchy hierarchy) {
        Level[] levels = schemaReader.getHierarchyLevels(hierarchy);
        for (int i = 0; i < levels.length; ++i) {
            FunUtil.addMembers(schemaReader, members, levels[i]);
        }
        return members;
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Level level) {
        Object[] levelMembers = schemaReader.getLevelMembers(level, true);
        FunUtil.addAll(members, (Object[])levelMembers);
        return members;
    }

    static void removeCalculatedMembers(List<Member> memberList) {
        for (int i = 0; i < memberList.size(); ++i) {
            Member member = memberList.get(i);
            if (!member.isCalculated()) continue;
            memberList.remove(i);
            --i;
        }
    }

    static boolean isAncestorOf(Member m0, Member m1, boolean strict) {
        if (strict) {
            if (m1 == null) {
                return false;
            }
            m1 = m1.getParentMember();
        }
        while (m1 != null) {
            if (m1.equals(m0)) {
                return true;
            }
            m1 = m1.getParentMember();
        }
        return false;
    }

    static Map<Member, Object> evaluateMembers(Evaluator evaluator, Calc exp, List<Member> members, boolean parentsToo) {
        evaluator = evaluator.push();
        assert (exp.getType() instanceof ScalarType);
        HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
        int count = members.size();
        for (int i = 0; i < count; ++i) {
            Member member = members.get(i);
            do {
                evaluator.setContext(member);
                Object result = exp.evaluate(evaluator);
                if (result == null) {
                    result = Util.nullValue;
                }
                mapMemberToValue.put(member, result);
            } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
        }
        return mapMemberToValue;
    }

    static Map<Object, Object> evaluateTuples(Evaluator evaluator, Calc exp, List<Member[]> members) {
        evaluator = evaluator.push();
        assert (exp.getType() instanceof ScalarType);
        HashMap<Object, Object> mapMemberToValue = new HashMap<Object, Object>();
        int count = members.size();
        for (int i = 0; i < count; ++i) {
            Member[] tuples = members.get(i);
            evaluator.setContext(tuples);
            Object result = exp.evaluate(evaluator);
            if (result == null) {
                result = Util.nullValue;
            }
            mapMemberToValue.put(new ArrayHolder<Member>(tuples), result);
        }
        return mapMemberToValue;
    }

    static Map<Member, Object> evaluateMembers(Evaluator evaluator, List<Member> members, boolean parentsToo) {
        HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
        int count = members.size();
        for (int i = 0; i < count; ++i) {
            Member member = members.get(i);
            do {
                evaluator.setContext(member);
                Object result = evaluator.evaluateCurrent();
                mapMemberToValue.put(member, result);
            } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
        }
        return mapMemberToValue;
    }

    static void sortMembers(Evaluator evaluator, List<Member> members, Calc exp, boolean desc, boolean brk) {
        if (members.isEmpty()) {
            return;
        }
        Member first = members.get(0);
        if (first instanceof Member) {
            boolean parentsToo = !brk;
            Map<Member, Object> mapMemberToValue = FunUtil.evaluateMembers(evaluator, exp, members, parentsToo);
            Comparator<Member> comparator = brk ? new BreakMemberComparator(mapMemberToValue, desc).wrap() : new HierarchicalMemberComparator(mapMemberToValue, desc).wrap();
            Collections.sort(members, comparator);
        } else {
            Comparator<Member[]> comparator;
            Util.assertTrue(first instanceof Member[]);
            int arity = ((Member[])first).length;
            if (brk) {
                comparator = new BreakArrayComparator(evaluator, exp, arity).wrap();
                if (desc) {
                    comparator = new ReverseComparator<Member[]>(comparator);
                }
            } else {
                comparator = new HierarchicalArrayComparator(evaluator, exp, arity, desc).wrap();
            }
            Collections.sort(members, comparator);
        }
    }

    public static void sortTuples(Evaluator evaluator, List<Member[]> tuples, Calc exp, boolean desc, boolean brk, int arity) {
        Comparator<Member[]> comparator;
        if (tuples.isEmpty()) {
            return;
        }
        if (brk) {
            comparator = new BreakArrayComparator(evaluator, exp, arity).wrap();
            if (desc) {
                comparator = new ReverseComparator<Member[]>(comparator);
            }
        } else {
            comparator = new HierarchicalArrayComparator(evaluator, exp, arity, desc).wrap();
        }
        Collections.sort(tuples, comparator);
    }

    public static void hierarchize(List members, boolean post) {
        if (members.isEmpty()) {
            return;
        }
        Object first = members.get(0);
        if (first instanceof Member) {
            List memberList = members;
            HierarchizeComparator comparator = new HierarchizeComparator(post);
            Collections.sort(memberList, comparator);
        } else {
            assert (first instanceof Member[]);
            int arity = ((Member[])first).length;
            List tupleList = members;
            Comparator<Member[]> comparator = new HierarchizeArrayComparator(arity, post).wrap();
            Collections.sort(tupleList, comparator);
        }
    }

    static int sign(double d) {
        return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
    }

    public static int compareValues(double d1, double d2) {
        if (Double.isNaN(d1)) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(d2)) {
            if (d1 == Double.POSITIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d1 == d2) {
            return 0;
        }
        if (d1 == 1.2345E-8) {
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d2 == 1.2345E-8) {
            if (d1 == Double.NEGATIVE_INFINITY) {
                return -1;
            }
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static int compareValues(int i, int j) {
        return i == j ? 0 : (i < j ? -1 : 1);
    }

    public static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 instanceof RuntimeException || value1 instanceof RuntimeException) {
            return 0;
        }
        if (value0 == Util.nullValue) {
            return -1;
        }
        if (value1 == Util.nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            return ((String)value0).compareTo((String)value1);
        }
        if (value0 instanceof Number) {
            return FunUtil.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    static void toPercent(List members, Map mapMemberToValue, boolean isMember) {
        int i;
        double total = 0.0;
        int memberCount = members.size();
        for (i = 0; i < memberCount; ++i) {
            Object o;
            Object v = o = isMember ? mapMemberToValue.get(members.get(i)) : mapMemberToValue.get(new ArrayHolder<Member>((Member[])members.get(i)));
            if (!(o instanceof Number)) continue;
            total += ((Number)o).doubleValue();
        }
        for (i = 0; i < memberCount; ++i) {
            Object o;
            Object mo = members.get(i);
            Object v = o = isMember ? mapMemberToValue.get(mo) : mapMemberToValue.get(new ArrayHolder<Member>((Member[])mo));
            if (!(o instanceof Number)) continue;
            double d = ((Number)o).doubleValue();
            if (isMember) {
                mapMemberToValue.put(mo, d / total * 100.0);
                continue;
            }
            mapMemberToValue.put(new ArrayHolder<Member>((Member[])mo), d / total * 100.0);
        }
    }

    public static Syntax decodeSyntacticType(String flags) {
        char c = flags.charAt(0);
        switch (c) {
            case 'p': {
                return Syntax.Property;
            }
            case 'f': {
                return Syntax.Function;
            }
            case 'm': {
                return Syntax.Method;
            }
            case 'i': {
                return Syntax.Infix;
            }
            case 'P': {
                return Syntax.Prefix;
            }
            case 'Q': {
                return Syntax.Postfix;
            }
            case 'I': {
                return Syntax.Internal;
            }
        }
        throw FunUtil.newInternal("unknown syntax code '" + c + "' in string '" + flags + "'");
    }

    public static int decodeReturnCategory(String flags) {
        int returnCategory = FunUtil.decodeCategory(flags, 1);
        if ((returnCategory & 0x1F) != returnCategory) {
            throw FunUtil.newInternal("bad return code flag in flags '" + flags + "'");
        }
        return returnCategory;
    }

    public static int decodeCategory(String flags, int offset) {
        char c = flags.charAt(offset);
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'b': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'N': {
                return 71;
            }
            case 'n': {
                return 7;
            }
            case 'I': {
                return 79;
            }
            case 'i': {
                return 15;
            }
            case 'x': {
                return 8;
            }
            case '#': {
                return 73;
            }
            case 'S': {
                return 9;
            }
            case 't': {
                return 10;
            }
            case 'v': {
                return 13;
            }
            case 'y': {
                return 11;
            }
            case 'U': {
                return 16;
            }
            case 'e': {
                return 17;
            }
            case 'D': {
                return 18;
            }
        }
        throw FunUtil.newInternal("unknown type code '" + c + "' in string '" + flags + "'");
    }

    public static int[] decodeParameterCategories(String flags) {
        int[] parameterCategories = new int[flags.length() - 2];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = FunUtil.decodeCategory(flags, i + 2);
        }
        return parameterCategories;
    }

    public static void sortValuesDesc(Object[] values) {
        Arrays.sort(values, DescendingValueComparator.instance);
    }

    public static int searchValuesDesc(Object[] values, Object value) {
        return Arrays.binarySearch(values, value, DescendingValueComparator.instance);
    }

    static double percentile(Evaluator evaluator, List members, Calc exp, double p) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        int length = asArray.length;
        if (p == 0.5) {
            if ((length & 1) == 1) {
                return asArray[length >> 1];
            }
            return (asArray[(length >> 1) - 1] + asArray[length >> 1]) / 2.0;
        }
        if (p <= 0.0) {
            return asArray[0];
        }
        if (p >= 1.0) {
            return asArray[length - 1];
        }
        double jD = Math.floor((double)length * p);
        int j = (int)jD;
        double alpha = (p - jD) * (double)length;
        assert (alpha >= 0.0);
        assert (alpha <= 1.0);
        return asArray[j] * (1.0 - alpha) + asArray[j + 1] * alpha;
    }

    protected static double quartile(Evaluator evaluator, List members, Calc exp, int range) {
        Util.assertPrecondition(range >= 1 && range <= 3, "range >= 1 && range <= 3");
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        double dm = 0.25 * (double)asArray.length * (double)range;
        int median = (int)Math.floor(dm);
        return dm == (double)median && median < asArray.length - 1 ? (asArray[median] + asArray[median + 1]) / 2.0 : asArray[median];
    }

    public static Object min(Evaluator evaluator, List members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, calc);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double min = (Double)sw.v.get(0);
        for (int i = 1; i < size; ++i) {
            Double iValue = (Double)sw.v.get(i);
            if (!(iValue < min)) continue;
            min = iValue;
        }
        return min;
    }

    public static Object max(Evaluator evaluator, List members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double max = (Double)sw.v.get(0);
        for (int i = 1; i < size; ++i) {
            Double iValue = (Double)sw.v.get(i);
            if (!(iValue > max)) continue;
            max = iValue;
        }
        return max;
    }

    static Object var(Evaluator evaluator, List members, Calc exp, boolean biased) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        return FunUtil._var(sw, biased);
    }

    private static Object _var(SetWrapper sw, boolean biased) {
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double stdev = 0.0;
        double avg = FunUtil._avg(sw);
        for (int i = 0; i < sw.v.size(); ++i) {
            stdev += Math.pow((Double)sw.v.get(i) - avg, 2.0);
        }
        int n = sw.v.size();
        if (!biased) {
            --n;
        }
        return new Double(stdev / (double)n);
    }

    static double correlation(Evaluator evaluator, List memberList, Calc exp1, Calc exp2) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator, memberList, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator, memberList, exp2);
        Object covar = FunUtil._covariance(sw1, sw2, false);
        Object var1 = FunUtil._var(sw1, false);
        Object var2 = FunUtil._var(sw2, false);
        if (covar instanceof Double && var1 instanceof Double && var2 instanceof Double) {
            return (Double)covar / Math.sqrt((Double)var1 * (Double)var2);
        }
        return 1.2345E-8;
    }

    static Object covariance(Evaluator evaluator, List members, Calc exp1, Calc exp2, boolean biased) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator.push(), members, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator.push(), members, exp2);
        return FunUtil._covariance(sw1, sw2, biased);
    }

    private static Object _covariance(SetWrapper sw1, SetWrapper sw2, boolean biased) {
        if (sw1.v.size() != sw2.v.size()) {
            return Util.nullValue;
        }
        double avg1 = FunUtil._avg(sw1);
        double avg2 = FunUtil._avg(sw2);
        double covar = 0.0;
        for (int i = 0; i < sw1.v.size(); ++i) {
            double diff1 = (Double)sw1.v.get(i) - avg1;
            double diff2 = (Double)sw2.v.get(i) - avg2;
            covar += diff1 * diff2;
        }
        int n = sw1.v.size();
        if (!biased) {
            --n;
        }
        return new Double(covar / (double)n);
    }

    static Object stdev(Evaluator evaluator, List members, Calc exp, boolean biased) {
        Object o = FunUtil.var(evaluator, members, exp, biased);
        return o instanceof Double ? new Double(Math.sqrt((Double)o)) : o;
    }

    public static Object avg(Evaluator evaluator, List members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, calc);
        return sw.errorCount > 0 ? new Double(Double.NaN) : (sw.v.size() == 0 ? Util.nullValue : new Double(FunUtil._avg(sw)));
    }

    private static double _avg(SetWrapper sw) {
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Double)sw.v.get(i)).doubleValue();
        }
        return sum / (double)sw.v.size();
    }

    public static Object sum(Evaluator evaluator, List members, Calc exp) {
        double d = FunUtil.sumDouble(evaluator, members, exp);
        return d == 1.2345E-8 ? Util.nullValue : new Double(d);
    }

    public static double sumDouble(Evaluator evaluator, List members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Double)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static double sumDouble(Evaluator evaluator, Iterable iterable, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, iterable, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Double)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static int count(Evaluator evaluator, Iterable iterable, boolean includeEmpty) {
        if (iterable == null) {
            return 0;
        }
        if (includeEmpty) {
            if (iterable instanceof Collection) {
                return ((Collection)iterable).size();
            }
            int retval = 0;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                it.next();
                ++retval;
            }
            return retval;
        }
        int retval = 0;
        for (Object object : iterable) {
            Object o;
            if (object instanceof Member) {
                evaluator.setContext((Member)object);
            } else {
                evaluator.setContext((Member[])object);
            }
            if ((o = evaluator.evaluateCurrent()) == Util.nullValue || o == null) continue;
            ++retval;
        }
        return retval;
    }

    static SetWrapper evaluateSet(Evaluator evaluator, Iterable members, Calc calc) {
        Util.assertPrecondition(members != null, "members != null");
        Util.assertPrecondition(calc != null, "calc != null");
        Util.assertPrecondition(calc.getType() instanceof ScalarType);
        SetWrapper retval = new SetWrapper();
        for (Object obj : members) {
            if (obj instanceof Member[]) {
                evaluator.setContext((Member[])obj);
            } else {
                evaluator.setContext((Member)obj);
            }
            Object o = calc.evaluate(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o instanceof Throwable) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof Double) {
                retval.v.add(o);
                continue;
            }
            if (o instanceof Number) {
                retval.v.add(((Number)o).doubleValue());
                continue;
            }
            retval.v.add(o);
        }
        return retval;
    }

    static SetWrapper[] evaluateSet(Evaluator evaluator, List members, DoubleCalc[] calcs, boolean isTuples) {
        Util.assertPrecondition(calcs != null, "calcs != null");
        SetWrapper[] retvals = new SetWrapper[calcs.length];
        for (int i = 0; i < calcs.length; ++i) {
            retvals[i] = new SetWrapper();
        }
        for (int j = 0; j < members.size(); ++j) {
            if (isTuples) {
                evaluator.setContext((Member[])members.get(j));
            } else {
                evaluator.setContext((Member)members.get(j));
            }
            for (int i = 0; i < calcs.length; ++i) {
                DoubleCalc calc = calcs[i];
                SetWrapper retval = retvals[i];
                double o = calc.evaluateDouble(evaluator);
                if (o == 1.2345E-8) {
                    ++retval.nullCount;
                    retval.v.add(null);
                    continue;
                }
                retval.v.add(o);
            }
        }
        return retvals;
    }

    static List<Member> periodsToDate(Evaluator evaluator, Level level, Member member) {
        Member m;
        if (member == null) {
            member = evaluator.getContext(level.getHierarchy().getDimension());
        }
        for (m = member; m != null && m.getLevel() != level; m = m.getParentMember()) {
        }
        ArrayList<Member> members = new ArrayList<Member>();
        if (m != null) {
            SchemaReader reader = evaluator.getSchemaReader();
            m = Util.getFirstDescendantOnLevel(reader, m, member.getLevel());
            reader.getMemberRange(level, m, member, members);
        }
        return members;
    }

    static List<Member> memberRange(Evaluator evaluator, Member startMember, Member endMember) {
        Level level = startMember.getLevel();
        FunUtil.assertTrue(level == endMember.getLevel());
        ArrayList<Member> members = new ArrayList<Member>();
        evaluator.getSchemaReader().getMemberRange(level, startMember, endMember, members);
        if (members.isEmpty()) {
            evaluator.getSchemaReader().getMemberRange(level, endMember, startMember, members);
        }
        return members;
    }

    static Member cousin(SchemaReader schemaReader, Member member, Member ancestorMember) {
        if (ancestorMember.isNull()) {
            return ancestorMember;
        }
        if (member.getHierarchy() != ancestorMember.getHierarchy()) {
            throw MondrianResource.instance().CousinHierarchyMismatch.ex(member.getUniqueName(), ancestorMember.getUniqueName());
        }
        if (member.getLevel().getDepth() < ancestorMember.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        Member cousin = FunUtil.cousin2(schemaReader, member, ancestorMember);
        if (cousin == null) {
            cousin = member.getHierarchy().getNullMember();
        }
        return cousin;
    }

    private static Member cousin2(SchemaReader schemaReader, Member member1, Member member2) {
        if (member1.getLevel() == member2.getLevel()) {
            return member2;
        }
        Member uncle = FunUtil.cousin2(schemaReader, member1.getParentMember(), member2);
        if (uncle == null) {
            return null;
        }
        int ordinal = Util.getMemberOrdinalInParent(schemaReader, member1);
        Member[] cousins = schemaReader.getMemberChildren(uncle);
        if (cousins.length <= ordinal) {
            return null;
        }
        return cousins[ordinal];
    }

    static Member ancestor(Evaluator evaluator, Member member, int distance, Level targetLevel) {
        if (targetLevel != null && member.getHierarchy() != targetLevel.getHierarchy()) {
            throw MondrianResource.instance().MemberNotInLevelHierarchy.ex(member.getUniqueName(), targetLevel.getUniqueName());
        }
        if (distance == 0) {
            return member;
        }
        if (distance < 0) {
            return member.getHierarchy().getNullMember();
        }
        Member[] ancestors = member.getAncestorMembers();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        Member result = member.getHierarchy().getNullMember();
        for (int i = 0; i < ancestors.length; ++i) {
            Member ancestorMember = ancestors[i];
            if (targetLevel != null) {
                if (ancestorMember.getLevel() != targetLevel) continue;
                if (schemaReader.isVisible(ancestorMember)) {
                    result = ancestorMember;
                    break;
                }
                result = member.getHierarchy().getNullMember();
                break;
            }
            if (!schemaReader.isVisible(ancestorMember) || --distance != 0) continue;
            result = ancestorMember;
            break;
        }
        return result;
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) {
        Member prev2;
        Member prev1;
        if (m1 instanceof RolapHierarchy.LimitedRollupMember) {
            m1 = ((RolapHierarchy.LimitedRollupMember)m1).member;
        }
        if (m2 instanceof RolapHierarchy.LimitedRollupMember) {
            m2 = ((RolapHierarchy.LimitedRollupMember)m2).member;
        }
        if (FunUtil.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        int c = FunUtil.compareSiblingMembers(prev1, prev2);
        assert (c != 0) : "Members " + prev1 + ", " + prev2 + " are not equal, but compare returned 0.";
        return c;
    }

    public static int compareSiblingMembers(Member m1, Member m2) {
        int ordinal2;
        boolean calculated1 = m1.isCalculatedInQuery();
        boolean calculated2 = m2.isCalculatedInQuery();
        if (calculated1) {
            if (!calculated2) {
                return 1;
            }
        } else if (calculated2) {
            return -1;
        }
        Comparable k1 = m1.getOrderKey();
        Comparable k2 = m2.getOrderKey();
        if (k1 != null && k2 != null) {
            return k1.compareTo(k2);
        }
        int ordinal1 = m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.getOrdinal()) ? m1.compareTo(m2) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    static boolean tupleContainsNullMember(Member[] tuple) {
        for (Member member : tuple) {
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static Member[] makeNullTuple(TupleType tupleType) {
        Member[] members = new Member[tupleType.elementTypes.length];
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            MemberType type = (MemberType)tupleType.elementTypes[i];
            members[i] = FunUtil.makeNullMember(type);
        }
        return members;
    }

    static Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return NullMember;
        }
        return hierarchy.getNullMember();
    }

    public static FunDef resolveFunArgs(Validator validator, Exp[] args, Exp[] newArgs, String name, Syntax syntax) {
        int[] paramCategories;
        Query query = validator.getQuery();
        Cube cube = null;
        if (query != null) {
            cube = query.getCube();
        }
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = validator.validate(args[i], false);
        }
        FunTable funTable = validator.getFunTable();
        FunDef funDef = funTable.getDef(newArgs, validator, name, syntax);
        if (!(funDef instanceof SetFunDef) && query != null && query.nativeCrossJoinVirtualCube() && (paramCategories = funDef.getParameterCategories()).length > 0 && (paramCategories[0] == 2 && newArgs[0] instanceof DimensionExpr && ((DimensionExpr)newArgs[0]).getDimension().getOrdinal(cube) == 0 || paramCategories[0] == 6 && newArgs[0] instanceof MemberExpr && ((MemberExpr)newArgs[0]).getMember().getDimension().getOrdinal(cube) == 0 && (funDef.getReturnCategory() == 6 || funDef.getReturnCategory() == 8))) {
            query.setVirtualCubeNonNativeCrossJoin();
        }
        return funDef;
    }

    static void appendTuple(StringBuilder buf, Member[] members) {
        buf.append("(");
        for (int j = 0; j < members.length; ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            Member member = members[j];
            buf.append(member.getUniqueName());
        }
        buf.append(")");
    }

    static boolean equalTuple(Member[] members0, Member[] members1) {
        int count = members0.length;
        if (count != members1.length) {
            return false;
        }
        block0: for (int i = 0; i < count; ++i) {
            Member member0 = members0[i];
            if (member0.equals(members1[i])) continue;
            for (int j = 0; j < count; ++j) {
                if (i != j && member0.equals(members1[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    static FunDef createDummyFunDef(Resolver resolver, int returnCategory, Exp[] args) {
        int[] argCategories = ExpBase.getTypes(args);
        return new FunDefBase(resolver, returnCategory, argCategories){};
    }

    public static Member[] getNonEmptyMemberChildren(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildren(member, evaluator);
        }
        return sr.getMemberChildren(member);
    }

    static Member[] getNonEmptyLevelMembers(Evaluator evaluator, Level level, boolean includeCalcMembers) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            Member[] members = sr.getLevelMembers(level, evaluator);
            if (includeCalcMembers) {
                return FunUtil.addLevelCalculatedMembers(sr, level, members);
            }
            return members;
        }
        return sr.getLevelMembers(level, includeCalcMembers);
    }

    static List<Member> levelMembers(Level level, Evaluator evaluator, boolean includeCalcMembers) {
        Member[] members = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
        ArrayList<Member> memberList = new ArrayList<Member>(Arrays.asList(members));
        if (!includeCalcMembers) {
            FunUtil.removeCalculatedMembers(memberList);
        }
        FunUtil.hierarchize(memberList, false);
        return memberList;
    }

    static List<Member> hierarchyMembers(Hierarchy hierarchy, Evaluator evaluator, boolean includeCalcMembers) {
        ArrayList<Member> memberList;
        if (evaluator.isNonEmpty()) {
            memberList = new ArrayList();
            for (Level level : hierarchy.getLevels()) {
                Member[] members = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
                memberList.addAll(Arrays.asList(members));
            }
        } else {
            memberList = FunUtil.addMembers(evaluator.getSchemaReader(), new ArrayList<Member>(), hierarchy);
            if (!includeCalcMembers && memberList != null) {
                FunUtil.removeCalculatedMembers(memberList);
            }
        }
        FunUtil.hierarchize(memberList, false);
        return memberList;
    }

    static List<Member> dimensionMembers(Dimension dimension, Evaluator evaluator, boolean includeCalcMembers) {
        Hierarchy hierarchy = dimension.getHierarchy();
        return FunUtil.hierarchyMembers(hierarchy, evaluator, includeCalcMembers);
    }

    private static class NullMember
    implements Member {
        private NullMember() {
        }

        public Member getParentMember() {
            throw new UnsupportedOperationException();
        }

        public Level getLevel() {
            throw new UnsupportedOperationException();
        }

        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        public String getParentUniqueName() {
            throw new UnsupportedOperationException();
        }

        public Member.MemberType getMemberType() {
            throw new UnsupportedOperationException();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        public boolean isAll() {
            return false;
        }

        public boolean isMeasure() {
            throw new UnsupportedOperationException();
        }

        public boolean isNull() {
            return true;
        }

        public boolean isChildOrEqualTo(Member member) {
            throw new UnsupportedOperationException();
        }

        public boolean isCalculated() {
            throw new UnsupportedOperationException();
        }

        public int getSolveOrder() {
            throw new UnsupportedOperationException();
        }

        public Exp getExpression() {
            throw new UnsupportedOperationException();
        }

        public Member[] getAncestorMembers() {
            throw new UnsupportedOperationException();
        }

        public boolean isCalculatedInQuery() {
            throw new UnsupportedOperationException();
        }

        public Object getPropertyValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public Object getPropertyValue(String propertyName, boolean matchCase) {
            throw new UnsupportedOperationException();
        }

        public String getPropertyFormattedValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public void setProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public Property[] getProperties() {
            throw new UnsupportedOperationException();
        }

        public int getOrdinal() {
            throw new UnsupportedOperationException();
        }

        public Comparable getOrderKey() {
            throw new UnsupportedOperationException();
        }

        public boolean isHidden() {
            throw new UnsupportedOperationException();
        }

        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        public Member getDataMember() {
            throw new UnsupportedOperationException();
        }

        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s) {
            throw new UnsupportedOperationException();
        }

        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            throw new UnsupportedOperationException();
        }

        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DescendingValueComparator
    implements Comparator {
        static final DescendingValueComparator instance = new DescendingValueComparator();

        private DescendingValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            return -FunUtil.compareValues(o1, o2);
        }
    }

    static class SetWrapper {
        List v = new ArrayList();
        public int errorCount = 0;
        public int nullCount = 0;

        SetWrapper() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator<T>
    implements Comparator<T> {
        Comparator<T> comparator;

        ReverseComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            int c = this.comparator.compare(o1, o2);
            return -c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchizeComparator
    implements Comparator<Member> {
        private final boolean post;

        HierarchizeComparator(boolean post) {
            this.post = post;
        }

        @Override
        public int compare(Member m1, Member m2) {
            return FunUtil.compareHierarchically(m1, m2, this.post);
        }
    }

    private static class HierarchizeArrayComparator
    extends ArrayComparator {
        private final boolean post;

        HierarchizeArrayComparator(int arity, boolean post) {
            super(arity);
            this.post = post;
        }

        public int compare(Member[] a1, Member[] a2) {
            for (int i = 0; i < this.arity; ++i) {
                Member m1 = a1[i];
                Member m2 = a2[i];
                int c = FunUtil.compareHierarchically(m1, m2, this.post);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    private static class BreakArrayComparator
    extends ArrayExpComparator {
        BreakArrayComparator(Evaluator evaluator, Calc calc, int arity) {
            super(evaluator, calc, arity);
        }

        public int compare(Member[] a1, Member[] a2) {
            this.evaluator.setContext(a1);
            Object v1 = this.calc.evaluate(this.evaluator);
            this.evaluator.setContext(a2);
            Object v2 = this.calc.evaluate(this.evaluator);
            return FunUtil.compareValues(v1, v2);
        }
    }

    private static class HierarchicalArrayComparator
    extends ArrayExpComparator {
        private final boolean desc;

        HierarchicalArrayComparator(Evaluator evaluator, Calc calc, int arity, boolean desc) {
            super(evaluator, calc, arity);
            this.desc = desc;
        }

        public int compare(Member[] a1, Member[] a2) {
            Member m2;
            Member m1;
            int c = 0;
            this.evaluator = this.evaluator.push();
            for (int i = 0; i < this.arity && (c = this.compareHierarchicallyButSiblingsByValue(m1 = a1[i], m2 = a2[i])) == 0; ++i) {
                Util.assertTrue(m1.equals(m2));
                this.evaluator.setContext(m1);
            }
            this.evaluator = this.evaluator.pop();
            return c;
        }

        protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c == 0) {
                c = FunUtil.compareSiblingMembers(prev1, prev2);
            }
            return this.desc ? -c : c;
        }

        private int compareByValue(Member m1, Member m2) {
            Member old = this.evaluator.setContext(m1);
            Object v1 = this.calc.evaluate(this.evaluator);
            this.evaluator.setContext(m2);
            Object v2 = this.calc.evaluate(this.evaluator);
            this.evaluator.setContext(old);
            int c = FunUtil.compareValues(v1, v2);
            return c;
        }
    }

    private static abstract class ArrayExpComparator
    extends ArrayComparator {
        Evaluator evaluator;
        final Calc calc;

        ArrayExpComparator(Evaluator evaluator, Calc calc, int arity) {
            super(arity);
            this.evaluator = evaluator;
            this.calc = calc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingTupleComparator
    implements Comparator<Member[]> {
        private final Comparator<Member[]> comparator;
        private final Logger logger;

        LoggingTupleComparator(Comparator<Member[]> comparator, Logger logger) {
            this.comparator = comparator;
            this.logger = logger;
        }

        private static String toString(Member[] a) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < a.length; ++i) {
                Member member = a[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(member.getUniqueName());
            }
            return sb.toString();
        }

        @Override
        public int compare(Member[] a1, Member[] a2) {
            int c = this.comparator.compare(a1, a2);
            this.logger.debug((Object)("compare {" + LoggingTupleComparator.toString(a1) + "}, {" + LoggingTupleComparator.toString(a2) + "} yields " + c));
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ArrayComparator
    implements Comparator<Member[]> {
        private static final Logger LOGGER = Logger.getLogger(ArrayComparator.class);
        final int arity;

        ArrayComparator(int arity) {
            this.arity = arity;
        }

        Comparator<Member[]> wrap() {
            if (LOGGER.isDebugEnabled()) {
                return new LoggingTupleComparator(this, LOGGER);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BreakMemberComparator
    extends MemberComparator {
        BreakMemberComparator(Map<Member, Object> mapMemberToValue, boolean desc) {
            super(mapMemberToValue, desc);
        }

        @Override
        public final int compare(Member m1, Member m2) {
            return this.compareByValue(m1, m2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchicalMemberComparator
    extends MemberComparator {
        HierarchicalMemberComparator(Map<Member, Object> mapMemberToValue, boolean desc) {
            super(mapMemberToValue, desc);
        }

        @Override
        public int compare(Member m1, Member m2) {
            return this.compareHierarchicallyButSiblingsByValue(m1, m2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MemberComparator
    implements Comparator<Member> {
        private static final Logger LOGGER = Logger.getLogger(MemberComparator.class);
        Map<Member, Object> mapMemberToValue;
        private boolean desc;

        MemberComparator(Map<Member, Object> mapMemberToValue, boolean desc) {
            this.mapMemberToValue = mapMemberToValue;
            this.desc = desc;
        }

        Comparator<Member> wrap() {
            final MemberComparator comparator = this;
            if (LOGGER.isDebugEnabled()) {
                return new Comparator<Member>(){

                    @Override
                    public int compare(Member m1, Member m2) {
                        int c = comparator.compare(m1, m2);
                        LOGGER.debug((Object)("compare " + m1.getUniqueName() + "(" + MemberComparator.this.mapMemberToValue.get(m1) + "), " + m2.getUniqueName() + "(" + MemberComparator.this.mapMemberToValue.get(m2) + ")" + " yields " + c));
                        return c;
                    }
                };
            }
            return this;
        }

        protected final int compareByValue(Member m1, Member m2) {
            Object value1 = this.mapMemberToValue.get(m1);
            Object value2 = this.mapMemberToValue.get(m2);
            int c = FunUtil.compareValues(value1, value2);
            return this.desc ? -c : c;
        }

        protected final int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c != 0) {
                return c;
            }
            c = FunUtil.compareSiblingMembers(prev1, prev2);
            return c;
        }
    }
}

