/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.spi.UserDefinedFunction;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalFunTable
extends FunTableImpl {
    private static Logger logger = Logger.getLogger(GlobalFunTable.class);
    private static GlobalFunTable instance = new GlobalFunTable();

    public static GlobalFunTable instance() {
        return instance;
    }

    private GlobalFunTable() {
        this.init();
    }

    @Override
    protected void defineFunctions() {
        BuiltinFunTable builtinFunTable = BuiltinFunTable.instance();
        List<String> reservedWords = builtinFunTable.getReservedWords();
        for (String reservedWord : reservedWords) {
            this.defineReserved(reservedWord);
        }
        List<Resolver> resolvers = builtinFunTable.getResolvers();
        for (Resolver resolver : resolvers) {
            this.define(resolver);
        }
        for (String className : this.lookupUdfImplClasses()) {
            this.defineUdf(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> lookupUdfImplClasses() {
        ClassLoader cl = this.getClass().getClassLoader();
        ArrayList<URL> serviceUrls = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceEnum = cl.getResources("META-INF/services/mondrian.spi.UserDefinedFunction");
            while (serviceEnum.hasMoreElements()) {
                serviceUrls.add(serviceEnum.nextElement());
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error while finding service files for user-defined functions", (Throwable)e);
        }
        HashSet<String> classNames = new HashSet<String>();
        for (URL url : serviceUrls) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    int comment = line.indexOf(35);
                    if (comment != -1) {
                        line = line.substring(0, comment).trim();
                    }
                    classNames.add(line);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Error when loading service file '" + url + "'"), (Throwable)e);
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return classNames;
    }

    private void defineUdf(String className) {
        Class<?> udfClass;
        try {
            udfClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw MondrianResource.instance().UdfClassNotFound.ex("", className);
        }
        UserDefinedFunction udf = Util.createUdf(udfClass);
        this.validateFunction(udf);
        this.define(new UdfResolver(udf));
    }

    private void validateFunction(UserDefinedFunction udf) {
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }
}

