/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class OrderFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Order", "Order(<Set>, <Value Expression>[, ASC | DESC | BASC | BDESC])", "Arranges members of a set, optionally preserving or breaking the hierarchy.", new String[]{"fxxvy", "fxxv"}, OrderFunDef.class, Flag.getNames());

    public OrderFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        Calc expCalc = compiler.compileScalar(call.getArg(1), true);
        Flag order = OrderFunDef.getLiteralArg(call, 2, Flag.ASC, Flag.class);
        if (expCalc instanceof MemberValueCalc) {
            MemberCalc[] calcs;
            MemberValueCalc memberValueCalc = (MemberValueCalc)expCalc;
            ArrayList<MemberCalc> constantList = new ArrayList<MemberCalc>();
            ArrayList<MemberCalc> variableList = new ArrayList<MemberCalc>();
            for (MemberCalc memberCalc : calcs = (MemberCalc[])memberValueCalc.getCalcs()) {
                if (memberCalc instanceof ConstantCalc && !listCalc.dependsOn(memberCalc.getType().getHierarchy().getDimension())) {
                    constantList.add(memberCalc);
                    continue;
                }
                variableList.add(memberCalc);
            }
            if (!constantList.isEmpty()) {
                if (variableList.isEmpty()) {
                    return new ContextCalc(calcs, new CalcImpl(call, listCalc, new ValueCalc(new DummyExp(expCalc.getType())), order.descending, order.brk));
                }
                return new ContextCalc(constantList.toArray(new MemberCalc[constantList.size()]), new CalcImpl(call, listCalc, new MemberValueCalc(new DummyExp(expCalc.getType()), variableList.toArray(new MemberCalc[variableList.size()])), order.descending, order.brk));
            }
        }
        return new CalcImpl(call, listCalc, expCalc, order.descending, order.brk);
    }

    private static class ContextCalc
    extends GenericCalc {
        private final MemberCalc[] memberCalcs;
        private final CalcImpl calc;
        private final Calc[] calcs;
        private final Member[] members;

        protected ContextCalc(MemberCalc[] memberCalcs, CalcImpl calc) {
            super(new DummyExp(calc.getType()));
            this.memberCalcs = memberCalcs;
            this.calc = calc;
            this.calcs = new Calc[memberCalcs.length + 1];
            System.arraycopy(memberCalcs, 0, this.calcs, 0, memberCalcs.length);
            this.calcs[this.calcs.length - 1] = calc;
            this.members = new Member[memberCalcs.length];
        }

        public Calc[] getCalcs() {
            return this.calcs;
        }

        public Object evaluate(Evaluator evaluator) {
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                this.members[i] = this.memberCalcs[i].evaluateMember(evaluator);
            }
            Evaluator subEval = evaluator.push(this.members);
            return this.calc.evaluateDual(evaluator, subEval);
        }

        public boolean dependsOn(Dimension dimension) {
            if (ContextCalc.anyDepends(this.memberCalcs, dimension)) {
                return true;
            }
            for (MemberCalc memberCalc : this.memberCalcs) {
                if (!memberCalc.getType().usesDimension(dimension, true)) continue;
                return false;
            }
            return this.calc.dependsOn(dimension);
        }

        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;
        private final Calc expCalc;
        private final boolean desc;
        private final boolean brk;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc, Calc expCalc, boolean desc, boolean brk) {
            super(call, new Calc[]{listCalc, expCalc});
            assert (listCalc.getResultStyle() == ResultStyle.MUTABLE_LIST);
            this.listCalc = listCalc;
            this.expCalc = expCalc;
            this.desc = desc;
            this.brk = brk;
        }

        public List evaluateDual(Evaluator rootEvaluator, Evaluator subEvaluator) {
            List list = this.listCalc.evaluateList(rootEvaluator);
            FunUtil.sortMembers(subEvaluator.push(), list, this.expCalc, this.desc, this.brk);
            return list;
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            FunUtil.sortMembers(evaluator.push(), list, this.expCalc, this.desc, this.brk);
            return list;
        }

        @Override
        public Calc[] getCalcs() {
            return new Calc[]{this.listCalc, this.expCalc};
        }

        @Override
        public List<Object> getArguments() {
            return Collections.singletonList(this.desc ? (this.brk ? Flag.BDESC : Flag.DESC) : (this.brk ? Flag.BASC : Flag.ASC));
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            return CalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Flag {
        ASC(false, false),
        DESC(true, false),
        BASC(false, true),
        BDESC(true, true);

        private final boolean descending;
        private final boolean brk;

        private Flag(boolean descending, boolean brk) {
            this.descending = descending;
            this.brk = brk;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Flag flags : (Flag[])Flag.class.getEnumConstants()) {
                names.add(flags.name());
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

