/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.QueryAxis;
import mondrian.olap4j.MondrianOlap4jCellSet;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCellSetAxis
implements CellSetAxis {
    private final MondrianOlap4jCellSet olap4jCellSet;
    private final QueryAxis queryAxis;
    private final Axis axis;

    MondrianOlap4jCellSetAxis(MondrianOlap4jCellSet olap4jCellSet, QueryAxis queryAxis, Axis axis) {
        assert (olap4jCellSet != null);
        assert (queryAxis != null);
        assert (axis != null);
        this.olap4jCellSet = olap4jCellSet;
        this.queryAxis = queryAxis;
        this.axis = axis;
    }

    public org.olap4j.Axis getAxisOrdinal() {
        switch (this.queryAxis.getAxisOrdinal()) {
            case SLICER: {
                return org.olap4j.Axis.FILTER;
            }
        }
        return org.olap4j.Axis.valueOf((String)this.queryAxis.getAxisOrdinal().name());
    }

    public CellSet getCellSet() {
        return this.olap4jCellSet;
    }

    public CellSetAxisMetaData getAxisMetaData() {
        AxisOrdinal axisOrdinal = this.queryAxis.getAxisOrdinal();
        switch (axisOrdinal) {
            case SLICER: {
                return this.olap4jCellSet.getMetaData().getFilterAxisMetaData();
            }
        }
        return (CellSetAxisMetaData)this.olap4jCellSet.getMetaData().getAxesMetaData().get(axisOrdinal.logicalOrdinal());
    }

    public List<org.olap4j.Position> getPositions() {
        switch (this.getAxisOrdinal()) {
            case FILTER: {
                List hierarchyList = this.getAxisMetaData().getHierarchies();
                final org.olap4j.metadata.Member[] members = new org.olap4j.metadata.Member[hierarchyList.size()];
                MondrianOlap4jConnection olap4jConnection = this.olap4jCellSet.olap4jStatement.olap4jConnection;
                for (Member member : this.axis.getPositions().get(0)) {
                    MondrianOlap4jHierarchy hierarchy = olap4jConnection.toOlap4j(member.getHierarchy());
                    members[hierarchyList.indexOf((Object)hierarchy)] = olap4jConnection.toOlap4j(member);
                }
                int k = -1;
                for (MondrianOlap4jHierarchy hierarchy : hierarchyList) {
                    if (members[++k] != null) continue;
                    members[k] = hierarchy.getDefaultMember();
                }
                org.olap4j.Position position = new org.olap4j.Position(){

                    public List<org.olap4j.metadata.Member> getMembers() {
                        return Arrays.asList(members);
                    }

                    public int getOrdinal() {
                        return 0;
                    }
                };
                return Collections.singletonList(position);
            }
        }
        return new AbstractList<org.olap4j.Position>(){

            @Override
            public org.olap4j.Position get(int index) {
                Position mondrianPosition = MondrianOlap4jCellSetAxis.this.axis.getPositions().get(index);
                return new MondrianOlap4jPosition(mondrianPosition, index);
            }

            @Override
            public int size() {
                return MondrianOlap4jCellSetAxis.this.axis.getPositions().size();
            }
        };
    }

    public int getPositionCount() {
        return this.getPositions().size();
    }

    public ListIterator<org.olap4j.Position> iterator() {
        return this.getPositions().listIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MondrianOlap4jPosition
    implements org.olap4j.Position {
        private final Position mondrianPosition;
        private final int index;

        public MondrianOlap4jPosition(Position mondrianPosition, int index) {
            this.mondrianPosition = mondrianPosition;
            this.index = index;
        }

        public List<org.olap4j.metadata.Member> getMembers() {
            return new AbstractList<org.olap4j.metadata.Member>(){

                @Override
                public org.olap4j.metadata.Member get(int index) {
                    Member mondrianMember = (Member)MondrianOlap4jPosition.this.mondrianPosition.get(index);
                    return ((MondrianOlap4jCellSetAxis)MondrianOlap4jCellSetAxis.this).olap4jCellSet.olap4jStatement.olap4jConnection.toOlap4j(mondrianMember);
                }

                @Override
                public int size() {
                    return MondrianOlap4jPosition.this.mondrianPosition.size();
                }
            };
        }

        public int getOrdinal() {
            return this.index;
        }
    }
}

