/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.NamedSet;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap4j.Factory;
import mondrian.olap4j.MondrianOlap4jCatalog;
import mondrian.olap4j.MondrianOlap4jCube;
import mondrian.olap4j.MondrianOlap4jDatabaseMetaData;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import mondrian.olap4j.MondrianOlap4jLevel;
import mondrian.olap4j.MondrianOlap4jMeasure;
import mondrian.olap4j.MondrianOlap4jMember;
import mondrian.olap4j.MondrianOlap4jNamedSet;
import mondrian.olap4j.MondrianOlap4jSchema;
import mondrian.olap4j.MondrianOlap4jStatement;
import mondrian.rolap.RolapMeasure;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.NamedList;
import org.olap4j.type.CubeType;
import org.olap4j.type.DimensionType;
import org.olap4j.type.MemberType;
import org.olap4j.type.NullType;
import org.olap4j.type.SetType;
import org.olap4j.type.SymbolType;
import org.olap4j.type.TupleType;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MondrianOlap4jConnection
implements OlapConnection {
    final Helper helper = new Helper();
    Connection connection;
    MondrianOlap4jSchema olap4jSchema;
    final Map<Schema, MondrianOlap4jSchema> schemaMap = new HashMap<Schema, MondrianOlap4jSchema>();
    private final MondrianOlap4jDatabaseMetaData olap4jDatabaseMetaData;
    static final String LOCALDB_CATALOG_NAME = "LOCALDB";
    private static final String CONNECT_STRING_PREFIX = "jdbc:mondrian:";
    final Factory factory;
    private Locale locale;
    private String roleName;
    private boolean autoCommit;
    private boolean readOnly;

    MondrianOlap4jConnection(Factory factory, String url, Properties info) throws SQLException {
        this.factory = factory;
        if (!MondrianOlap4jConnection.acceptsURL(url)) {
            throw new AssertionError((Object)"does not start with 'jdbc:mondrian:'");
        }
        String x = url.substring(CONNECT_STRING_PREFIX.length());
        Util.PropertyList list = Util.parseConnectString(x);
        for (Map.Entry<String, String> entry : MondrianOlap4jConnection.toMap(info).entrySet()) {
            list.put(entry.getKey(), entry.getValue());
        }
        this.connection = DriverManager.getConnection(list, null);
        this.olap4jDatabaseMetaData = factory.newDatabaseMetaData(this);
        this.olap4jSchema = this.toOlap4j(this.connection.getSchema());
    }

    static boolean acceptsURL(String url) {
        return url.startsWith(CONNECT_STRING_PREFIX);
    }

    public OlapStatement createStatement() {
        return new MondrianOlap4jStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            Connection c = this.connection;
            this.connection = null;
            c.close();
        }
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    public OlapDatabaseMetaData getMetaData() {
        return this.olap4jDatabaseMetaData;
    }

    public NamedList<Catalog> getCatalogs() {
        return this.olap4jDatabaseMetaData.getCatalogObjects();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (!catalog.equals(LOCALDB_CATALOG_NAME)) {
            throw new UnsupportedOperationException();
        }
    }

    public String getCatalog() throws SQLException {
        return LOCALDB_CATALOG_NAME;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        if (iface.isInstance(this.connection)) {
            return iface.cast(this.connection);
        }
        throw this.helper.createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || iface.isInstance(this.connection);
    }

    public PreparedOlapStatement prepareOlapStatement(String mdx) throws OlapException {
        return this.factory.newPreparedStatement(mdx, this);
    }

    public MdxParserFactory getParserFactory() {
        return new MdxParserFactory(){

            public MdxParser createMdxParser(OlapConnection connection) {
                return new DefaultMdxParserImpl(connection);
            }

            public MdxValidator createMdxValidator(OlapConnection connection) {
                return new MondrianOlap4jMdxValidator(connection);
            }
        };
    }

    public org.olap4j.metadata.Schema getSchema() throws OlapException {
        return this.olap4jSchema;
    }

    MondrianOlap4jCube toOlap4j(Cube cube) {
        MondrianOlap4jSchema schema = this.toOlap4j(cube.getSchema());
        return new MondrianOlap4jCube(cube, schema);
    }

    MondrianOlap4jDimension toOlap4j(Dimension dimension) {
        return new MondrianOlap4jDimension(this.toOlap4j(dimension.getSchema()), dimension);
    }

    synchronized MondrianOlap4jSchema toOlap4j(Schema schema) {
        MondrianOlap4jSchema olap4jSchema = this.schemaMap.get(schema);
        if (olap4jSchema == null) {
            MondrianOlap4jCatalog olap4jCatalog = (MondrianOlap4jCatalog)this.getCatalogs().get(LOCALDB_CATALOG_NAME);
            olap4jSchema = new MondrianOlap4jSchema(olap4jCatalog, schema.getSchemaReader(), schema);
            this.schemaMap.put(schema, olap4jSchema);
        }
        return olap4jSchema;
    }

    Type toOlap4j(mondrian.olap.type.Type type) {
        if (type instanceof BooleanType) {
            return new org.olap4j.type.BooleanType();
        }
        if (type instanceof mondrian.olap.type.CubeType) {
            Cube mondrianCube = ((mondrian.olap.type.CubeType)type).getCube();
            return new CubeType((org.olap4j.metadata.Cube)this.toOlap4j(mondrianCube));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new org.olap4j.type.DecimalType(decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof mondrian.olap.type.DimensionType) {
            mondrian.olap.type.DimensionType dimensionType = (mondrian.olap.type.DimensionType)type;
            return new DimensionType((org.olap4j.metadata.Dimension)this.toOlap4j(dimensionType.getDimension()));
        }
        if (type instanceof HierarchyType) {
            return new org.olap4j.type.BooleanType();
        }
        if (type instanceof LevelType) {
            return new org.olap4j.type.BooleanType();
        }
        if (type instanceof mondrian.olap.type.MemberType) {
            mondrian.olap.type.MemberType memberType = (mondrian.olap.type.MemberType)type;
            return new MemberType((org.olap4j.metadata.Dimension)this.toOlap4j(memberType.getDimension()), (org.olap4j.metadata.Hierarchy)this.toOlap4j(memberType.getHierarchy()), (org.olap4j.metadata.Level)this.toOlap4j(memberType.getLevel()), (org.olap4j.metadata.Member)this.toOlap4j(memberType.getMember()));
        }
        if (type instanceof mondrian.olap.type.NullType) {
            return new NullType();
        }
        if (type instanceof NumericType) {
            return new org.olap4j.type.NumericType();
        }
        if (type instanceof mondrian.olap.type.SetType) {
            mondrian.olap.type.SetType setType = (mondrian.olap.type.SetType)type;
            return new SetType(this.toOlap4j(setType.getElementType()));
        }
        if (type instanceof StringType) {
            return new org.olap4j.type.StringType();
        }
        if (type instanceof mondrian.olap.type.TupleType) {
            mondrian.olap.type.TupleType tupleType = (mondrian.olap.type.TupleType)type;
            Type[] types = this.toOlap4j(tupleType.elementTypes);
            return new TupleType(types);
        }
        if (type instanceof mondrian.olap.type.SymbolType) {
            return new SymbolType();
        }
        throw new UnsupportedOperationException();
    }

    MondrianOlap4jMember toOlap4j(Member member) {
        if (member == null) {
            return null;
        }
        if (member instanceof RolapMeasure) {
            RolapMeasure measure = (RolapMeasure)member;
            return new MondrianOlap4jMeasure(this.toOlap4j(member.getDimension().getSchema()), measure);
        }
        return new MondrianOlap4jMember(this.toOlap4j(member.getDimension().getSchema()), member);
    }

    MondrianOlap4jLevel toOlap4j(Level level) {
        if (level == null) {
            return null;
        }
        return new MondrianOlap4jLevel(this.toOlap4j(level.getDimension().getSchema()), level);
    }

    MondrianOlap4jHierarchy toOlap4j(Hierarchy hierarchy) {
        if (hierarchy == null) {
            return null;
        }
        return new MondrianOlap4jHierarchy(this.toOlap4j(hierarchy.getDimension().getSchema()), hierarchy);
    }

    Type[] toOlap4j(mondrian.olap.type.Type[] mondrianTypes) {
        Type[] types = new Type[mondrianTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.toOlap4j(mondrianTypes[i]);
        }
        return types;
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return Olap4jUtil.cast(properties.entrySet());
            }
        };
    }

    MondrianOlap4jNamedSet toOlap4j(Cube cube, NamedSet namedSet) {
        if (namedSet == null) {
            return null;
        }
        return new MondrianOlap4jNamedSet(this.toOlap4j(cube), namedSet);
    }

    ParseTreeNode toOlap4j(Exp exp) {
        return new MondrianToOlap4jNodeConverter(this).toOlap4j(exp);
    }

    SelectNode toOlap4j(Query query) {
        return new MondrianToOlap4jNodeConverter(this).toOlap4j(query);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setRoleName(String roleName) throws OlapException {
        Role role;
        if (roleName == null) {
            role = null;
        } else {
            role = this.connection.getSchema().lookupRole(roleName);
            if (role == null) {
                throw this.helper.createException("Unknown role '" + roleName + "'");
            }
        }
        this.roleName = roleName;
        this.connection.setRole(role);
    }

    public String getRoleName() {
        return this.roleName;
    }

    static Axis toOlap4j(String axisName) {
        if (axisName.equals("SLICER")) {
            axisName = "FILTER";
        }
        return Axis.valueOf((String)axisName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MondrianToOlap4jNodeConverter {
        private final MondrianOlap4jConnection olap4jConnection;

        MondrianToOlap4jNodeConverter(MondrianOlap4jConnection olap4jConnection) {
            this.olap4jConnection = olap4jConnection;
        }

        public SelectNode toOlap4j(Query query) {
            List list = Collections.emptyList();
            return new SelectNode(null, this.toOlap4j(query.getFormulas()), this.toOlap4j(query.getAxes()), (ParseTreeNode)new CubeNode(null, (org.olap4j.metadata.Cube)this.olap4jConnection.toOlap4j(query.getCube())), query.getSlicerAxis() == null ? null : this.toOlap4j(query.getSlicerAxis()), list);
        }

        private AxisNode toOlap4j(QueryAxis axis) {
            return new AxisNode(null, axis.isNonEmpty(), MondrianOlap4jConnection.toOlap4j(axis.getAxisName()), this.toOlap4j(axis.getDimensionProperties()), this.toOlap4j(axis.getSet()));
        }

        private List<IdentifierNode> toOlap4j(Id[] dimensionProperties) {
            ArrayList<IdentifierNode> list = new ArrayList<IdentifierNode>();
            for (Id property : dimensionProperties) {
                list.add(this.toOlap4j(property));
            }
            return list;
        }

        private ParseTreeNode toOlap4j(Exp exp) {
            if (exp instanceof Id) {
                Id id = (Id)exp;
                return this.toOlap4j(id);
            }
            if (exp instanceof ResolvedFunCall) {
                ResolvedFunCall call = (ResolvedFunCall)exp;
                return this.toOlap4j(call);
            }
            if (exp instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)exp;
                return new DimensionNode(null, (org.olap4j.metadata.Dimension)this.olap4jConnection.toOlap4j(dimensionExpr.getDimension()));
            }
            if (exp instanceof HierarchyExpr) {
                HierarchyExpr hierarchyExpr = (HierarchyExpr)exp;
                return new HierarchyNode(null, (org.olap4j.metadata.Hierarchy)this.olap4jConnection.toOlap4j(hierarchyExpr.getHierarchy()));
            }
            if (exp instanceof LevelExpr) {
                LevelExpr levelExpr = (LevelExpr)exp;
                return new LevelNode(null, (org.olap4j.metadata.Level)this.olap4jConnection.toOlap4j(levelExpr.getLevel()));
            }
            if (exp instanceof MemberExpr) {
                MemberExpr memberExpr = (MemberExpr)exp;
                return new MemberNode(null, (org.olap4j.metadata.Member)this.olap4jConnection.toOlap4j(memberExpr.getMember()));
            }
            if (exp instanceof Literal) {
                Literal literal = (Literal)exp;
                Object value = literal.getValue();
                if (literal.getCategory() == 11) {
                    return LiteralNode.createSymbol(null, (String)((String)literal.getValue()));
                }
                if (value instanceof Double) {
                    return LiteralNode.create(null, (Double)((Double)value));
                }
                if (value instanceof Integer) {
                    return LiteralNode.create(null, (Integer)((Integer)value));
                }
                if (value instanceof String) {
                    return LiteralNode.createString(null, (String)((String)value));
                }
                if (value == null) {
                    return LiteralNode.createNull(null);
                }
                throw new RuntimeException("unknown literal " + literal);
            }
            throw Util.needToImplement(exp.getClass());
        }

        private ParseTreeNode toOlap4j(ResolvedFunCall call) {
            CallNode callNode = new CallNode(null, call.getFunName(), this.toOlap4j(call.getSyntax()), this.toOlap4j(Arrays.asList(call.getArgs())));
            if (call.getType() != null) {
                callNode.setType(this.olap4jConnection.toOlap4j(call.getType()));
            }
            return callNode;
        }

        private List<ParseTreeNode> toOlap4j(List<Exp> exprList) {
            ArrayList<ParseTreeNode> result = new ArrayList<ParseTreeNode>();
            for (Exp expr : exprList) {
                result.add(this.toOlap4j(expr));
            }
            return result;
        }

        private org.olap4j.mdx.Syntax toOlap4j(Syntax syntax) {
            return org.olap4j.mdx.Syntax.valueOf((String)syntax.name());
        }

        private List<AxisNode> toOlap4j(QueryAxis[] axes) {
            ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
            for (QueryAxis axis : axes) {
                axisList.add(this.toOlap4j(axis));
            }
            return axisList;
        }

        private List<ParseTreeNode> toOlap4j(Formula[] formulas) {
            ArrayList<ParseTreeNode> list = new ArrayList<ParseTreeNode>();
            for (Formula formula : formulas) {
                if (!formula.isMember()) continue;
                ArrayList<PropertyValueNode> memberPropertyList = new ArrayList<PropertyValueNode>();
                for (Object child : formula.getChildren()) {
                    if (!(child instanceof MemberProperty)) continue;
                    MemberProperty memberProperty = (MemberProperty)child;
                    memberPropertyList.add(new PropertyValueNode(null, memberProperty.getName(), this.toOlap4j(memberProperty.getExp())));
                }
                list.add((ParseTreeNode)new WithMemberNode(null, this.toOlap4j(formula.getIdentifier()), this.toOlap4j(formula.getExpression()), memberPropertyList));
            }
            return list;
        }

        private IdentifierNode toOlap4j(Id id) {
            ArrayList<IdentifierNode.Segment> list = new ArrayList<IdentifierNode.Segment>();
            for (Id.Segment segment : id.getSegments()) {
                list.add(new IdentifierNode.Segment(null, segment.name, this.toOlap4j(segment.quoting)));
            }
            return new IdentifierNode(list.toArray(new IdentifierNode.Segment[list.size()]));
        }

        private IdentifierNode.Quoting toOlap4j(Id.Quoting quoting) {
            return IdentifierNode.Quoting.valueOf((String)quoting.name());
        }
    }

    private static class MondrianOlap4jMdxValidator
    implements MdxValidator {
        private final OlapConnection connection;

        public MondrianOlap4jMdxValidator(OlapConnection connection) {
            this.connection = connection;
        }

        public SelectNode validateSelect(SelectNode selectNode) throws OlapException {
            StringWriter sw = new StringWriter();
            selectNode.unparse(new ParseTreeWriter(new PrintWriter(sw)));
            String mdx = sw.toString();
            MondrianOlap4jConnection olap4jConnection = (MondrianOlap4jConnection)this.connection;
            Query query = olap4jConnection.connection.parseQuery(mdx);
            query.resolve();
            return olap4jConnection.toOlap4j(query);
        }
    }

    static class Helper {
        Helper() {
        }

        OlapException createException(String msg) {
            return new OlapException(msg);
        }

        OlapException createException(Cell context, String msg) {
            OlapException exception = new OlapException(msg);
            exception.setContext((Object)context);
            return exception;
        }

        OlapException createException(Cell context, String msg, Throwable cause) {
            OlapException exception = new OlapException(msg, cause);
            exception.setContext((Object)context);
            return exception;
        }

        OlapException createException(String msg, Throwable cause) {
            return new OlapException(msg, cause);
        }

        public OlapException toOlapException(SQLException e) {
            if (e instanceof OlapException) {
                return (OlapException)e;
            }
            return new OlapException(null, (Throwable)e);
        }
    }
}

