/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.BitSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BitKey
extends Comparable<BitKey>,
Iterable<Integer> {
    public static final byte[] bitPositionTable = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public void set(int var1, boolean var2);

    public void set(int var1);

    public boolean get(int var1);

    public void clear(int var1);

    public void clear();

    public boolean isSuperSetOf(BitKey var1);

    public BitKey or(BitKey var1);

    public BitKey and(BitKey var1);

    public BitKey andNot(BitKey var1);

    public BitKey copy();

    public BitKey emptyCopy();

    public boolean isEmpty();

    public boolean intersects(BitKey var1);

    public BitSet toBitSet();

    @Override
    public Iterator<Integer> iterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Big
    extends AbstractBitKey {
        private long[] bits;

        private Big(int size) {
            this.bits = new long[Big.chunkCount(size + 1)];
        }

        private Big(Big big) {
            this.bits = (long[])big.bits.clone();
        }

        private int size() {
            return this.bits.length;
        }

        @Override
        public void set(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] | Big.bit(pos);
        }

        @Override
        public boolean get(int pos) {
            return (this.bits[Big.chunkPos(pos)] & Big.bit(pos)) != 0L;
        }

        @Override
        public void clear(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] & (Big.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }

        private void or(long bits0) {
            this.bits[0] = this.bits[0] | bits0;
        }

        private void or(long bits0, long bits1) {
            this.bits[0] = this.bits[0] | bits0;
            this.bits[1] = this.bits[1] | bits1;
        }

        private void or(long[] bits) {
            for (int i = 0; i < bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | bits[i];
            }
        }

        private void and(long[] bits) {
            int i;
            int length = Math.min(bits.length, this.bits.length);
            for (i = 0; i < length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & bits[i];
            }
            for (i = bits.length; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() > this.size()) {
                    Big bk = (Big)other.copy();
                    bk.or(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small bk = (Small)bitKey.copy();
                bk.and(this.bits[0]);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 bk = (Mid128)bitKey.copy();
                bk.and(this.bits[0], this.bits[1]);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() < this.size()) {
                    Big bk = (Big)other.copy();
                    bk.and(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.and(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long[] bits) {
            for (int i = 0; i < bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & (bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        private void andNot(long bits0, long bits1) {
            this.bits[0] = this.bits[0] & (bits0 ^ 0xFFFFFFFFFFFFFFFFL);
            this.bits[1] = this.bits[1] & (bits1 ^ 0xFFFFFFFFFFFFFFFFL);
        }

        private void andNot(long bits) {
            this.bits[0] = this.bits[0] & (bits ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] | other.bits) == this.bits[0];
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] | other.bits0) == this.bits[0] && (this.bits[1] | other.bits1) == this.bits[1];
            }
            if (bitKey instanceof Big) {
                int i;
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    return false;
                }
                if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] & other.bits0) != 0L || (this.bits[1] & other.bits1) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                for (int i = 0; i < len; ++i) {
                    if ((this.bits[i] & other.bits[i]) == 0L) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            int pos = 0;
            for (int i = 0; i < this.bits.length; ++i) {
                Big.copyFromLong(bitSet, pos, this.bits[i]);
                pos += 64;
            }
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                long[] bits;
                int pos;
                int index;
                {
                    this.bits = (long[])Big.this.bits.clone();
                    this.pos = -1;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    long bs;
                    if (this.index >= this.bits.length) {
                        return false;
                    }
                    if (this.pos < 0) {
                        while (this.bits[this.index] == 0L) {
                            ++this.index;
                            if (this.index < this.bits.length) continue;
                            return false;
                        }
                        this.pos = 64 * this.index - 1;
                    }
                    if ((bs = this.bits[this.index]) == 0L) {
                        while (this.bits[this.index] == 0L) {
                            ++this.index;
                            if (this.index < this.bits.length) continue;
                            return false;
                        }
                        this.pos = 64 * this.index - 1;
                        bs = this.bits[this.index];
                    }
                    if (bs != 0L) {
                        if (bs == Long.MIN_VALUE) {
                            this.pos = 64 * this.index + 63;
                            this.bits[this.index] = 0L;
                            return true;
                        }
                        long b = bs & -bs;
                        int delta = 0;
                        while (b >= 256L) {
                            b >>= 8;
                            delta += 8;
                        }
                        int p = bitPositionTable[(int)b];
                        p = p >= 0 ? (p += delta) : delta;
                        this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                        this.bits[this.index] = this.bits[this.index] >>> p + 1;
                        return true;
                    }
                    return false;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                if (this.bits[0] != other.bits) {
                    return false;
                }
                for (int i = 1; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                if (this.bits[0] != other.bits0) {
                    return false;
                }
                if (this.bits[1] != other.bits1) {
                    return false;
                }
                for (int i = 2; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Big) {
                int i;
                Big other = (Big)o;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if (this.bits[i] == other.bits[i]) continue;
                    return false;
                }
                if (this.bits.length > other.bits.length) {
                    for (i = len; i < this.bits.length; ++i) {
                        if (this.bits[i] == 0L) continue;
                        return false;
                    }
                } else if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            int i = this.bits.length;
            while (--i >= 0) {
                h ^= this.bits[i] * (long)(i + 1);
            }
            return (int)(h >> 32 ^ h);
        }

        public String toString() {
            int start;
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            for (int i = start = this.bits.length * 64 - 1; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Big(this);
        }

        @Override
        public BitKey emptyCopy() {
            return new Big(this.bits.length << 6);
        }

        @Override
        public boolean isEmpty() {
            for (long bit : this.bits) {
                if (bit == 0L) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(BitKey bitKey) {
            return this.toString().compareTo(bitKey.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Mid128
    extends AbstractBitKey {
        private long bits0;
        private long bits1;

        private Mid128() {
        }

        private Mid128(Mid128 mid) {
            this.bits0 = mid.bits0;
            this.bits1 = mid.bits1;
        }

        @Override
        public void set(int pos) {
            if (pos < 64) {
                this.bits0 |= Mid128.bit(pos);
            } else if (pos < 128) {
                this.bits1 |= Mid128.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 128");
            }
        }

        @Override
        public boolean get(int pos) {
            if (pos < 64) {
                return (this.bits0 & Mid128.bit(pos)) != 0L;
            }
            if (pos < 128) {
                return (this.bits1 & Mid128.bit(pos)) != 0L;
            }
            return false;
        }

        @Override
        public void clear(int pos) {
            if (pos < 64) {
                this.bits0 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (pos < 128) {
                this.bits1 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw new IndexOutOfBoundsException("pos " + pos + " exceeds size " + 128);
            }
        }

        @Override
        public void clear() {
            this.bits0 = 0L;
            this.bits1 = 0L;
        }

        private void or(long bits0, long bits1) {
            this.bits0 |= bits0;
            this.bits1 |= bits1;
        }

        private void and(long bits0, long bits1) {
            this.bits0 &= bits0;
            this.bits1 &= bits1;
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits0, this.bits1);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.and(other.bits[0], other.bits[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.andNot(other.bits[0], other.bits[1]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits0, long bits1) {
            this.bits0 &= bits0 ^ 0xFFFFFFFFFFFFFFFFL;
            this.bits1 &= bits1 ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 | other.bits) == this.bits0;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 | other.bits0) == this.bits0 && (this.bits1 | other.bits1) == this.bits1;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 | other.bits[0]) != this.bits0) {
                    return false;
                }
                if ((this.bits1 | other.bits[1]) != this.bits1) {
                    return false;
                }
                for (int i = 2; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 & other.bits0) != 0L || (this.bits1 & other.bits1) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 & other.bits[0]) != 0L) {
                    return true;
                }
                return (this.bits1 & other.bits[1]) != 0L;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(128);
            Mid128.copyFromLong(bitSet, 0, this.bits0);
            Mid128.copyFromLong(bitSet, 64, this.bits1);
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                long bits0;
                long bits1;
                int pos;
                {
                    this.bits0 = Mid128.this.bits0;
                    this.bits1 = Mid128.this.bits1;
                    this.pos = -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.bits0 != 0L) {
                        if (this.bits0 == Long.MIN_VALUE) {
                            this.pos = 63;
                            this.bits0 = 0L;
                            return true;
                        }
                        long b = this.bits0 & -this.bits0;
                        int delta = 0;
                        while (b >= 256L) {
                            b >>= 8;
                            delta += 8;
                        }
                        int p = bitPositionTable[(int)b];
                        p = p >= 0 ? (p += delta) : delta;
                        this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                        this.bits0 >>>= p + 1;
                        return true;
                    }
                    if (this.pos < 63) {
                        this.pos = 63;
                    }
                    if (this.bits1 == Long.MIN_VALUE) {
                        this.pos = 127;
                        this.bits1 = 0L;
                        return true;
                    }
                    long b = this.bits1 & -this.bits1;
                    if (b == 0L) {
                        return false;
                    }
                    int delta = 0;
                    while (b >= 256L) {
                        b >>= 8;
                        delta += 8;
                    }
                    int p = bitPositionTable[(int)b];
                    p = p >= 0 ? (p += delta) : delta;
                    this.pos = this.pos < 0 ? p : (p == 63 ? ++this.pos : (this.pos += p + 1));
                    this.bits1 >>>= p + 1;
                    return true;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits0 == other.bits && this.bits1 == 0L;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits0 == other.bits0 && this.bits1 == other.bits1;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits0 != other.bits[0]) {
                    return false;
                }
                if (this.bits1 != other.bits[1]) {
                    return false;
                }
                for (int i = 2; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            h ^= this.bits0;
            return (int)((h ^= this.bits1 * 2L) >> 32 ^ h);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            for (int i = 127; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Mid128(this);
        }

        @Override
        public BitKey emptyCopy() {
            return new Mid128();
        }

        @Override
        public boolean isEmpty() {
            return this.bits0 == 0L && this.bits1 == 0L;
        }

        @Override
        public int compareTo(BitKey bitKey) {
            return this.toString().compareTo(bitKey.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Small
    extends AbstractBitKey {
        private long bits;

        private Small() {
        }

        private Small(long bits) {
            this.bits = bits;
        }

        @Override
        public void set(int pos) {
            if (pos < 64) {
                this.bits |= Small.bit(pos);
            } else {
                throw new IllegalArgumentException("pos " + pos + " exceeds capacity 64");
            }
        }

        @Override
        public boolean get(int pos) {
            return pos < 64 && (this.bits & Small.bit(pos)) != 0L;
        }

        @Override
        public void clear(int pos) {
            this.bits &= Small.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public void clear() {
            this.bits = 0L;
        }

        private void or(long bits) {
            this.bits |= bits;
        }

        private void and(long bits) {
            this.bits &= bits;
        }

        @Override
        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)other.copy();
                bk.or(this.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey and(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits0);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.and(other.bits[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        @Override
        public BitKey andNot(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits0);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Small bk = (Small)this.copy();
                bk.andNot(other.bits[0]);
                return bk;
            }
            throw this.createException(bitKey);
        }

        private void andNot(long bits) {
            this.bits &= bits ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits | other.bits) == this.bits;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits | other.bits0) == this.bits && other.bits1 == 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits | other.bits[0]) != this.bits) {
                    return false;
                }
                for (int i = 1; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits & other.bits) != 0L;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits & other.bits0) != 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                return (this.bits & other.bits[0]) != 0L;
            }
            return false;
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(64);
            long x = this.bits;
            int pos = 0;
            while (x != 0L) {
                Small.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>>= 8;
                pos += 8;
            }
            return bitSet;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                int pos = -1;
                long bits = Small.access$800(Small.this);

                @Override
                public boolean hasNext() {
                    if (this.bits == 0L) {
                        return false;
                    }
                    if (this.bits == Long.MIN_VALUE) {
                        this.pos = 63;
                        this.bits = 0L;
                        return true;
                    }
                    long b = this.bits & -this.bits;
                    if (b == 0L) {
                        return false;
                    }
                    int delta = 0;
                    while (b >= 256L) {
                        b >>= 8;
                        delta += 8;
                    }
                    int p = bitPositionTable[(int)b];
                    p = p >= 0 ? (p += delta) : delta;
                    this.pos = this.pos < 0 ? p : (p == 0 ? ++this.pos : (this.pos += p + 1));
                    this.bits >>>= p + 1;
                    return true;
                }

                @Override
                public Integer next() {
                    return this.pos;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits == other.bits;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits == other.bits0 && other.bits1 == 0L;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits != other.bits[0]) {
                    return false;
                }
                for (int i = 1; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.bits ^ this.bits >>> 32);
        }

        @Override
        public int compareTo(BitKey bitKey) {
            return this.toString().compareTo(bitKey.toString());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("0x");
            for (int i = 63; i >= 0; --i) {
                buf.append(this.get(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        @Override
        public BitKey copy() {
            return new Small(this.bits);
        }

        @Override
        public BitKey emptyCopy() {
            return new Small();
        }

        @Override
        public boolean isEmpty() {
            return this.bits == 0L;
        }
    }

    public static abstract class AbstractBitKey
    implements BitKey {
        protected static final int ChunkBitCount = 6;
        protected static final int Mask = 63;

        protected AbstractBitKey() {
        }

        protected static long bit(int pos) {
            return 1L << (pos & 0x3F);
        }

        protected static int chunkPos(int size) {
            return size >> 6;
        }

        protected static int chunkCount(int size) {
            return size + 63 >> 6;
        }

        public final void set(int pos, boolean value) {
            if (value) {
                this.set(pos);
            } else {
                this.clear(pos);
            }
        }

        protected static void copyFromByte(BitSet bitSet, int pos, byte x) {
            if (x == 0) {
                return;
            }
            if ((x & 1) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 2) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 4) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 8) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x10) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x20) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x40) != 0) {
                bitSet.set(pos, true);
            }
            ++pos;
            if ((x & 0x80) != 0) {
                bitSet.set(pos, true);
            }
        }

        protected static void copyFromLong(BitSet bitSet, int pos, long x) {
            while (x != 0L) {
                AbstractBitKey.copyFromByte(bitSet, pos, (byte)(x & 0xFFL));
                x >>>= 8;
                pos += 8;
            }
        }

        protected IllegalArgumentException createException(BitKey bitKey) {
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            return new IllegalArgumentException(msg);
        }
    }

    public static abstract class Factory {
        public static BitKey makeBitKey(int size) {
            if (size < 0) {
                String msg = "Negative size \"" + size + "\" not allowed";
                throw new IllegalArgumentException(msg);
            }
            if (size < 64) {
                return new Small();
            }
            if (size < 128) {
                return new Mid128();
            }
            return new Big(size);
        }

        public static BitKey makeBitKey(BitSet bitSet) {
            BitKey bitKey = Factory.makeBitKey(bitSet.length());
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                bitKey.set(i);
                i = bitSet.nextSetBit(i + 1);
            }
            return bitKey;
        }
    }
}

