/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger(RolapNativeSet.class);
    private SmartCache<Object, List<List<RolapMember>>> cache = new SoftSmartCache<Object, List<List<RolapMember>>>();

    protected abstract boolean restrictMemberTypes();

    protected CrossJoinArg checkDescendants(Role role, FunDef fun, Exp[] args) {
        if (!"Descendants".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        if (!(args[1] instanceof LevelExpr)) {
            return null;
        }
        RolapLevel level = (RolapLevel)((LevelExpr)args[1]).getLevel();
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkLevelMembers(Role role, FunDef fun, Exp[] args) {
        if (!"Members".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof LevelExpr)) {
            return null;
        }
        RolapLevel level = (RolapLevel)((LevelExpr)args[0]).getLevel();
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new DescendantsCrossJoinArg(level, null);
    }

    protected CrossJoinArg checkMemberChildren(Role role, FunDef fun, Exp[] args) {
        if (!"Children".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        RolapLevel level = member.getLevel();
        if ((level = (RolapLevel)level.getChildLevel()) == null || !RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkEnumeration(FunDef fun, Exp[] args) {
        if (!"{}".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof MemberExpr && !((MemberExpr)args[i]).getMember().isCalculated()) continue;
            return null;
        }
        return MemberListCrossJoinArg.create(args, this.restrictMemberTypes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CrossJoinArg[] checkCrossJoin(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        CrossJoinArg[] arg1;
        if (!"Crossjoin".equalsIgnoreCase(fun.getName()) && !"NonEmptyCrossJoin".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        ExpCompiler compiler = evaluator.getQuery().createCompiler();
        CrossJoinArg[] arg0 = this.checkCrossJoinArg(evaluator, args[0]);
        if (arg0 == null) {
            if (!MondrianProperties.instance().ExpandNonNative.get()) return null;
            ListCalc listCalc0 = compiler.compileList(args[0]);
            List list0 = listCalc0.evaluateList(evaluator);
            CrossJoinArg arg = MemberListCrossJoinArg.create(list0, this.restrictMemberTypes());
            if (arg == null) return null;
            arg0 = new CrossJoinArg[]{arg};
        }
        if ((arg1 = this.checkCrossJoinArg(evaluator, args[1])) == null) {
            if (!MondrianProperties.instance().ExpandNonNative.get()) return null;
            ListCalc listCalc1 = compiler.compileList(args[1]);
            List list1 = listCalc1.evaluateList(evaluator);
            CrossJoinArg arg = MemberListCrossJoinArg.create(list1, this.restrictMemberTypes());
            if (arg == null) return null;
            arg1 = new CrossJoinArg[]{arg};
        }
        CrossJoinArg[] ret = new CrossJoinArg[arg0.length + arg1.length];
        System.arraycopy(arg0, 0, ret, 0, arg0.length);
        System.arraycopy(arg1, 0, ret, arg0.length, arg1.length);
        return ret;
    }

    protected CrossJoinArg[] checkCrossJoinArg(RolapEvaluator evaluator, Exp exp) {
        if (exp instanceof NamedSetExpr) {
            NamedSet namedSet = ((NamedSetExpr)exp).getNamedSet();
            exp = namedSet.getExp();
        }
        if (!(exp instanceof ResolvedFunCall)) {
            return null;
        }
        ResolvedFunCall funCall = (ResolvedFunCall)exp;
        FunDef fun = funCall.getFunDef();
        Exp[] args = funCall.getArgs();
        Role role = evaluator.getSchemaReader().getRole();
        CrossJoinArg arg = this.checkMemberChildren(role, fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkLevelMembers(role, fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkDescendants(role, fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkEnumeration(fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        return this.checkCrossJoin(evaluator, fun, args);
    }

    protected static boolean isSimpleLevel(RolapLevel level) {
        RolapHierarchy hier = level.getHierarchy();
        if (hier.isRagged()) {
            return false;
        }
        if (level.isParentChild()) {
            return false;
        }
        return !level.isMeasure();
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args, boolean joinArg) {
        for (CrossJoinArg arg : args) {
            if (arg.isPreferInterpreter(joinArg)) continue;
            return false;
        }
        return true;
    }

    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache<Object, List<List<RolapMember>>>() : new SoftSmartCache<Object, List<List<RolapMember>>>();
    }

    protected RolapEvaluator overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        RolapEvaluator newEvaluator = evaluator.push();
        for (CrossJoinArg carg : cargs) {
            RolapHierarchy hierarchy = carg.getLevel().getHierarchy();
            Member defaultMember = schemaReader.getHierarchyDefaultMember(hierarchy);
            newEvaluator.setContext(defaultMember);
        }
        if (storedMeasure != null) {
            newEvaluator.setContext(storedMeasure);
        }
        return newEvaluator;
    }

    private static class SchemaReaderWithMemberReaderCache
    extends DelegatingSchemaReader
    implements SchemaReaderWithMemberReaderAvailable {
        private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();

        SchemaReaderWithMemberReaderCache(SchemaReader schemaReader) {
            super(schemaReader);
        }

        public synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
            MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
            if (memberReader == null) {
                memberReader = ((RolapHierarchy)hierarchy).createMemberReader(this.schemaReader.getRole());
                this.hierarchyReaders.put(hierarchy, memberReader);
            }
            return memberReader;
        }
    }

    public static interface SchemaReaderWithMemberReaderAvailable
    extends SchemaReader {
        public MemberReader getMemberReader(Hierarchy var1);
    }

    protected static class MemberListCrossJoinArg
    implements CrossJoinArg {
        private RolapMember[] members;
        private RolapLevel level = null;
        private boolean restrictMemberTypes;
        private boolean hasCalcMembers;
        private boolean hasNonCalcMembers;
        private boolean hasAllMember;

        private MemberListCrossJoinArg(RolapLevel level, RolapMember[] members, boolean restrictMemberTypes, boolean hasCalcMembers, boolean hasNonCalcMembers, boolean hasAllMember) {
            this.level = level;
            this.members = members;
            this.restrictMemberTypes = restrictMemberTypes;
            this.hasCalcMembers = hasCalcMembers;
            this.hasNonCalcMembers = hasNonCalcMembers;
            this.hasAllMember = hasAllMember;
        }

        static CrossJoinArg create(Exp[] args, boolean restrictMemberTypes) {
            if (args.length == 0) {
                return null;
            }
            RolapMember[] memberList = new RolapMember[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof MemberExpr)) {
                    return null;
                }
                memberList[i] = (RolapMember)((MemberExpr)args[i]).getMember();
            }
            return MemberListCrossJoinArg.create(memberList, restrictMemberTypes);
        }

        static CrossJoinArg create(List args, boolean restrictMemberTypes) {
            if (args.isEmpty()) {
                return null;
            }
            RolapMember[] memberList = new RolapMember[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                if (!(args.get(i) instanceof RolapMember)) {
                    return null;
                }
                memberList[i] = (RolapMember)args.get(i);
            }
            return MemberListCrossJoinArg.create(memberList, restrictMemberTypes);
        }

        static CrossJoinArg create(RolapMember[] args, boolean restrictMemberTypes) {
            RolapLevel level = null;
            RolapLevel nullLevel = null;
            boolean hasCalcMembers = false;
            boolean hasNonCalcMembers = false;
            boolean hasAllMember = false;
            if (args.length > MondrianProperties.instance().MaxConstraints.get()) {
                return null;
            }
            int nNullMembers = 0;
            for (int i = 0; i < args.length; ++i) {
                RolapMember m = args[i];
                if (m.isNull()) {
                    nullLevel = m.getLevel();
                    ++nNullMembers;
                    continue;
                }
                if (m.isAll()) {
                    hasAllMember = true;
                }
                if (m.isCalculated()) {
                    if (restrictMemberTypes) {
                        return null;
                    }
                    hasCalcMembers = true;
                } else {
                    hasNonCalcMembers = true;
                }
                if (level == null) {
                    level = m.getLevel();
                    continue;
                }
                if (level.equals(m.getLevel())) continue;
                return null;
            }
            if (level == null) {
                assert (nullLevel != null);
                level = nullLevel;
            }
            if (!RolapNativeSet.isSimpleLevel(level)) {
                return null;
            }
            RolapMember[] members = new RolapMember[args.length - nNullMembers];
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                RolapMember m = args[i];
                if (m.isNull()) continue;
                members[j] = m;
                ++j;
            }
            return new MemberListCrossJoinArg(level, members, restrictMemberTypes, hasCalcMembers, hasNonCalcMembers, hasAllMember);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public RolapMember[] getMembers() {
            return this.members;
        }

        public boolean isPreferInterpreter(boolean joinArg) {
            if (joinArg) {
                return this.hasCalcMembers && !this.hasNonCalcMembers;
            }
            return true;
        }

        public boolean hasCalcMembers() {
            return this.hasCalcMembers;
        }

        public boolean hasAllMember() {
            return this.hasAllMember;
        }

        public int hashCode() {
            int c = 12;
            for (RolapMember member : this.members) {
                c = 31 * c + member.hashCode();
            }
            if (this.restrictMemberTypes) {
                ++c;
            }
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberListCrossJoinArg)) {
                return false;
            }
            MemberListCrossJoinArg that = (MemberListCrossJoinArg)obj;
            if (this.restrictMemberTypes != that.restrictMemberTypes) {
                return false;
            }
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == that.members[i]) continue;
                return false;
            }
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube) {
            SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, null, Arrays.asList(this.members), this.restrictMemberTypes, true);
        }
    }

    protected static class DescendantsCrossJoinArg
    implements CrossJoinArg {
        RolapMember member;
        RolapLevel level;

        public DescendantsCrossJoinArg(RolapLevel level, RolapMember member) {
            this.level = level;
            this.member = member;
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public RolapMember[] getMembers() {
            if (this.member == null) {
                return null;
            }
            return new RolapMember[]{this.member};
        }

        public boolean isPreferInterpreter(boolean joinArg) {
            return false;
        }

        private boolean equals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescendantsCrossJoinArg)) {
                return false;
            }
            DescendantsCrossJoinArg that = (DescendantsCrossJoinArg)obj;
            if (!this.equals(this.level, that.level)) {
                return false;
            }
            return this.equals(this.member, that.member);
        }

        public int hashCode() {
            int c = 1;
            if (this.level != null) {
                c = this.level.hashCode();
            }
            if (this.member != null) {
                c = 31 * c + this.member.hashCode();
            }
            return c;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube) {
            if (this.member != null) {
                SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, null, this.member, true);
            }
        }
    }

    protected static interface CrossJoinArg {
        public RolapLevel getLevel();

        public RolapMember[] getMembers();

        public void addConstraint(SqlQuery var1, RolapCube var2);

        public boolean isPreferInterpreter(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SetEvaluator
    implements NativeEvaluator {
        private final CrossJoinArg[] args;
        private final SchemaReaderWithMemberReaderAvailable schemaReader;
        private final TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader instanceof SchemaReaderWithMemberReaderAvailable ? (SchemaReaderWithMemberReaderAvailable)schemaReader : new SchemaReaderWithMemberReaderCache(schemaReader);
            this.constraint = constraint;
        }

        @Override
        public Object execute(ResultStyle desiredResultStyle) {
            switch (desiredResultStyle) {
                case ITERABLE: {
                    return this.executeIterable();
                }
                case MUTABLE_LIST: 
                case LIST: {
                    return this.executeList();
                }
            }
            throw ResultStyleException.generate(ResultStyle.ITERABLE_MUTABLELIST_LIST, Collections.singletonList(desiredResultStyle));
        }

        protected Object executeIterable() {
            final List list = this.executeList();
            if (this.args.length == 1) {
                return new Iterable<Member>(){

                    @Override
                    public Iterator<Member> iterator() {
                        return new Iterator<Member>(){
                            int index = 0;

                            @Override
                            public boolean hasNext() {
                                return this.index < list.size();
                            }

                            @Override
                            public Member next() {
                                return (Member)list.get(this.index++);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("remove");
                            }
                        };
                    }
                };
            }
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < list.size();
                        }

                        @Override
                        public Member[] next() {
                            return (Member[])list.get(this.index++);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }

        protected List executeList() {
            RolapNative.TupleEvent e;
            boolean hasEnumTargets;
            SqlTupleReader tr = new SqlTupleReader(this.constraint);
            tr.setMaxRows(this.maxRows);
            for (CrossJoinArg arg : this.args) {
                this.addLevel(tr, arg);
            }
            Object key = tr.getCacheKey();
            List<Object> result = (List<RolapMember>)RolapNativeSet.this.cache.get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return this.copy(result);
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.excutingSql(e);
            }
            List<RolapMember> partialResult = result;
            result = null;
            ArrayList<List<RolapMember>> newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList<List<RolapMember>>();
            }
            DataSource dataSource = this.schemaReader.getDataSource();
            result = this.args.length == 1 ? tr.readMembers(dataSource, (List<List<RolapMember>>)partialResult, newPartialResult) : tr.readTuples(dataSource, (List<List<RolapMember>>)partialResult, newPartialResult);
            if (hasEnumTargets) {
                if (newPartialResult != null) {
                    RolapNativeSet.this.cache.put(key, newPartialResult);
                }
            } else {
                RolapNativeSet.this.cache.put(key, result);
            }
            return this.copy(result);
        }

        private <T> List<T> copy(List<T> list) {
            return new ArrayList<T>(list);
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            RolapHierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube) {
            super.addConstraint(sqlQuery, baseCube);
            for (CrossJoinArg arg : this.args) {
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) continue;
                arg.addConstraint(sqlQuery, baseCube);
            }
        }

        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            for (CrossJoinArg arg : this.args) {
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) continue;
                key.add(arg);
            }
            return key;
        }
    }
}

