/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItem;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItemClickHandler;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyNavigator;
import com.tonbeller.jpivot.navigator.member.MemberNavigator;
import com.tonbeller.jpivot.navigator.member.MemberSelectionModel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.ui.Available;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.tree.NodeSorter;
import com.tonbeller.wcf.tree.TreeModel;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public class Navigator
extends ComponentSupport
implements ModelChangeListener,
Available {
    OlapModel olapModel;
    MemberNavigator memberNav;
    HierarchyNavigator hierarchyNav;
    HierarchyItem currentItem;
    Component current;

    public Navigator(String id, Component parent, OlapModel olapModel) {
        super(id, parent);
        this.olapModel = olapModel;
        olapModel.addModelChangeListener(this);
        RequestListener acceptHandler = this.createMemberNavAcceptHandler();
        RequestListener cancelHandler = this.createMemberNavCancelHandler();
        this.memberNav = new MemberNavigator(id + ".membernav", (Component)this, olapModel, acceptHandler, cancelHandler);
        this.hierarchyNav = new HierarchyNavigator(id + ".hiernav", (Component)this, olapModel);
        if (this.memberNav.isAvailable()) {
            this.hierarchyNav.setHierarchyItemClickHandler(this.createHierarchyItemClickHandler());
        }
        this.current = this.hierarchyNav;
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.memberNav.initialize(context);
        this.hierarchyNav.initialize(context);
    }

    public void destroy(HttpSession session) throws Exception {
        this.memberNav.destroy(session);
        this.hierarchyNav.destroy(session);
        super.destroy(session);
    }

    public Document render(RequestContext context) throws Exception {
        return this.current.render(context);
    }

    public void show(Component component) {
        this.current = component == null ? this.hierarchyNav : component;
    }

    protected RequestListener createMemberNavAcceptHandler() {
        return new MemberNavAcceptHandler();
    }

    protected HierarchyItemClickHandler createHierarchyItemClickHandler() {
        return new HierarchyItemClickAdapter();
    }

    protected RequestListener createMemberNavCancelHandler() {
        return new MemberNavCancelHandler();
    }

    public boolean isVisible() {
        return this.hierarchyNav.isVisible();
    }

    public void setVisible(boolean visible) {
        this.hierarchyNav.setVisible(visible);
    }

    public void modelChanged(ModelChangeEvent e) {
        this.show((Component)this.hierarchyNav);
    }

    public void structureChanged(ModelChangeEvent e) {
        if (this.memberNav.isAvailable()) {
            this.hierarchyNav.setHierarchyItemClickHandler(this.createHierarchyItemClickHandler());
        } else {
            this.hierarchyNav.setHierarchyItemClickHandler(null);
        }
        this.show((Component)this.hierarchyNav);
    }

    public HierarchyNavigator getHierarchyNav() {
        return this.hierarchyNav;
    }

    public MemberNavigator getMemberNav() {
        return this.memberNav;
    }

    public boolean isAvailable() {
        return this.hierarchyNav.isAvailable();
    }

    private class MemberNavCancelHandler
    implements RequestListener {
        private MemberNavCancelHandler() {
        }

        public void request(RequestContext context) throws Exception {
            Navigator.this.memberNav.revert(context);
            Navigator.this.show((Component)Navigator.this.hierarchyNav);
        }
    }

    private class MemberNavAcceptHandler
    implements RequestListener {
        private MemberNavAcceptHandler() {
        }

        public void request(RequestContext context) throws Exception {
            boolean valid = Navigator.this.memberNav.validate(context);
            Set set = Navigator.this.memberNav.getSelectionModel().getSelection();
            List list = NodeSorter.preOrder((Set)set, (TreeModel)Navigator.this.memberNav.getModel());
            String errmesg = Navigator.this.currentItem.validateSelection(list);
            if (errmesg != null) {
                Navigator.this.memberNav.setError(errmesg);
            } else if (valid) {
                Navigator.this.currentItem.setSelection(list);
                Navigator.this.currentItem.setDeleted(Navigator.this.memberNav.getDeleteNodeModel().getDeleted());
                Navigator.this.show((Component)Navigator.this.hierarchyNav);
            }
        }
    }

    private class HierarchyItemClickAdapter
    implements HierarchyItemClickHandler {
        private HierarchyItemClickAdapter() {
        }

        public void itemClicked(RequestContext context, HierarchyItem item, MemberSelectionModel selection, boolean allowChangeOrder) {
            Navigator.this.currentItem = item;
            Hierarchy[] hiers = item.getDimension().getHierarchies();
            Navigator.this.memberNav.setHierarchies(hiers, allowChangeOrder, selection, item.getDeleted());
            Navigator.this.show((Component)Navigator.this.memberNav);
        }
    }
}

