/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.table.ColumnAxisConfig;
import com.tonbeller.jpivot.table.RowAxisConfig;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.wcf.controller.RequestContext;
import java.io.Serializable;

public class AxisStyleUI
extends TableComponentExtensionSupport {
    public static final String ID = "axisStyle";
    boolean levelStyle = true;
    boolean hideSpans = false;

    public String getId() {
        return ID;
    }

    public boolean isHideSpans() {
        return this.hideSpans;
    }

    public boolean isLevelStyle() {
        return this.levelStyle;
    }

    public void setHideSpans(boolean hideSpans) {
        if (this.table == null) {
            return;
        }
        this.hideSpans = hideSpans;
        RowAxisConfig rac = (RowAxisConfig)this.table.getRowAxisBuilder().getAxisConfig();
        ColumnAxisConfig cac = (ColumnAxisConfig)this.table.getColumnAxisBuilder().getAxisConfig();
        if (hideSpans) {
            rac.setMemberSpan(1);
            cac.setMemberSpan(1);
        } else {
            rac.setMemberSpan(3);
            cac.setMemberSpan(3);
        }
    }

    public void setLevelStyle(boolean levelStyle) {
        if (this.table == null) {
            return;
        }
        this.levelStyle = levelStyle;
        RowAxisConfig rac = (RowAxisConfig)this.table.getRowAxisBuilder().getAxisConfig();
        ColumnAxisConfig cac = (ColumnAxisConfig)this.table.getColumnAxisBuilder().getAxisConfig();
        if (levelStyle) {
            rac.setShowParentMembers(true);
            cac.setShowParentMembers(true);
            rac.setMemberIndent(false);
            rac.setPositionHeader(3);
        } else {
            rac.setShowParentMembers(false);
            cac.setShowParentMembers(false);
            rac.setMemberIndent(true);
            rac.setPositionHeader(1);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        this.setLevelStyle(this.levelStyle);
        this.setHideSpans(this.hideSpans);
    }

    public Object getBookmarkState(int levelOfDetail) {
        BookmarkState x = new BookmarkState();
        x.setLevelStyle(this.isLevelStyle());
        x.setHideSpans(this.isHideSpans());
        return x;
    }

    public void setBookmarkState(Object state) {
        if (!(state instanceof BookmarkState)) {
            return;
        }
        BookmarkState x = (BookmarkState)state;
        this.setLevelStyle(x.isLevelStyle());
        this.setHideSpans(x.isHideSpans());
    }

    public static class BookmarkState
    implements Serializable {
        boolean levelStyle = false;
        boolean hideSpans = false;

        public boolean isHideSpans() {
            return this.hideSpans;
        }

        public boolean isLevelStyle() {
            return this.levelStyle;
        }

        public void setHideSpans(boolean b) {
            this.hideSpans = b;
        }

        public void setLevelStyle(boolean b) {
            this.levelStyle = b;
        }
    }
}

