/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.EJBQLConnection;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EJBQLConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private JLabel jLabel1;
    private JLabel jLabel18;
    private JPanel jPanelEJBQL;
    private JTextField jTextFieldPersistanceUnit;

    public EJBQLConnectionEditor() {
        this.initComponents();
        this.applyI18n();
    }

    private void initComponents() {
        this.jPanelEJBQL = new JPanel();
        this.jLabel18 = new JLabel();
        this.jTextFieldPersistanceUnit = new JTextField();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelEJBQL.setLayout(new GridBagLayout());
        this.jLabel18.setText("Persistance Unit Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelEJBQL.add((Component)this.jLabel18, gridBagConstraints);
        this.jTextFieldPersistanceUnit.setMargin(new Insets(0, 5, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 3, 4);
        this.jPanelEJBQL.add((Component)this.jTextFieldPersistanceUnit, gridBagConstraints);
        this.jLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelEJBQL.add((Component)this.jLabel1, gridBagConstraints);
        this.add((Component)this.jPanelEJBQL, "Center");
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof EJBQLConnection) {
            EJBQLConnection con = (EJBQLConnection)this.iReportConnection;
            this.jTextFieldPersistanceUnit.setText(Misc.nvl(con.getProperties().get("PersistenceUnit"), ""));
        }
    }

    public IReportConnection getIReportConnection() {
        EJBQLConnection irConn = new EJBQLConnection();
        if (this.jTextFieldPersistanceUnit.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.connectionDialog.ejbql.invalidPersistenceUnit", "Please specify a valid PersistenceUnit"), I18n.getString("messages.connectionDialog.invalidPersistenceUnitCaption", "Invalid PersistenceUnit!"), 2);
            return null;
        }
        ((IReportConnection)irConn).getProperties().put("PersistenceUnit", this.jTextFieldPersistanceUnit.getText().trim());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    public void applyI18n() {
        this.jLabel18.setText(I18n.getString("connectionDialog.label18", "Persistance Unit Name"));
        this.jLabel1.setText("<html>" + I18n.getString("connectionDialog.textPane2", "iReport will search for persistence.xml files within the META-INF directory of any CLASSPATH element"));
    }
}

